/*
 * Decompiled with CFR 0.152.
 */
package net.sbo.mod.utils.render;

import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import net.minecraft.class_9974;
import net.sbo.mod.SBOKotlin;
import net.sbo.mod.mixin.accessor.BeaconBlockEntityRendererInvoker;
import net.sbo.mod.settings.categories.Customization;
import net.sbo.mod.utils.math.SboVec;
import net.sbo.mod.utils.render.SboRenderLayers;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionfc;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0011\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J]\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0016\u0010\u0017JM\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001c\u0010\u001dJM\u0010\"\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\"\u0010#J-\u0010$\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b$\u0010%J?\u0010'\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lnet/sbo/mod/utils/render/RenderUtil;", "", "<init>", "()V", "Lnet/fabricmc/fabric/api/client/rendering/v1/WorldRenderContext;", "context", "", "text", "Lnet/sbo/mod/utils/math/SboVec;", "pos", "", "colorComponents", "", "hexColor", "", "alpha", "", "throughWalls", "drawLine", "lineWidth", "renderBeam", "", "renderWaypoint", "(Lnet/fabricmc/fabric/api/client/rendering/v1/WorldRenderContext;Ljava/lang/String;Lnet/sbo/mod/utils/math/SboVec;[FIFZZFZ)V", "", "width", "height", "depth", "drawFilledBox", "(Lnet/fabricmc/fabric/api/client/rendering/v1/WorldRenderContext;Lnet/sbo/mod/utils/math/SboVec;DDD[FFZ)V", "yOffset", "color", "shadow", "scale", "drawString", "(Lnet/fabricmc/fabric/api/client/rendering/v1/WorldRenderContext;Lnet/sbo/mod/utils/math/SboVec;DLjava/lang/String;IZDZ)V", "renderBeaconBeam", "(Lnet/fabricmc/fabric/api/client/rendering/v1/WorldRenderContext;Lnet/sbo/mod/utils/math/SboVec;I[F)V", "target", "drawLineFromCursor", "(Lnet/fabricmc/fabric/api/client/rendering/v1/WorldRenderContext;Lnet/sbo/mod/utils/math/SboVec;[FFZF)V", "sbo"})
public final class RenderUtil {
    @NotNull
    public static final RenderUtil INSTANCE = new RenderUtil();

    private RenderUtil() {
    }

    public final void renderWaypoint(@NotNull WorldRenderContext context, @NotNull String text, @NotNull SboVec pos, @NotNull float[] colorComponents, int hexColor, float alpha, boolean throughWalls, boolean drawLine, float lineWidth, boolean renderBeam) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)colorComponents, (String)"colorComponents");
        this.drawFilledBox(context, pos, 1.0, 1.0, 1.0, colorComponents, alpha, throughWalls);
        if (drawLine) {
            this.drawLineFromCursor(context, pos, colorComponents, lineWidth, throughWalls, alpha);
        }
        if (renderBeam) {
            this.renderBeaconBeam(context, pos, 1, colorComponents);
        }
        if (((CharSequence)text).length() > 0 && !Intrinsics.areEqual((Object)text, (Object)"\u00a77")) {
            this.drawString(context, pos, 1.5, text, hexColor, Customization.INSTANCE.getWaypointTextShadow(), (double)Customization.INSTANCE.getWaypointTextScale() / 100.0, throughWalls);
        }
    }

    public final void drawFilledBox(@NotNull WorldRenderContext context, @NotNull SboVec pos, double width, double height, double depth, @NotNull float[] colorComponents, float alpha, boolean throughWalls) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)colorComponents, (String)"colorComponents");
        class_4587 matrices = context.matrixStack();
        class_243 cameraPos = context.camera().method_19326();
        class_4587 class_45872 = matrices;
        Intrinsics.checkNotNull((Object)class_45872);
        class_45872.method_22903();
        matrices.method_22904(pos.getX() + 0.5 - cameraPos.field_1352, pos.getY() - cameraPos.field_1351, pos.getZ() + 0.5 - cameraPos.field_1350);
        class_4597 class_45972 = context.consumers();
        Intrinsics.checkNotNull((Object)class_45972);
        class_4597 consumers = class_45972;
        class_1921.class_4687 renderLayer = throughWalls ? SboRenderLayers.FILLED_BOX_THROUGH_WALLS : SboRenderLayers.FILLED_BOX;
        class_4588 buffer = consumers.getBuffer((class_1921)renderLayer);
        double minX = -width / 2.0;
        double minZ = -depth / 2.0;
        double maxX = width / 2.0;
        double maxZ = depth / 2.0;
        double minY = 0.0;
        double maxY = height;
        class_9974.method_62300((class_4587)matrices, (class_4588)buffer, (double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (float)colorComponents[0], (float)colorComponents[1], (float)colorComponents[2], (float)alpha);
        matrices.method_22909();
    }

    public final void drawString(@NotNull WorldRenderContext context, @NotNull SboVec pos, double yOffset, @NotNull String text, int color, boolean shadow, double scale, boolean throughWalls) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        class_4587 matrices = context.matrixStack();
        class_4184 camera = context.camera();
        class_243 cameraPos = camera.method_19326();
        float cameraYaw = camera.method_19330();
        float cameraPitch = camera.method_19329();
        class_327 textRenderer = SBOKotlin.mc.field_1772;
        class_4587 class_45872 = matrices;
        Intrinsics.checkNotNull((Object)class_45872);
        class_45872.method_22903();
        class_243 textWorldPos = new class_243(pos.getX() + 0.5, pos.getY() + 0.5, pos.getZ() + 0.5);
        double distance = cameraPos.method_1022(textWorldPos);
        double dynamicScale = Math.max(distance, 2.5) * scale;
        matrices.method_22904(pos.getX() + 0.5 - cameraPos.field_1352, pos.getY() + yOffset + -cameraPos.field_1351, pos.getZ() + 0.5 - cameraPos.field_1350);
        matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(-cameraYaw));
        matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(cameraPitch));
        matrices.method_22905(-((float)dynamicScale), -((float)dynamicScale), (float)dynamicScale);
        int textWidth = textRenderer.method_1727(text);
        float xOffset = (float)(-textWidth) / 2.0f;
        class_4597 class_45972 = context.consumers();
        Intrinsics.checkNotNull((Object)class_45972);
        class_4597 consumers = class_45972;
        class_327.class_6415 layerType = throughWalls ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993;
        textRenderer.method_27521(text, xOffset, 0.0f, color, shadow, matrices.method_23760().method_23761(), consumers, layerType, 0, 0xF000F0);
        matrices.method_22909();
    }

    public final void renderBeaconBeam(@NotNull WorldRenderContext context, @NotNull SboVec pos, int yOffset, @NotNull float[] colorComponents) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)colorComponents, (String)"colorComponents");
        class_4587 class_45872 = context.matrixStack();
        Intrinsics.checkNotNull((Object)class_45872);
        class_4587 matrices = class_45872;
        class_243 cameraPos = context.camera().method_19326();
        class_638 world = context.world();
        matrices.method_22903();
        matrices.method_22904(pos.getX() - cameraPos.field_1352, pos.getY() - cameraPos.field_1351, pos.getZ() - cameraPos.field_1350);
        class_4597 class_45972 = context.consumers();
        Intrinsics.checkNotNull((Object)class_45972);
        class_4597 consumers = class_45972;
        float partialTicks = context.tickCounter().method_60637(true);
        long worldAge = world.method_8510();
        int beamHeight = context.world().method_31605();
        float[] fArray = new float[]{colorComponents[0], colorComponents[1], colorComponents[2], 1.0f};
        float[] beamColor = fArray;
        BeaconBlockEntityRendererInvoker.renderBeam(matrices, consumers, partialTicks, 1.0f, worldAge, yOffset, beamHeight, new Color(beamColor[0], beamColor[1], beamColor[2]).getRGB());
        matrices.method_22909();
    }

    public final void drawLineFromCursor(@NotNull WorldRenderContext context, @NotNull SboVec target, @NotNull float[] color, float lineWidth, boolean throughWalls, float alpha) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        class_4184 camera = context.camera();
        class_243 cameraPos = camera.method_19326();
        class_4587 class_45872 = context.matrixStack();
        Intrinsics.checkNotNull((Object)class_45872);
        class_4587 matrices = class_45872;
        matrices.method_22903();
        matrices.method_22904(-cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350);
        class_4597 class_45972 = context.consumers();
        Intrinsics.checkNotNull((Object)class_45972);
        class_4597 consumers = class_45972;
        class_243 startPos = cameraPos.method_1019(class_243.method_1030((float)camera.method_19329(), (float)camera.method_19330()));
        class_243 endPos = target.center().toVec3d().method_1031(0.0, 0.5, 0.0);
        class_243 lineDir = endPos.method_1020(startPos);
        class_243 viewDir = startPos.method_1020(cameraPos);
        class_243 sideVec = lineDir.method_1036(viewDir).method_1029();
        class_243 upVec = sideVec.method_1036(lineDir).method_1029();
        float nx = (float)upVec.field_1352;
        float ny = (float)upVec.field_1351;
        float nz = (float)upVec.field_1350;
        class_1921 renderLayer = SboRenderLayers.INSTANCE.getLines(lineWidth, throughWalls);
        class_4588 buffer = consumers.getBuffer(renderLayer);
        class_4587.class_4665 matrixEntry = matrices.method_23760();
        buffer.method_56824(matrixEntry, (float)startPos.field_1352, (float)startPos.field_1351, (float)startPos.field_1350).method_60831(matrixEntry, nx, ny, nz).method_22915(color[0], color[1], color[2], alpha);
        buffer.method_56824(matrixEntry, (float)endPos.field_1352, (float)endPos.field_1351, (float)endPos.field_1350).method_60831(matrixEntry, nx, ny, nz).method_22915(color[0], color[1], color[2], alpha);
        matrices.method_22909();
    }

    public static /* synthetic */ void drawLineFromCursor$default(RenderUtil renderUtil, WorldRenderContext worldRenderContext, SboVec sboVec, float[] fArray, float f, boolean bl, float f2, int n, Object object) {
        if ((n & 0x20) != 0) {
            f2 = 0.5f;
        }
        renderUtil.drawLineFromCursor(worldRenderContext, sboVec, fArray, f, bl, f2);
    }
}

