/*
 * Decompiled with CFR 0.152.
 */
package net.sbo.mod.utils.waypoint;

import java.awt.Color;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.sbo.mod.settings.categories.Customization;
import net.sbo.mod.settings.categories.Diana;
import net.sbo.mod.utils.Player;
import net.sbo.mod.utils.math.SboVec;
import net.sbo.mod.utils.render.RenderUtil;
import net.sbo.mod.utils.waypoint.WaypointManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\t\n\u0002\b\u0015\u0018\u00002\u00020\u0001Bq\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J#\u0010\u001d\u001a\u00020\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00000\u001a2\u0006\u0010\u001c\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\r\u0010\u001f\u001a\u00020\u0000\u00a2\u0006\u0004\b\u001f\u0010 J\r\u0010!\u001a\u00020\u0000\u00a2\u0006\u0004\b!\u0010 J\u0015\u0010$\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\"\u00a2\u0006\u0004\b$\u0010%R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010&\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010+\u001a\u0004\b,\u0010\u0016R\u0017\u0010\u0006\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010+\u001a\u0004\b-\u0010\u0016R\u0017\u0010\u0007\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010+\u001a\u0004\b.\u0010\u0016R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010/\u001a\u0004\b0\u00101R\u0017\u0010\n\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010/\u001a\u0004\b2\u00101R\u0017\u0010\u000b\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010/\u001a\u0004\b3\u00101R\u0017\u0010\r\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b\r\u00104\u001a\u0004\b5\u00106R\u0017\u0010\u000e\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010&\u001a\u0004\b7\u0010(R\"\u0010\u0010\u001a\u00020\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0010\u00108\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\"\u0010\u0011\u001a\u00020\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u00108\u001a\u0004\b=\u0010:\"\u0004\b>\u0010<R\"\u0010\u0012\u001a\u00020\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u00108\u001a\u0004\b?\u0010:\"\u0004\b@\u0010<R\"\u0010B\u001a\u00020A8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bB\u0010C\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR\"\u0010I\u001a\u00020H8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bI\u0010J\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR\"\u0010O\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bO\u00104\u001a\u0004\bP\u00106\"\u0004\bQ\u0010RR\u001a\u0010S\u001a\u00020\u00048\u0006X\u0086D\u00a2\u0006\f\n\u0004\bS\u0010+\u001a\u0004\bT\u0010\u0016R\"\u0010U\u001a\u00020\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bU\u00108\u001a\u0004\bV\u0010:\"\u0004\bW\u0010<R\u0017\u0010Y\u001a\u00020X8\u0006\u00a2\u0006\f\n\u0004\bY\u0010Z\u001a\u0004\b[\u0010\\R\"\u0010]\u001a\u00020\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b]\u00108\u001a\u0004\b^\u0010:\"\u0004\b_\u0010<R\"\u0010`\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b`\u0010+\u001a\u0004\ba\u0010\u0016\"\u0004\bb\u0010cR\"\u0010d\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bd\u0010&\u001a\u0004\be\u0010(\"\u0004\bf\u0010*R\"\u0010g\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bg\u0010&\u001a\u0004\bh\u0010(\"\u0004\bi\u0010*R$\u0010j\u001a\u0004\u0018\u00010\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bj\u0010&\u001a\u0004\bk\u0010(\"\u0004\bl\u0010*\u00a8\u0006m"}, d2={"Lnet/sbo/mod/utils/waypoint/Waypoint;", "", "", "text", "", "x", "y", "z", "", "r", "g", "b", "", "ttl", "type", "", "line", "beam", "distance", "<init>", "(Ljava/lang/String;DDDFFFILjava/lang/String;ZZZ)V", "distanceToPlayer", "()D", "", "setWarpText", "()V", "", "inqWaypoints", "closestBurrowDistance", "format", "(Ljava/util/List;D)V", "hide", "()Lnet/sbo/mod/utils/waypoint/Waypoint;", "show", "Lnet/fabricmc/fabric/api/client/rendering/v1/WorldRenderContext;", "context", "render", "(Lnet/fabricmc/fabric/api/client/rendering/v1/WorldRenderContext;)V", "Ljava/lang/String;", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "D", "getX", "getY", "getZ", "F", "getR", "()F", "getG", "getB", "I", "getTtl", "()I", "getType", "Z", "getLine", "()Z", "setLine", "(Z)V", "getBeam", "setBeam", "getDistance", "setDistance", "Lnet/sbo/mod/utils/math/SboVec;", "pos", "Lnet/sbo/mod/utils/math/SboVec;", "getPos", "()Lnet/sbo/mod/utils/math/SboVec;", "setPos", "(Lnet/sbo/mod/utils/math/SboVec;)V", "Ljava/awt/Color;", "color", "Ljava/awt/Color;", "getColor", "()Ljava/awt/Color;", "setColor", "(Ljava/awt/Color;)V", "hexCode", "getHexCode", "setHexCode", "(I)V", "alpha", "getAlpha", "hidden", "getHidden", "setHidden", "", "creation", "J", "getCreation", "()J", "formatted", "getFormatted", "setFormatted", "distanceRaw", "getDistanceRaw", "setDistanceRaw", "(D)V", "distanceText", "getDistanceText", "setDistanceText", "formattedText", "getFormattedText", "setFormattedText", "warp", "getWarp", "setWarp", "sbo"})
@SourceDebugExtension(value={"SMAP\nWaypoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Waypoint.kt\nnet/sbo/mod/utils/waypoint/Waypoint\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1#2:123\n*E\n"})
public final class Waypoint {
    @NotNull
    private String text;
    private final double x;
    private final double y;
    private final double z;
    private final float r;
    private final float g;
    private final float b;
    private final int ttl;
    @NotNull
    private final String type;
    private boolean line;
    private boolean beam;
    private boolean distance;
    @NotNull
    private SboVec pos;
    @NotNull
    private Color color;
    private int hexCode;
    private final double alpha;
    private boolean hidden;
    private final long creation;
    private boolean formatted;
    private double distanceRaw;
    @NotNull
    private String distanceText;
    @NotNull
    private String formattedText;
    @Nullable
    private String warp;

    public Waypoint(@NotNull String text, double x, double y, double z, float r, float g, float b, int ttl, @NotNull String type, boolean line, boolean beam, boolean distance) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.text = text;
        this.x = x;
        this.y = y;
        this.z = z;
        this.r = r;
        this.g = g;
        this.b = b;
        this.ttl = ttl;
        this.type = type;
        this.line = line;
        this.beam = beam;
        this.distance = distance;
        this.pos = new SboVec(this.x, this.y, this.z);
        this.color = new Color(this.r, this.g, this.b);
        this.hexCode = this.color.getRGB();
        this.alpha = 0.5;
        this.creation = System.currentTimeMillis();
        this.distanceText = "";
        this.formattedText = "";
    }

    public /* synthetic */ Waypoint(String string, double d, double d2, double d3, float f, float f2, float f3, int n, String string2, boolean bl, boolean bl2, boolean bl3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x80) != 0) {
            n = 0;
        }
        if ((n2 & 0x100) != 0) {
            string2 = "normal";
        }
        if ((n2 & 0x200) != 0) {
            bl = false;
        }
        if ((n2 & 0x400) != 0) {
            bl2 = true;
        }
        if ((n2 & 0x800) != 0) {
            bl3 = true;
        }
        this(string, d, d2, d3, f, f2, f3, n, string2, bl, bl2, bl3);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final void setText(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.text = string;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    public final float getR() {
        return this.r;
    }

    public final float getG() {
        return this.g;
    }

    public final float getB() {
        return this.b;
    }

    public final int getTtl() {
        return this.ttl;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    public final boolean getLine() {
        return this.line;
    }

    public final void setLine(boolean bl) {
        this.line = bl;
    }

    public final boolean getBeam() {
        return this.beam;
    }

    public final void setBeam(boolean bl) {
        this.beam = bl;
    }

    public final boolean getDistance() {
        return this.distance;
    }

    public final void setDistance(boolean bl) {
        this.distance = bl;
    }

    @NotNull
    public final SboVec getPos() {
        return this.pos;
    }

    public final void setPos(@NotNull SboVec sboVec) {
        Intrinsics.checkNotNullParameter((Object)sboVec, (String)"<set-?>");
        this.pos = sboVec;
    }

    @NotNull
    public final Color getColor() {
        return this.color;
    }

    public final void setColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.color = color;
    }

    public final int getHexCode() {
        return this.hexCode;
    }

    public final void setHexCode(int n) {
        this.hexCode = n;
    }

    public final double getAlpha() {
        return this.alpha;
    }

    public final boolean getHidden() {
        return this.hidden;
    }

    public final void setHidden(boolean bl) {
        this.hidden = bl;
    }

    public final long getCreation() {
        return this.creation;
    }

    public final boolean getFormatted() {
        return this.formatted;
    }

    public final void setFormatted(boolean bl) {
        this.formatted = bl;
    }

    public final double getDistanceRaw() {
        return this.distanceRaw;
    }

    public final void setDistanceRaw(double d) {
        this.distanceRaw = d;
    }

    @NotNull
    public final String getDistanceText() {
        return this.distanceText;
    }

    public final void setDistanceText(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.distanceText = string;
    }

    @NotNull
    public final String getFormattedText() {
        return this.formattedText;
    }

    public final void setFormattedText(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.formattedText = string;
    }

    @Nullable
    public final String getWarp() {
        return this.warp;
    }

    public final void setWarp(@Nullable String string) {
        this.warp = string;
    }

    public final double distanceToPlayer() {
        SboVec playerPos = Player.INSTANCE.getLastPosition();
        return Math.sqrt(Math.pow(playerPos.getX() - this.pos.getX(), 2) + Math.pow(playerPos.getY() - this.pos.getY(), 2) + Math.pow(playerPos.getZ() - this.pos.getZ(), 2));
    }

    private final void setWarpText() {
        Object object;
        block3: {
            block2: {
                this.warp = WaypointManager.INSTANCE.getClosestWarp(this.pos);
                Waypoint waypoint = this;
                object = this.warp;
                if (object == null) break block2;
                String it = object;
                Waypoint waypoint2 = waypoint;
                boolean bl = false;
                String string = this.text + "\u00a77 (warp " + it + ")" + this.distanceText;
                waypoint = waypoint2;
                object = string;
                if (string != null) break block3;
            }
            object = this.text + this.distanceText;
        }
        waypoint.formattedText = object;
    }

    public final void format(@NotNull List<Waypoint> inqWaypoints, double closestBurrowDistance) {
        Intrinsics.checkNotNullParameter(inqWaypoints, (String)"inqWaypoints");
        this.distanceRaw = this.distanceToPlayer();
        String string = this.distanceText = this.distance ? " \u00a7b[" + MathKt.roundToInt((double)this.distanceRaw) + "m]" : "";
        if (Intrinsics.areEqual((Object)this.type, (Object)"guess")) {
            this.line = Diana.INSTANCE.getGuessLine() && closestBurrowDistance > 60.0 && inqWaypoints.isEmpty();
            this.color = new Color(Customization.INSTANCE.getGuessColor());
            this.hexCode = this.color.getRGB();
            Pair<Boolean, Waypoint> pair = WaypointManager.INSTANCE.waypointExists("burrow", this.pos);
            boolean exists = (Boolean)pair.component1();
            Waypoint wp = (Waypoint)pair.component2();
            if (exists && wp != null) {
                this.hidden = wp.distanceToPlayer() < 60.0;
            }
            this.setWarpText();
        } else if (Intrinsics.areEqual((Object)this.type, (Object)"inq") && Intrinsics.areEqual((Object)CollectionsKt.lastOrNull(inqWaypoints), (Object)this)) {
            this.setWarpText();
            this.line = Diana.INSTANCE.getInqLine();
        } else {
            this.formattedText = this.text + this.distanceText;
        }
        this.formatted = true;
    }

    @NotNull
    public final Waypoint hide() {
        this.hidden = true;
        return this;
    }

    @NotNull
    public final Waypoint show() {
        this.hidden = false;
        return this;
    }

    public final void render(@NotNull WorldRenderContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!this.formatted || this.hidden) {
            return;
        }
        if (Intrinsics.areEqual((Object)this.type, (Object)"guess") && this.distanceRaw <= (double)Diana.INSTANCE.getRemoveGuessDistance()) {
            return;
        }
        float[] fArray = new float[]{this.r, this.g, this.b};
        RenderUtil.INSTANCE.renderWaypoint(context, this.formattedText, this.pos, fArray, this.hexCode, (float)this.alpha, true, this.line, Diana.INSTANCE.getDianaLineWidth(), this.beam);
    }
}

