/*
 * Decompiled with CFR 0.152.
 */
package net.sbo.mod.diana;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.class_2561;
import net.sbo.mod.diana.DianaMobDetect;
import net.sbo.mod.diana.achievements.AchievementManager;
import net.sbo.mod.overlays.DianaLoot;
import net.sbo.mod.overlays.DianaMobs;
import net.sbo.mod.overlays.DianaStats;
import net.sbo.mod.overlays.InquisLoot;
import net.sbo.mod.overlays.MagicFind;
import net.sbo.mod.settings.categories.Customization;
import net.sbo.mod.settings.categories.Diana;
import net.sbo.mod.settings.categories.QOL;
import net.sbo.mod.utils.Helper;
import net.sbo.mod.utils.Player;
import net.sbo.mod.utils.SboTimerManager;
import net.sbo.mod.utils.SoundHandler;
import net.sbo.mod.utils.chat.Chat;
import net.sbo.mod.utils.data.DianaInquisData;
import net.sbo.mod.utils.data.DianaItemsData;
import net.sbo.mod.utils.data.DianaMobsData;
import net.sbo.mod.utils.data.Item;
import net.sbo.mod.utils.data.PastDianaEventsData;
import net.sbo.mod.utils.data.SboData;
import net.sbo.mod.utils.data.SboDataObject;
import net.sbo.mod.utils.events.Register;
import net.sbo.mod.utils.game.Mayor;
import net.sbo.mod.utils.game.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0015\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0015\u0010\u0003J\r\u0010\u0016\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0016\u0010\u0003J\r\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0017\u0010\u0003J\r\u0010\u0018\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0018\u0010\u0003J\r\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0019\u0010\u0003J+\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u000e2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\r\u0010\u001f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001f\u0010\u0003J\u001f\u0010!\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\n\u00a2\u0006\u0004\b!\u0010\"J\r\u0010#\u001a\u00020\u0004\u00a2\u0006\u0004\b#\u0010\u0003J\u001d\u0010$\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b$\u0010\u0011J'\u0010&\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010%\u001a\u00020\u001b\u00a2\u0006\u0004\b&\u0010'J/\u0010*\u001a\u00020\u00042\u0006\u0010)\u001a\u00020(2\u0006\u0010\u0007\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010%\u001a\u00020\u001b\u00a2\u0006\u0004\b*\u0010+R \u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u001a\u00100\u001a\b\u0012\u0004\u0012\u00020\u000e0/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101R\u001a\u00102\u001a\b\u0012\u0004\u0012\u00020\u000e0/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u00101R\u001a\u00103\u001a\b\u0012\u0004\u0012\u00020\u00120/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00101R\u001a\u00105\u001a\b\u0012\u0004\u0012\u00020\u000e048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00101R\u0016\u00106\u001a\u00020\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b6\u00107\u00a8\u00068"}, d2={"Lnet/sbo/mod/diana/DianaTracker;", "", "<init>", "()V", "", "init", "Lnet/sbo/mod/utils/data/Item;", "item", "trackWithPickuplog", "(Lnet/sbo/mod/utils/data/Item;)V", "", "amount", "trackWithPickuplogStackable", "(Lnet/sbo/mod/utils/data/Item;I)V", "", "itemName", "trackWithSacksMessage", "(Ljava/lang/String;I)V", "", "trackScavengerCoins", "(J)V", "trackMobsWithChat", "trackCoinsWithChat", "trackTreasuresWithChat", "trackRngDropsWithChat", "trackBurrowsWithChat", "customMsg", "", "replaceChimMessage", "announceLootToParty", "(Ljava/lang/String;Ljava/lang/String;Z)V", "sendLootAnnouncement", "streak", "getB2BMessage", "(Ljava/lang/String;I)Ljava/lang/String;", "checkMayorTracker", "trackMob", "fromInq", "trackItem", "(Ljava/lang/String;IZ)V", "Lnet/sbo/mod/utils/data/DianaTracker;", "tracker", "trackOne", "(Lnet/sbo/mod/utils/data/DianaTracker;Ljava/lang/String;IZ)V", "", "rareDrops", "Ljava/util/Map;", "", "otherDrops", "Ljava/util/List;", "sackDrops", "forbiddenCoins", "", "lootAnnouncerBuffer", "lootAnnouncerBool", "Z", "sbo"})
public final class DianaTracker {
    @NotNull
    public static final DianaTracker INSTANCE = new DianaTracker();
    @NotNull
    private static final Map<String, String> rareDrops;
    @NotNull
    private static final List<String> otherDrops;
    @NotNull
    private static final List<String> sackDrops;
    @NotNull
    private static final List<Long> forbiddenCoins;
    @NotNull
    private static final List<String> lootAnnouncerBuffer;
    private static boolean lootAnnouncerBool;

    private DianaTracker() {
    }

    public final void init() {
        Register.INSTANCE.command("sboresetsession", new String[0], (Function1<? super String[], Unit>)((Function1)DianaTracker::init$lambda$0));
        Register.INSTANCE.command("sboresetstatstracker", new String[0], (Function1<? super String[], Unit>)((Function1)DianaTracker::init$lambda$1));
        Pattern pattern = Pattern.compile("^\u00a7eThe election room is now closed\\. Clerk Seraphine is doing a final count of the votes\\.\\.\\.$", 32);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        Register.INSTANCE.onChatMessageCancable(pattern, (Function2<? super class_2561, ? super Matcher, Boolean>)((Function2)DianaTracker::init$lambda$2));
        Pattern pattern2 = Pattern.compile("(.*?) \u00a7efound a \u00a7cPhoenix \u00a7epet!(.*?)$", 32);
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        Register.INSTANCE.onChatMessageCancable(pattern2, (Function2<? super class_2561, ? super Matcher, Boolean>)((Function2)DianaTracker::init$lambda$4));
        this.trackBurrowsWithChat();
        this.trackMobsWithChat();
        this.trackCoinsWithChat();
        this.trackTreasuresWithChat();
        this.trackRngDropsWithChat();
    }

    public final void trackWithPickuplog(@NotNull Item item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        boolean isLootShare = Helper.INSTANCE.gotLootShareRecently(2L);
        if (Helper.INSTANCE.getSecondsPassed(item.getCreation()) > 2L) {
            return;
        }
        if (!Helper.INSTANCE.checkDiana()) {
            return;
        }
        if (rareDrops.keySet().contains(item.getItemId())) {
            String msg = Helper.INSTANCE.toTitleCase(StringsKt.replace$default((String)item.getItemId(), (String)"_", (String)" ", (boolean)false, (int)4, null));
            if (Intrinsics.areEqual((Object)item.getItemId(), (Object)"MINOS_RELIC")) {
                SoundHandler.playCustomSound$default(SoundHandler.INSTANCE, Customization.INSTANCE.getRelicSound()[0], Customization.INSTANCE.getRelicVolume(), 0.0f, 4, null);
                if (Diana.INSTANCE.getSendSinceMessage()) {
                    Chat.INSTANCE.chat("\u00a76[SBO] \u00a7eTook \u00a7c" + SboDataObject.sboData.getChampsSinceRelic() + " \u00a7eChampions to get a Minos Relic!");
                }
                if (SboDataObject.sboData.getChampsSinceRelic() == 1) {
                    Chat.INSTANCE.chat("\u00a76[SBO] \u00a7cb2b Minos Relic!");
                    AchievementManager.INSTANCE.unlockAchievement(5);
                }
                if (isLootShare) {
                    Chat.INSTANCE.chat("\u00a76[SBO] \u00a7cLootshared a Minos Relic!");
                    AchievementManager.INSTANCE.unlockAchievement(17);
                }
                SboDataObject.sboData.setChampsSinceRelic(0);
                if (Diana.INSTANCE.getLootAnnouncerScreen()) {
                    String subTitle = Diana.INSTANCE.getLootAnnouncerPrice() ? "\u00a76" + Helper.getItemPriceFormatted$default(Helper.INSTANCE, item.getItemId(), 0, 2, null) + " coins" : "";
                    Helper.INSTANCE.showTitle("\u00a75\u00a7lMinos Relic!", subTitle, 0, 25, 35);
                }
                DianaTracker.announceLootToParty$default(this, item.getItemId(), null, false, 6, null);
                SboDataObject.INSTANCE.save("SboData");
            } else {
                SoundHandler.playCustomSound$default(SoundHandler.INSTANCE, Customization.INSTANCE.getSprSound()[0], Customization.INSTANCE.getSprVolume(), 0.0f, 4, null);
            }
            if (Diana.INSTANCE.getLootAnnouncerChat()) {
                Chat.INSTANCE.chat("\u00a76[SBO] \u00a76\u00a7lRARE DROP! " + rareDrops.get(item.getItemId()) + msg);
            }
            DianaTracker.trackItem$default(this, item.getItemId(), item.getCount(), false, 4, null);
            if (Helper.INSTANCE.getSecondsPassed(Helper.INSTANCE.getLastInqDeath()) <= 2L) {
                DianaTracker.announceLootToParty$default(this, item.getItemId(), null, false, 6, null);
                if (!isLootShare) {
                    this.trackItem(item.getItemId(), item.getCount(), true);
                } else {
                    this.trackItem(item.getItemId() + "_LS", item.getCount(), true);
                }
            }
        }
    }

    public final void trackWithPickuplogStackable(@NotNull Item item, int amount) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Helper.INSTANCE.sleep(1000L, (Function0<Unit>)((Function0)() -> DianaTracker.trackWithPickuplogStackable$lambda$5(item, amount)));
    }

    public final void trackWithSacksMessage(@NotNull String itemName, int amount) {
        Intrinsics.checkNotNullParameter((Object)itemName, (String)"itemName");
        if (!Helper.INSTANCE.getAllowSackTracking()) {
            return;
        }
        if (!Helper.INSTANCE.checkDiana()) {
            return;
        }
        if (sackDrops.contains(itemName)) {
            DianaTracker.trackItem$default(this, itemName, amount, false, 4, null);
        }
    }

    public final void trackScavengerCoins(long amount) {
        if (amount <= 0L) {
            return;
        }
        if (!Helper.INSTANCE.dianaMobDiedRecently(4L) && !Helper.INSTANCE.gotLootShareRecently(4L)) {
            return;
        }
        if (!Helper.INSTANCE.checkDiana()) {
            return;
        }
        if (forbiddenCoins.contains(amount)) {
            return;
        }
        DianaTracker.trackItem$default(this, "SCAVENGER_COINS", (int)amount, false, 4, null);
        DianaTracker.trackItem$default(this, "COINS", (int)amount, false, 4, null);
    }

    public final void trackMobsWithChat() {
        Pattern pattern = Pattern.compile("(.*?) \u00a7eYou dug (.*?)\u00a72(.*?)\u00a7e!(.*?)$", 32);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        Register.INSTANCE.onChatMessageCancable(pattern, (Function2<? super class_2561, ? super Matcher, Boolean>)((Function2)DianaTracker::trackMobsWithChat$lambda$6));
    }

    public final void trackCoinsWithChat() {
        Pattern pattern = Pattern.compile("^\u00a76\u00a7lWow! \u00a7eYou dug out \u00a76(.*?) coins\u00a7e!$", 32);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        Register.INSTANCE.onChatMessageCancable(pattern, (Function2<? super class_2561, ? super Matcher, Boolean>)((Function2)DianaTracker::trackCoinsWithChat$lambda$7));
    }

    public final void trackTreasuresWithChat() {
        Pattern pattern = Pattern.compile("^\u00a76\u00a7lRARE DROP! \u00a7eYou dug out a (.*?)\u00a7e!$", 32);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        Register.INSTANCE.onChatMessageCancable(pattern, (Function2<? super class_2561, ? super Matcher, Boolean>)((Function2)DianaTracker::trackTreasuresWithChat$lambda$8));
    }

    public final void trackRngDropsWithChat() {
        Pattern pattern = Pattern.compile("^\u00a76\u00a7lRARE DROP! (.*?)$", 32);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        Register.INSTANCE.onChatMessageCancable(pattern, (Function2<? super class_2561, ? super Matcher, Boolean>)((Function2)DianaTracker::trackRngDropsWithChat$lambda$10));
    }

    public final void trackBurrowsWithChat() {
        Pattern pattern = Pattern.compile("^\u00a7eYou (.*?) Griffin [Bb]urrow(.*?)$", 32);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        Register.INSTANCE.onChatMessageCancable(pattern, (Function2<? super class_2561, ? super Matcher, Boolean>)((Function2)DianaTracker::trackBurrowsWithChat$lambda$11));
    }

    public final void announceLootToParty(@NotNull String item, @Nullable String customMsg, boolean replaceChimMessage) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (!Diana.INSTANCE.getLootAnnouncerParty()) {
            return;
        }
        String msg = Helper.INSTANCE.toTitleCase(StringsKt.replace$default((String)StringsKt.replace$default((String)item, (String)"_LS", (String)"", (boolean)false, (int)4, null), (String)"_", (String)" ", (boolean)false, (int)4, null));
        if (customMsg != null) {
            msg = Helper.INSTANCE.removeFormatting(customMsg);
        }
        if (replaceChimMessage) {
            Chat.INSTANCE.command("pc " + msg);
        } else {
            lootAnnouncerBuffer.add(msg);
            if (!lootAnnouncerBool) {
                lootAnnouncerBool = true;
                Helper.INSTANCE.sleep(1500L, (Function0<Unit>)((Function0)DianaTracker::announceLootToParty$lambda$12));
            }
        }
    }

    public static /* synthetic */ void announceLootToParty$default(DianaTracker dianaTracker, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        dianaTracker.announceLootToParty(string, string2, bl);
    }

    public final void sendLootAnnouncement() {
        if (lootAnnouncerBuffer.isEmpty()) {
            return;
        }
        String msg = CollectionsKt.joinToString$default((Iterable)lootAnnouncerBuffer, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        lootAnnouncerBuffer.clear();
        Chat.INSTANCE.command("pc [SBO] RARE DROP! " + msg);
    }

    @Nullable
    public final String getB2BMessage(@NotNull String itemName, int streak) {
        Intrinsics.checkNotNullParameter((Object)itemName, (String)"itemName");
        if (streak <= 1) {
            return null;
        }
        String prettyName = Helper.INSTANCE.toTitleCase(StringsKt.replace$default((String)itemName, (String)"_", (String)" ", (boolean)false, (int)4, null));
        String streakText = "b" + StringsKt.repeat((CharSequence)"2b", (int)(streak - 1));
        return "\u00a76[SBO] \u00a7c" + streakText + " " + prettyName + "!";
    }

    public final void checkMayorTracker() {
        if (SboDataObject.dianaTrackerMayor.getYear() == 0 || SboDataObject.dianaTrackerMayor.getYear() >= Mayor.INSTANCE.getMayorElectedYear()) {
            return;
        }
        boolean allZero = true;
        Object object = ArrayIteratorKt.iterator((Object[])SboDataObject.dianaTrackerMayor.getMobs().getClass().getDeclaredFields());
        while (object.hasNext()) {
            Field item = (Field)object.next();
            item.setAccessible(true);
            if (!(item.get(SboDataObject.dianaTrackerMayor.getMobs()) instanceof Integer) || item.getInt(SboDataObject.dianaTrackerMayor.getMobs()) <= 0) continue;
            allZero = false;
            break;
        }
        if (!allZero) {
            object = SboDataObject.pastDianaEventsData;
            ((PastDianaEventsData)object).setEvents(CollectionsKt.plus((Collection)((PastDianaEventsData)object).getEvents(), (Object)SboDataObject.dianaTrackerMayor));
            SboDataObject.INSTANCE.save("PastDianaEventsData");
        }
        SboDataObject.dianaTrackerMayor.reset();
        SboDataObject.dianaTrackerMayor.setYear(Mayor.INSTANCE.getMayorElectedYear());
        SboDataObject.dianaTrackerMayor.save();
        Mayor.INSTANCE.getMayor$sbo();
        DianaMobs.updateLines$default(DianaMobs.INSTANCE, null, 1, null);
        DianaLoot.updateLines$default(DianaLoot.INSTANCE, null, 1, null);
        InquisLoot.updateLines$default(InquisLoot.INSTANCE, null, 1, null);
    }

    public final void trackMob(@NotNull String item, int amount) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        DianaTracker.trackItem$default(this, item, amount, false, 4, null);
        DianaTracker.trackItem$default(this, "TOTAL_MOBS", amount, false, 4, null);
        SboData sboData = SboDataObject.sboData;
        sboData.setMobsSinceInq(sboData.getMobsSinceInq() + amount);
        if (SboDataObject.sboData.getMobsSinceInq() >= 2) {
            SboDataObject.sboData.setB2bInq(false);
        }
        SboDataObject.INSTANCE.save("SboData");
    }

    public final void trackItem(@NotNull String item, int amount, boolean fromInq) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.checkMayorTracker();
        String itemName = Helper.INSTANCE.toUpperSnakeCase(item);
        if (Intrinsics.areEqual((Object)itemName, (Object)"MINOS_INQUISITOR_LS")) {
            SboData sboData = SboDataObject.sboData;
            sboData.setInqsSinceLsChim(sboData.getInqsSinceLsChim() + 1);
        }
        this.trackOne(SboDataObject.dianaTrackerMayor, itemName, amount, fromInq);
        this.trackOne(SboDataObject.dianaTrackerSession, itemName, amount, fromInq);
        this.trackOne(SboDataObject.dianaTrackerTotal, itemName, amount, fromInq);
        SboDataObject.INSTANCE.saveTrackerData();
        DianaStats.INSTANCE.updateLines();
        MagicFind.INSTANCE.updateLines();
        DianaMobs.updateLines$default(DianaMobs.INSTANCE, null, 1, null);
        DianaLoot.updateLines$default(DianaLoot.INSTANCE, null, 1, null);
        if (fromInq) {
            InquisLoot.updateLines$default(InquisLoot.INSTANCE, null, 1, null);
        }
        SboTimerManager.INSTANCE.updateAllActivity();
    }

    public static /* synthetic */ void trackItem$default(DianaTracker dianaTracker, String string, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        dianaTracker.trackItem(string, n, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void trackOne(@NotNull net.sbo.mod.utils.data.DianaTracker tracker, @NotNull String item, int amount, boolean fromInq) {
        Object object;
        block96: {
            block97: {
                block95: {
                    block98: {
                        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
                        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                        switch (item) {
                            case "COINS": {
                                object = tracker.getItems();
                                ((DianaItemsData)object).setCOINS(((DianaItemsData)object).getCOINS() + (long)amount);
                                break;
                            }
                            case "GRIFFIN_FEATHER": {
                                object = tracker.getItems();
                                ((DianaItemsData)object).setGRIFFIN_FEATHER(((DianaItemsData)object).getGRIFFIN_FEATHER() + amount);
                                break;
                            }
                            case "CROWN_OF_GREED": {
                                object = tracker.getItems();
                                ((DianaItemsData)object).setCROWN_OF_GREED(((DianaItemsData)object).getCROWN_OF_GREED() + amount);
                                break;
                            }
                            case "WASHED_UP_SOUVENIR": {
                                object = tracker.getItems();
                                ((DianaItemsData)object).setWASHED_UP_SOUVENIR(((DianaItemsData)object).getWASHED_UP_SOUVENIR() + amount);
                                break;
                            }
                            case "CHIMERA": {
                                object = tracker.getItems();
                                ((DianaItemsData)object).setCHIMERA(((DianaItemsData)object).getCHIMERA() + amount);
                                break;
                            }
                            case "CHIMERA_LS": {
                                object = tracker.getItems();
                                ((DianaItemsData)object).setCHIMERA_LS(((DianaItemsData)object).getCHIMERA_LS() + amount);
                                break;
                            }
                            case "DAEDALUS_STICK": {
                                object = tracker.getItems();
                                ((DianaItemsData)object).setDAEDALUS_STICK(((DianaItemsData)object).getDAEDALUS_STICK() + amount);
                                break;
                            }
                            case "DWARF_TURTLE_SHELMET": {
                                object = tracker.getItems();
                                ((DianaItemsData)object).setDWARF_TURTLE_SHELMET(((DianaItemsData)object).getDWARF_TURTLE_SHELMET() + amount);
                                break;
                            }
                            case "CROCHET_TIGER_PLUSHIE": {
                                object = tracker.getItems();
                                ((DianaItemsData)object).setCROCHET_TIGER_PLUSHIE(((DianaItemsData)object).getCROCHET_TIGER_PLUSHIE() + amount);
                                break;
                            }
                            case "ANTIQUE_REMEDIES": {
                                object = tracker.getItems();
                                ((DianaItemsData)object).setANTIQUE_REMEDIES(((DianaItemsData)object).getANTIQUE_REMEDIES() + amount);
                                break;
                            }
                            case "ENCHANTED_ANCIENT_CLAW": {
                                object = tracker.getItems();
                                ((DianaItemsData)object).setENCHANTED_ANCIENT_CLAW(((DianaItemsData)object).getENCHANTED_ANCIENT_CLAW() + amount);
                                break;
                            }
                            case "ANCIENT_CLAW": {
                                object = tracker.getItems();
                                ((DianaItemsData)object).setANCIENT_CLAW(((DianaItemsData)object).getANCIENT_CLAW() + amount);
                                break;
                            }
                            case "MINOS_RELIC": {
                                object = tracker.getItems();
                                ((DianaItemsData)object).setMINOS_RELIC(((DianaItemsData)object).getMINOS_RELIC() + amount);
                                break;
                            }
                            case "ENCHANTED_GOLD": {
                                object = tracker.getItems();
                                ((DianaItemsData)object).setENCHANTED_GOLD(((DianaItemsData)object).getENCHANTED_GOLD() + amount);
                                break;
                            }
                            case "ENCHANTED_IRON": {
                                object = tracker.getItems();
                                ((DianaItemsData)object).setENCHANTED_IRON(((DianaItemsData)object).getENCHANTED_IRON() + amount);
                                break;
                            }
                            case "SCAVENGER_COINS": {
                                object = tracker.getItems();
                                ((DianaItemsData)object).setSCAVENGER_COINS(((DianaItemsData)object).getSCAVENGER_COINS() + (long)amount);
                                break;
                            }
                            case "FISH_COINS": {
                                object = tracker.getItems();
                                ((DianaItemsData)object).setFISH_COINS(((DianaItemsData)object).getFISH_COINS() + (long)amount);
                                break;
                            }
                            case "TOTAL_BURROWS": {
                                object = tracker.getItems();
                                ((DianaItemsData)object).setTOTAL_BURROWS(((DianaItemsData)object).getTOTAL_BURROWS() + amount);
                                break;
                            }
                            case "MINOS_INQUISITOR": {
                                object = tracker.getMobs();
                                ((DianaMobsData)object).setMINOS_INQUISITOR(((DianaMobsData)object).getMINOS_INQUISITOR() + amount);
                                break;
                            }
                            case "MINOS_INQUISITOR_LS": {
                                object = tracker.getMobs();
                                ((DianaMobsData)object).setMINOS_INQUISITOR_LS(((DianaMobsData)object).getMINOS_INQUISITOR_LS() + amount);
                                break;
                            }
                            case "MINOS_CHAMPION": {
                                object = tracker.getMobs();
                                ((DianaMobsData)object).setMINOS_CHAMPION(((DianaMobsData)object).getMINOS_CHAMPION() + amount);
                                break;
                            }
                            case "MINOTAUR": {
                                object = tracker.getMobs();
                                ((DianaMobsData)object).setMINOTAUR(((DianaMobsData)object).getMINOTAUR() + amount);
                                break;
                            }
                            case "GAIA_CONSTRUCT": {
                                object = tracker.getMobs();
                                ((DianaMobsData)object).setGAIA_CONSTRUCT(((DianaMobsData)object).getGAIA_CONSTRUCT() + amount);
                                break;
                            }
                            case "SIAMESE_LYNXES": {
                                object = tracker.getMobs();
                                ((DianaMobsData)object).setSIAMESE_LYNXES(((DianaMobsData)object).getSIAMESE_LYNXES() + amount);
                                break;
                            }
                            case "MINOS_HUNTER": {
                                object = tracker.getMobs();
                                ((DianaMobsData)object).setMINOS_HUNTER(((DianaMobsData)object).getMINOS_HUNTER() + amount);
                                break;
                            }
                            case "TOTAL_MOBS": {
                                object = tracker.getMobs();
                                ((DianaMobsData)object).setTOTAL_MOBS(((DianaMobsData)object).getTOTAL_MOBS() + amount);
                            }
                        }
                        if (!fromInq) return;
                        String string = item;
                        switch (string.hashCode()) {
                            case 1386706247: {
                                if (!string.equals("CROCHET_TIGER_PLUSHIE_LS")) {
                                    return;
                                }
                                break block95;
                            }
                            case 660127656: {
                                if (!string.equals("ANTIQUE_REMEDIES_LS")) {
                                    return;
                                }
                                break block96;
                            }
                            case -2024275892: {
                                if (string.equals("DWARF_TURTLE_SHELMET_LS")) break;
                                return;
                            }
                            case -1831080514: {
                                if (!string.equals("ANTIQUE_REMEDIES")) {
                                    return;
                                }
                                break block97;
                            }
                            case -505990017: {
                                if (!string.equals("CROCHET_TIGER_PLUSHIE")) {
                                    return;
                                }
                                break block98;
                            }
                            case -2145316966: {
                                if (!string.equals("DWARF_TURTLE_SHELMET")) return;
                                object = tracker.getInquis();
                                ((DianaInquisData)object).setDWARF_TURTLE_SHELMET(((DianaInquisData)object).getDWARF_TURTLE_SHELMET() + amount);
                                return;
                            }
                        }
                        object = tracker.getInquis();
                        ((DianaInquisData)object).setDWARF_TURTLE_SHELMET_LS(((DianaInquisData)object).getDWARF_TURTLE_SHELMET_LS() + amount);
                        return;
                    }
                    object = tracker.getInquis();
                    ((DianaInquisData)object).setCROCHET_TIGER_PLUSHIE(((DianaInquisData)object).getCROCHET_TIGER_PLUSHIE() + amount);
                    return;
                }
                object = tracker.getInquis();
                ((DianaInquisData)object).setCROCHET_TIGER_PLUSHIE_LS(((DianaInquisData)object).getCROCHET_TIGER_PLUSHIE_LS() + amount);
                return;
            }
            object = tracker.getInquis();
            ((DianaInquisData)object).setANTIQUE_REMEDIES(((DianaInquisData)object).getANTIQUE_REMEDIES() + amount);
            return;
        }
        object = tracker.getInquis();
        ((DianaInquisData)object).setANTIQUE_REMEDIES_LS(((DianaInquisData)object).getANTIQUE_REMEDIES_LS() + amount);
    }

    public static /* synthetic */ void trackOne$default(DianaTracker dianaTracker, net.sbo.mod.utils.data.DianaTracker dianaTracker2, String string, int n, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        dianaTracker.trackOne(dianaTracker2, string, n, bl);
    }

    private static final Unit init$lambda$0(String[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        SboDataObject.dianaTrackerSession.reset().save();
        Chat.INSTANCE.chat("\u00a76[SBO] \u00a7aDiana session tracker has been reset.");
        DianaMobs.updateLines$default(DianaMobs.INSTANCE, null, 1, null);
        DianaLoot.updateLines$default(DianaLoot.INSTANCE, null, 1, null);
        InquisLoot.updateLines$default(InquisLoot.INSTANCE, null, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit init$lambda$1(String[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        SboDataObject.sboData.setMobsSinceInq(0);
        SboDataObject.sboData.setInqsSinceChim(0);
        SboDataObject.sboData.setMinotaursSinceStick(0);
        SboDataObject.sboData.setChampsSinceRelic(0);
        SboDataObject.sboData.setInqsSinceLsChim(0);
        SboDataObject.INSTANCE.save("SboData");
        DianaStats.INSTANCE.updateLines();
        return Unit.INSTANCE;
    }

    private static final boolean init$lambda$2(class_2561 class_25612, Matcher matcher) {
        Intrinsics.checkNotNullParameter((Object)class_25612, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"<unused var>");
        INSTANCE.checkMayorTracker();
        return true;
    }

    private static final Unit init$lambda$4$lambda$3() {
        if (World.INSTANCE.isInSkyblock() && Helper.INSTANCE.checkDiana() && Helper.INSTANCE.dianaMobDiedRecently(3L)) {
            AchievementManager.INSTANCE.unlockAchievement(77);
        }
        return Unit.INSTANCE;
    }

    private static final boolean init$lambda$4(class_2561 message, Matcher matchResult) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
        if (QOL.INSTANCE.getPhoenixAnnouncer()) {
            Chat.INSTANCE.chat("\u00a76[SBO] \u00a7cGG \u00a7eFound a \u00a7cPhoenix \u00a7epet!");
            Helper.INSTANCE.showTitle("\u00a7c\u00a7lPhoenix Pet!", "", 0, 25, 35);
        }
        if (Helper.INSTANCE.getSecondsPassed(Helper.INSTANCE.getLastDianaMobDeath()) > 2L) {
            return true;
        }
        String string = matchResult.group(2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
        String player = Helper.INSTANCE.removeFormatting(string);
        if (!Intrinsics.areEqual((Object)Player.INSTANCE.getName(), (Object)Helper.INSTANCE.getPlayerName(player))) {
            return true;
        }
        Helper.INSTANCE.sleep(1000L, (Function0<Unit>)((Function0)DianaTracker::init$lambda$4$lambda$3));
        return true;
    }

    private static final Unit trackWithPickuplogStackable$lambda$5(Item $item, int $amount) {
        if (!Helper.INSTANCE.dianaMobDiedRecently(3L) && Helper.INSTANCE.gotLootShareRecently(3L)) {
            return Unit.INSTANCE;
        }
        if (!Helper.INSTANCE.checkDiana()) {
            return Unit.INSTANCE;
        }
        if (otherDrops.contains($item.getItemId())) {
            DianaTracker.trackItem$default(INSTANCE, $item.getItemId(), $amount, false, 4, null);
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private static final boolean trackMobsWithChat$lambda$6(class_2561 message, Matcher matchResult) {
        block29: {
            String mob;
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
            String string = mob = matchResult.group(3);
            if (string == null) break block29;
            int n = -1;
            switch (string.hashCode()) {
                case 2116655273: {
                    if (string.equals("Gaia Construct")) {
                        n = 1;
                    }
                    break;
                }
                case 1560814251: {
                    if (string.equals("Minos Inquisitor")) {
                        n = 2;
                    }
                    break;
                }
                case -1288681529: {
                    if (string.equals("Minotaur")) {
                        n = 3;
                    }
                    break;
                }
                case 2067309712: {
                    if (string.equals("Siamese Lynxes")) {
                        n = 4;
                    }
                    break;
                }
                case 1810286442: {
                    if (string.equals("Minos Hunter")) {
                        n = 5;
                    }
                    break;
                }
                case 1068431827: {
                    if (string.equals("Minos Champion")) {
                        n = 6;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    DianaMobDetect.INSTANCE.onInqSpawn();
                    SboData sboData = SboDataObject.sboData;
                    sboData.setInqsSinceChim(sboData.getInqsSinceChim() + 1);
                    INSTANCE.trackMob(mob, 1);
                    if (Diana.INSTANCE.getSendSinceMessage()) {
                        String timeSinceInq = Helper.INSTANCE.formatTime(SboDataObject.dianaTrackerTotal.getItems().getTIME() - SboDataObject.sboData.getLastInqDate());
                        if (SboDataObject.sboData.getLastInqDate() != 0L) {
                            Chat.INSTANCE.chat("\u00a76[SBO] \u00a7eTook \u00a7c" + SboDataObject.sboData.getMobsSinceInq() + " \u00a7eMobs and \u00a7c" + timeSinceInq + " \u00a7eto get an Inquis!");
                        } else {
                            Chat.INSTANCE.chat("\u00a76[SBO] \u00a7eTook \u00a7c" + SboDataObject.sboData.getMobsSinceInq() + " \u00a7eMobs to get an Inquis!");
                        }
                    }
                    SboDataObject.sboData.setLastInqDate(SboDataObject.dianaTrackerTotal.getItems().getTIME());
                    if (SboDataObject.sboData.getB2bInq() && SboDataObject.sboData.getMobsSinceInq() == 1) {
                        Chat.INSTANCE.chat("\u00a76[SBO] \u00a7cb2b2b Inquisitor!");
                        AchievementManager.INSTANCE.unlockAchievement(7);
                    }
                    if (SboDataObject.sboData.getMobsSinceInq() == 1 && !SboDataObject.sboData.getB2bInq()) {
                        Chat.INSTANCE.chat("\u00a76[SBO] \u00a7cb2b Inquisitor!");
                        AchievementManager.INSTANCE.unlockAchievement(6);
                        SboDataObject.sboData.setB2bInq(true);
                    }
                    if (SboDataObject.sboData.getInqsSinceChim() >= 2) {
                        SboDataObject.sboData.setB2bChim(false);
                    }
                    SboDataObject.sboData.setMobsSinceInq(0);
                    break;
                }
                case 6: {
                    SboData sboData = SboDataObject.sboData;
                    sboData.setChampsSinceRelic(sboData.getChampsSinceRelic() + 1);
                    INSTANCE.trackMob(mob, 1);
                    break;
                }
                case 3: {
                    SboData sboData = SboDataObject.sboData;
                    sboData.setMinotaursSinceStick(sboData.getMinotaursSinceStick() + 1);
                    if (SboDataObject.sboData.getMinotaursSinceStick() >= 2) {
                        SboDataObject.sboData.setB2bStick(false);
                    }
                    INSTANCE.trackMob(mob, 1);
                    break;
                }
                case 1: {
                    INSTANCE.trackMob(mob, 1);
                    break;
                }
                case 4: {
                    INSTANCE.trackMob(mob, 1);
                    break;
                }
                case 5: {
                    INSTANCE.trackMob(mob, 1);
                }
            }
        }
        SboDataObject.INSTANCE.save("SboData");
        return !QOL.INSTANCE.getDianaMessageHider();
    }

    private static final boolean trackCoinsWithChat$lambda$7(class_2561 message, Matcher matchResult) {
        int coins;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
        String string = matchResult.group(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
        Integer n = StringsKt.toIntOrNull((String)StringsKt.replace$default((String)string, (String)",", (String)"", (boolean)false, (int)4, null));
        int n2 = coins = n != null ? n : 0;
        if (coins > 0) {
            DianaTracker.trackItem$default(INSTANCE, "COINS", coins, false, 4, null);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean trackTreasuresWithChat$lambda$8(class_2561 message, Matcher matchResult) {
        String drop;
        block6: {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
            String string = matchResult.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            String string2 = drop = StringsKt.drop((String)string, (int)2);
            switch (string2.hashCode()) {
                case -1192364871: {
                    if (string2.equals("Crown of Greed")) break;
                    return true;
                }
                case -1226593435: {
                    if (!string2.equals("Washed-up Souvenir")) {
                        return true;
                    }
                    break block6;
                }
                case -993354490: {
                    if (!string2.equals("Griffin Feather")) return true;
                    DianaTracker.trackItem$default(INSTANCE, drop, 1, false, 4, null);
                    return true;
                }
            }
            DianaTracker.trackItem$default(INSTANCE, drop, 1, false, 4, null);
            return true;
        }
        DianaTracker.trackItem$default(INSTANCE, drop, 1, false, 4, null);
        return true;
    }

    private static final Unit trackRngDropsWithChat$lambda$10$lambda$9() {
        if (SboDataObject.sboData.getB2bChimLs() && SboDataObject.sboData.getInqsSinceLsChim() == 1) {
            Chat.INSTANCE.chat("\u00a76[SBO] \u00a7cb2b2b Lootshare Chimera!");
            AchievementManager.INSTANCE.unlockAchievement(67);
        }
        if (SboDataObject.sboData.getInqsSinceLsChim() == 1 && !SboDataObject.sboData.getB2bChimLs()) {
            Chat.INSTANCE.chat("\u00a76[SBO] \u00a7cb2b Lootshare Chimera!");
            SboDataObject.sboData.setB2bChimLs(true);
            AchievementManager.INSTANCE.unlockAchievement(65);
        }
        SboDataObject.sboData.setInqsSinceLsChim(0);
        return Unit.INSTANCE;
    }

    private static final boolean trackRngDropsWithChat$lambda$10(class_2561 message, Matcher matchResult) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
        if (!Helper.INSTANCE.checkDiana()) {
            return true;
        }
        String drop = matchResult.group(1);
        boolean isLootShare = Helper.INSTANCE.gotLootShareRecently(2L);
        Intrinsics.checkNotNull((Object)drop);
        int magicfind = Helper.INSTANCE.getMagicFind(drop);
        Object mfPrefix = "";
        if (magicfind > 0) {
            mfPrefix = " (+" + magicfind + " \u272f Magic Find)";
        }
        String string = drop.substring(2, 16);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String string2 = string;
        if (Intrinsics.areEqual((Object)string2, (Object)"Enchanted Book")) {
            if (!StringsKt.contains$default((CharSequence)drop, (CharSequence)"Chimera", (boolean)false, (int)2, null)) {
                return true;
            }
            SoundHandler.playCustomSound$default(SoundHandler.INSTANCE, Customization.INSTANCE.getChimSound()[0], Customization.INSTANCE.getChimVolume(), 0.0f, 4, null);
            if (Diana.INSTANCE.getLootAnnouncerScreen()) {
                String subTitle = Diana.INSTANCE.getLootAnnouncerPrice() ? "\u00a76" + Helper.getItemPriceFormatted$default(Helper.INSTANCE, "CHIMERA", 0, 2, null) + " coins" : "";
                Helper.INSTANCE.showTitle("\u00a7d\u00a7lChimera!", subTitle, 0, 25, 35);
            }
            if (!isLootShare) {
                AchievementManager.INSTANCE.trackMagicFind(magicfind, true);
                if (magicfind > SboDataObject.sboData.getHighestChimMagicFind()) {
                    SboDataObject.sboData.setHighestChimMagicFind(magicfind);
                }
                if (Diana.INSTANCE.getSendSinceMessage()) {
                    Chat.INSTANCE.chat("\u00a76[SBO] \u00a7eTook \u00a7c" + SboDataObject.sboData.getInqsSinceChim() + " \u00a7eInquisitors to get a Chimera!");
                }
                DianaTracker.trackItem$default(INSTANCE, "CHIMERA", 1, false, 4, null);
                if (SboDataObject.sboData.getB2bChim() && SboDataObject.sboData.getInqsSinceChim() == 1) {
                    Chat.INSTANCE.chat("\u00a76[SBO] \u00a7cb2b2b Chimera!");
                    AchievementManager.INSTANCE.unlockAchievement(2);
                }
                if (SboDataObject.sboData.getInqsSinceChim() == 1 && !SboDataObject.sboData.getB2bChim()) {
                    Chat.INSTANCE.chat("\u00a76[SBO] \u00a7cb2b Chimera!");
                    SboDataObject.sboData.setB2bChim(true);
                    AchievementManager.INSTANCE.unlockAchievement(1);
                }
                if (SboDataObject.sboData.getB2bChim() && SboDataObject.sboData.getB2bInq()) {
                    AchievementManager.INSTANCE.unlockAchievement(75);
                }
                SboDataObject.sboData.setInqsSinceChim(0);
            } else {
                if (Diana.INSTANCE.getSendSinceMessage()) {
                    Chat.INSTANCE.chat("\u00a76[SBO] \u00a7eTook \u00a7c" + SboDataObject.sboData.getInqsSinceLsChim() + " \u00a7eInquisitors to lootshare a Chimera!");
                }
                DianaTracker.trackItem$default(INSTANCE, "CHIMERA_LS", 1, false, 4, null);
                Helper.INSTANCE.sleep(200L, (Function0<Unit>)((Function0)DianaTracker::trackRngDropsWithChat$lambda$10$lambda$9));
            }
            Pair<Boolean, String> customChimMsg = Helper.INSTANCE.checkCustomChimMessage(magicfind);
            if (((Boolean)customChimMsg.getFirst()).booleanValue()) {
                Chat.INSTANCE.chat((String)customChimMsg.getSecond());
                INSTANCE.announceLootToParty("Chimera!", (String)customChimMsg.getSecond(), true);
            } else {
                DianaTracker.announceLootToParty$default(INSTANCE, "Chimera!", "Chimera!" + (String)mfPrefix, false, 4, null);
            }
        } else if (Intrinsics.areEqual((Object)string2, (Object)"Daedalus Stick")) {
            SoundHandler.playCustomSound$default(SoundHandler.INSTANCE, Customization.INSTANCE.getStickSound()[0], Customization.INSTANCE.getStickVolume(), 0.0f, 4, null);
            if (Diana.INSTANCE.getLootAnnouncerScreen()) {
                String subTitle = Diana.INSTANCE.getLootAnnouncerPrice() ? "\u00a76" + Helper.getItemPriceFormatted$default(Helper.INSTANCE, "DAEDALUS_STICK", 0, 2, null) + " coins" : "";
                Helper.INSTANCE.showTitle("\u00a76\u00a7lDaedalus Stick!", subTitle, 0, 25, 35);
            }
            if (Diana.INSTANCE.getSendSinceMessage()) {
                Chat.INSTANCE.chat("\u00a76[SBO] \u00a7eTook \u00a7c" + SboDataObject.sboData.getMinotaursSinceStick() + " \u00a7eMinotaurs to get a Daedalus Stick!");
            }
            DianaTracker.announceLootToParty$default(INSTANCE, "Daedalus Stick!", "Daedalus Stick!" + (String)mfPrefix, false, 4, null);
            if (isLootShare) {
                Chat.INSTANCE.chat("\u00a76[SBO] \u00a7cLootshared a Daedalus Stick!");
                AchievementManager.INSTANCE.unlockAchievement(15);
            } else if (magicfind > SboDataObject.sboData.getHighestStickMagicFind()) {
                SboDataObject.sboData.setHighestStickMagicFind(magicfind);
                AchievementManager.trackMagicFind$default(AchievementManager.INSTANCE, magicfind, false, 2, null);
            }
            DianaTracker.trackItem$default(INSTANCE, "DAEDALUS_STICK", 1, false, 4, null);
            if (SboDataObject.sboData.getB2bStick() && SboDataObject.sboData.getMinotaursSinceStick() == 1) {
                Chat.INSTANCE.chat("\u00a76[SBO] \u00a7cb2b2b Daedalus Stick!");
                AchievementManager.INSTANCE.unlockAchievement(4);
            }
            if (SboDataObject.sboData.getMinotaursSinceStick() == 1 && !SboDataObject.sboData.getB2bStick()) {
                Chat.INSTANCE.chat("\u00a76[SBO] \u00a7cb2b Daedalus Stick!");
                SboDataObject.sboData.setB2bStick(true);
                AchievementManager.INSTANCE.unlockAchievement(3);
            }
            SboDataObject.sboData.setMinotaursSinceStick(0);
        }
        SboDataObject.INSTANCE.save("SboData");
        return true;
    }

    private static final boolean trackBurrowsWithChat$lambda$11(class_2561 message, Matcher matchResult) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
        String string = matchResult.group(2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
        String burrow = Helper.INSTANCE.removeFormatting(string);
        DianaTracker.trackItem$default(INSTANCE, "TOTAL_BURROWS", 1, false, 4, null);
        if (Diana.INSTANCE.getFourEyedFish()) {
            if (StringsKt.contains$default((CharSequence)burrow, (CharSequence)"(2/4)", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)burrow, (CharSequence)"(3/4)", (boolean)false, (int)2, null)) {
                DianaTracker.trackItem$default(INSTANCE, "FISH_COINS", 4000, false, 4, null);
                DianaTracker.trackItem$default(INSTANCE, "COINS", 4000, false, 4, null);
            } else {
                DianaTracker.trackItem$default(INSTANCE, "FISH_COINS", 2000, false, 4, null);
                DianaTracker.trackItem$default(INSTANCE, "COINS", 2000, false, 4, null);
            }
        }
        return !QOL.INSTANCE.getDianaMessageHider();
    }

    private static final Unit announceLootToParty$lambda$12() {
        INSTANCE.sendLootAnnouncement();
        lootAnnouncerBool = false;
        return Unit.INSTANCE;
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"DWARF_TURTLE_SHELMET", (Object)"\u00a79"), TuplesKt.to((Object)"CROCHET_TIGER_PLUSHIE", (Object)"\u00a75"), TuplesKt.to((Object)"ANTIQUE_REMEDIES", (Object)"\u00a75"), TuplesKt.to((Object)"MINOS_RELIC", (Object)"\u00a75")};
        rareDrops = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new String[]{"ENCHANTED_ANCIENT_CLAW", "ANCIENT_CLAW", "ENCHANTED_GOLD", "ENCHANTED_IRON"};
        otherDrops = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"Enchanted Gold", "Enchanted Iron", "Ancient Claw", "Enchanted Ancient Claw"};
        sackDrops = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Long[]{1L, 5L, 20L, 1000L, 2000L, 3000L, 4000L, 5000L, 7500L, 8000L, 10000L, 12000L, 15000L, 20000L, 25000L, 40000L, 50000L};
        forbiddenCoins = CollectionsKt.listOf((Object[])objectArray);
        lootAnnouncerBuffer = new ArrayList();
    }
}

