/*
 * Decompiled with CFR 0.152.
 */
package net.sbo.mod.general;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.sbo.mod.SBOKotlin;
import net.sbo.mod.diana.DianaTracker;
import net.sbo.mod.settings.categories.QOL;
import net.sbo.mod.utils.Helper;
import net.sbo.mod.utils.data.Item;
import net.sbo.mod.utils.events.Register;
import net.sbo.mod.utils.events.impl.InventorySlotUpdateEvent;
import net.sbo.mod.utils.game.World;
import net.sbo.mod.utils.overlay.Overlay;
import net.sbo.mod.utils.overlay.OverlayExamples;
import net.sbo.mod.utils.overlay.OverlayTextLine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001'B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0015\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\n\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u0003J%\u0010\u0010\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0012\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0003R\u0016\u0010\u0014\u001a\u00020\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u00020\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0015R\"\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00180\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\"\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00180\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001aR\u0014\u0010\u001d\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0014\u0010 \u001a\u00020\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R&\u0010$\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020#0\u00170\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%R&\u0010&\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020#0\u00170\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010%\u00a8\u0006("}, d2={"Lnet/sbo/mod/general/Pickuplog;", "", "<init>", "()V", "", "init", "Lnet/sbo/mod/utils/events/impl/InventorySlotUpdateEvent;", "event", "onInventorySlotUpdate", "(Lnet/sbo/mod/utils/events/impl/InventorySlotUpdateEvent;)V", "compareInventory", "", "itemId", "name", "", "amount", "refreshOverlay", "(Ljava/lang/String;Ljava/lang/String;I)V", "updateOverlay", "", "oldPurse", "J", "newPurse", "", "Lnet/sbo/mod/utils/data/Item;", "oldInventory", "Ljava/util/Map;", "newInventory", "Lkotlin/text/Regex;", "regex", "Lkotlin/text/Regex;", "Lnet/sbo/mod/utils/overlay/Overlay;", "overlay", "Lnet/sbo/mod/utils/overlay/Overlay;", "", "Lnet/sbo/mod/general/Pickuplog$OverlayLineData;", "itemsShowAdded", "Ljava/util/List;", "itemsShowRemoved", "OverlayLineData", "sbo"})
@SourceDebugExtension(value={"SMAP\nPickuplog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pickuplog.kt\nnet/sbo/mod/general/Pickuplog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,175:1\n1#2:176\n1869#3,2:177\n1869#3,2:179\n1869#3:181\n1870#3:184\n1321#4,2:182\n*S KotlinDebug\n*F\n+ 1 Pickuplog.kt\nnet/sbo/mod/general/Pickuplog\n*L\n152#1:177,2\n163#1:179,2\n41#1:181\n41#1:184\n46#1:182,2\n*E\n"})
public final class Pickuplog {
    @NotNull
    public static final Pickuplog INSTANCE = new Pickuplog();
    private static long oldPurse;
    private static long newPurse;
    @NotNull
    private static Map<String, Item> oldInventory;
    @NotNull
    private static Map<String, Item> newInventory;
    @NotNull
    private static final Regex regex;
    @NotNull
    private static final Overlay overlay;
    @NotNull
    private static final List<Map<String, OverlayLineData>> itemsShowAdded;
    @NotNull
    private static final List<Map<String, OverlayLineData>> itemsShowRemoved;

    private Pickuplog() {
    }

    public final void init() {
        overlay.init();
        overlay.setCondition((Function0<Boolean>)((Function0)Pickuplog::init$lambda$0));
        Pattern pattern = Pattern.compile("(.*?) item(.*?) (.*?)", 32);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        Register.INSTANCE.onChatMessageCancable(pattern, (Function2<? super class_2561, ? super Matcher, Boolean>)((Function2)Pickuplog::init$lambda$3));
    }

    public final void onInventorySlotUpdate(@NotNull InventorySlotUpdateEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (SBOKotlin.mc.field_1724 == null || !World.INSTANCE.isInSkyblock() || Intrinsics.areEqual((Object)World.INSTANCE.getWorld(), (Object)"None")) {
            return;
        }
        newInventory = Helper.INSTANCE.readPlayerInv();
        newPurse = Helper.INSTANCE.getPurse();
        if (oldInventory.isEmpty()) {
            oldInventory = newInventory;
            oldPurse = newPurse;
            return;
        }
        this.compareInventory();
        oldInventory = newInventory;
        oldPurse = newPurse;
        this.updateOverlay();
    }

    public final void compareInventory() {
        Item oldItem;
        long purseChange = newPurse - oldPurse;
        if (purseChange != 0L) {
            DianaTracker.INSTANCE.trackScavengerCoins(purseChange);
        }
        List newItems = new ArrayList();
        List changedItemCounts = new ArrayList();
        for (Map.Entry<String, Item> iterator : newInventory.entrySet()) {
            String string = iterator.getKey();
            Item newItem = iterator.getValue();
            oldItem = oldInventory.get(string);
            if (oldItem == null) {
                newItems.add(newItem);
                continue;
            }
            if (newItem.getCount() == oldItem.getCount()) continue;
            int countChange = newItem.getCount() - oldItem.getCount();
            changedItemCounts.add(new Pair((Object)newItem, (Object)countChange));
        }
        Map removedItems = new LinkedHashMap();
        for (Map.Entry<String, Item> entry : oldInventory.entrySet()) {
            String key2 = entry.getKey();
            oldItem = entry.getValue();
            if (newInventory.containsKey(key2)) continue;
            removedItems.put(oldItem.getItemId(), oldItem);
        }
        for (Item item : newItems) {
            this.refreshOverlay(item.getItemId(), item.getName(), item.getCount());
            if (!Intrinsics.areEqual((Object)item.getItemUUID(), (Object)"")) {
                DianaTracker.INSTANCE.trackWithPickuplog(item);
                continue;
            }
            DianaTracker.INSTANCE.trackWithPickuplogStackable(item, item.getCount());
        }
        for (Pair pair : changedItemCounts) {
            Item item = (Item)pair.component1();
            int countChange = ((Number)pair.component2()).intValue();
            this.refreshOverlay(item.getItemId(), item.getName(), countChange);
            if (countChange <= 0) continue;
            DianaTracker.INSTANCE.trackWithPickuplogStackable(item, countChange);
        }
        for (Map.Entry entry : removedItems.entrySet()) {
            String itemId = (String)entry.getKey();
            Item item = (Item)entry.getValue();
            String itemName = item.getName();
            int itemCount = -item.getCount();
            this.refreshOverlay(itemId, itemName, itemCount);
        }
    }

    public final void refreshOverlay(@NotNull String itemId, @NotNull String name, int amount) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        long currentTime = System.currentTimeMillis();
        if (amount > 0) {
            OverlayLineData existingItem;
            Object v0;
            block8: {
                Iterable iterable = itemsShowAdded;
                for (Object t : iterable) {
                    Map it = (Map)t;
                    boolean bl = false;
                    if (!it.containsKey(itemId)) continue;
                    v0 = t;
                    break block8;
                }
                v0 = null;
            }
            Map map = v0;
            OverlayLineData overlayLineData = existingItem = map != null ? (OverlayLineData)map.get(itemId) : null;
            if (existingItem != null) {
                existingItem.setAmount(existingItem.getAmount() + amount);
                existingItem.setModified(currentTime);
            } else {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)itemId, (Object)new OverlayLineData(amount, name, currentTime))};
                itemsShowAdded.add(MapsKt.mutableMapOf((Pair[])pairArray));
            }
        } else {
            OverlayLineData existingItem;
            Object v3;
            block9: {
                Iterable iterable = itemsShowRemoved;
                for (Object t : iterable) {
                    Map it = (Map)t;
                    boolean bl = false;
                    if (!it.containsKey(itemId)) continue;
                    v3 = t;
                    break block9;
                }
                v3 = null;
            }
            Map map = v3;
            OverlayLineData overlayLineData = existingItem = map != null ? (OverlayLineData)map.get(itemId) : null;
            if (existingItem != null) {
                existingItem.setAmount(existingItem.getAmount() + amount);
                existingItem.setModified(currentTime);
            } else {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)itemId, (Object)new OverlayLineData(amount, name, currentTime))};
                itemsShowRemoved.add(MapsKt.mutableMapOf((Pair[])pairArray));
            }
        }
        this.updateOverlay();
    }

    public final void updateOverlay() {
        long currentTime = System.currentTimeMillis();
        List lines = new ArrayList();
        List newAddedList = new ArrayList();
        Iterable $this$forEach$iv = itemsShowAdded;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map map = (Map)element$iv;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)CollectionsKt.first((Iterable)map.entrySet());
            String itemId = (String)entry.getKey();
            OverlayLineData data = (OverlayLineData)entry.getValue();
            if (currentTime - data.getModified() > 6000L) continue;
            newAddedList.add(map);
            lines.add(new OverlayTextLine("\u00a7a+ " + data.getAmount() + "x \u00a7r" + data.getName(), false, false, 6, null));
        }
        itemsShowAdded.clear();
        itemsShowAdded.addAll(newAddedList);
        List newRemovedList = new ArrayList();
        Iterable $this$forEach$iv2 = itemsShowRemoved;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Map map = (Map)element$iv;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)CollectionsKt.first((Iterable)map.entrySet());
            String itemId = (String)entry.getKey();
            OverlayLineData data = (OverlayLineData)entry.getValue();
            if (currentTime - data.getModified() > 6000L) continue;
            newRemovedList.add(map);
            lines.add(new OverlayTextLine("\u00a7c- " + -data.getAmount() + "x \u00a7r" + data.getName(), false, false, 6, null));
        }
        itemsShowRemoved.clear();
        itemsShowRemoved.addAll(newRemovedList);
        overlay.setLines(lines);
    }

    private static final boolean init$lambda$0() {
        return QOL.INSTANCE.getPickuplogOverlay();
    }

    private static final boolean init$lambda$3(class_2561 message, Matcher matchResult) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
        boolean cancel = false;
        cancel = true;
        if (World.INSTANCE.isInSkyblock()) {
            String string = matchResult.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"Sacks", (boolean)false, (int)2, null)) {
                List list = message.method_10855();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSiblings(...)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    class_2561 part = (class_2561)element$iv;
                    boolean bl = false;
                    String string2 = part.getString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                    if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)" item", (boolean)false, (int)2, null)) continue;
                    class_2568 hover = part.method_10866().method_10969();
                    if (hover instanceof class_2568.class_10613) {
                        String plain = ((class_2568.class_10613)hover).comp_3510().getString();
                        Intrinsics.checkNotNull((Object)plain);
                        Sequence $this$forEach$iv2 = Regex.findAll$default((Regex)regex, (CharSequence)plain, (int)0, (int)2, null);
                        boolean $i$f$forEach2 = false;
                        for (Object element$iv2 : $this$forEach$iv2) {
                            MatchResult match = (MatchResult)element$iv2;
                            boolean bl2 = false;
                            String amount = StringsKt.replace$default((String)((String)match.getGroupValues().get(1)), (String)",", (String)"", (boolean)false, (int)4, null);
                            String item = ((Object)StringsKt.trim((CharSequence)((String)match.getGroupValues().get(2)))).toString();
                            DianaTracker.INSTANCE.trackWithSacksMessage(item, Integer.parseInt(amount));
                        }
                    }
                    cancel = !QOL.INSTANCE.getHideSacksMSG();
                }
            }
        }
        return cancel;
    }

    static {
        oldInventory = new LinkedHashMap();
        newInventory = new LinkedHashMap();
        regex = new Regex("\\+([\\d,]+) ([^\\(]+)");
        Object[] objectArray = new String[]{"Chat screen", "Crafting"};
        overlay = new Overlay("pickuplog", 5.0f, 5.0f, 1.0f, CollectionsKt.listOf((Object[])objectArray), OverlayExamples.INSTANCE.getPickupLogExample());
        itemsShowAdded = new ArrayList();
        itemsShowRemoved = new ArrayList();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u000f\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ.\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0014\u001a\u00020\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u000bJ\u0010\u0010\u0017\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\rR\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\u000b\"\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001c\u001a\u0004\b\u001d\u0010\rR\"\u0010\u0007\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010\u001e\u001a\u0004\b\u001f\u0010\u000f\"\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lnet/sbo/mod/general/Pickuplog$OverlayLineData;", "", "", "amount", "", "name", "", "modified", "<init>", "(ILjava/lang/String;J)V", "component1", "()I", "component2", "()Ljava/lang/String;", "component3", "()J", "copy", "(ILjava/lang/String;J)Lnet/sbo/mod/general/Pickuplog$OverlayLineData;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "I", "getAmount", "setAmount", "(I)V", "Ljava/lang/String;", "getName", "J", "getModified", "setModified", "(J)V", "sbo"})
    public static final class OverlayLineData {
        private int amount;
        @NotNull
        private final String name;
        private long modified;

        public OverlayLineData(int amount, @NotNull String name, long modified) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.amount = amount;
            this.name = name;
            this.modified = modified;
        }

        public final int getAmount() {
            return this.amount;
        }

        public final void setAmount(int n) {
            this.amount = n;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final long getModified() {
            return this.modified;
        }

        public final void setModified(long l) {
            this.modified = l;
        }

        public final int component1() {
            return this.amount;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        public final long component3() {
            return this.modified;
        }

        @NotNull
        public final OverlayLineData copy(int amount, @NotNull String name, long modified) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new OverlayLineData(amount, name, modified);
        }

        public static /* synthetic */ OverlayLineData copy$default(OverlayLineData overlayLineData, int n, String string, long l, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = overlayLineData.amount;
            }
            if ((n2 & 2) != 0) {
                string = overlayLineData.name;
            }
            if ((n2 & 4) != 0) {
                l = overlayLineData.modified;
            }
            return overlayLineData.copy(n, string, l);
        }

        @NotNull
        public String toString() {
            return "OverlayLineData(amount=" + this.amount + ", name=" + this.name + ", modified=" + this.modified + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.amount);
            result = result * 31 + this.name.hashCode();
            result = result * 31 + Long.hashCode(this.modified);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OverlayLineData)) {
                return false;
            }
            OverlayLineData overlayLineData = (OverlayLineData)other;
            if (this.amount != overlayLineData.amount) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)overlayLineData.name)) {
                return false;
            }
            return this.modified == overlayLineData.modified;
        }
    }
}

