/*
 * Decompiled with CFR 0.152.
 */
package net.sbo.mod.utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.sbo.mod.SBOKotlin;
import net.sbo.mod.utils.data.SboDataObject;
import net.sbo.mod.utils.events.Register;
import net.sbo.mod.utils.events.impl.DisconnectEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\n\u0010\tJ\u0015\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000f\u0010\u0003R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0014\u001a\u0004\b\u0018\u0010\u0016R\u0017\u0010\u0019\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0014\u001a\u0004\b\u001a\u0010\u0016\u00a8\u0006\u001c"}, d2={"Lnet/sbo/mod/utils/SboTimerManager;", "", "<init>", "()V", "", "init", "Lnet/sbo/mod/utils/SboTimerManager$SBOTimer;", "timer", "addTimer", "(Lnet/sbo/mod/utils/SboTimerManager$SBOTimer;)V", "removeTimer", "Lnet/sbo/mod/utils/events/impl/DisconnectEvent;", "event", "onDisconnect", "(Lnet/sbo/mod/utils/events/impl/DisconnectEvent;)V", "updateAllActivity", "", "activeTimers", "Ljava/util/List;", "timerMayor", "Lnet/sbo/mod/utils/SboTimerManager$SBOTimer;", "getTimerMayor", "()Lnet/sbo/mod/utils/SboTimerManager$SBOTimer;", "timerTotal", "getTimerTotal", "timerSession", "getTimerSession", "SBOTimer", "sbo"})
@SourceDebugExtension(value={"SMAP\nSboTimerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SboTimerManager.kt\nnet/sbo/mod/utils/SboTimerManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,240:1\n1869#2,2:241\n1869#2,2:243\n1869#2,2:245\n*S KotlinDebug\n*F\n+ 1 SboTimerManager.kt\nnet/sbo/mod/utils/SboTimerManager\n*L\n53#1:241,2\n57#1:243,2\n37#1:245,2\n*E\n"})
public final class SboTimerManager {
    @NotNull
    public static final SboTimerManager INSTANCE = new SboTimerManager();
    @NotNull
    private static final List<SBOTimer> activeTimers = new ArrayList();
    @NotNull
    private static final SBOTimer timerMayor = new SBOTimer("Mayor", 1.5f, SboDataObject.dianaTrackerMayor, "TIME", "items");
    @NotNull
    private static final SBOTimer timerTotal = new SBOTimer("Total", 1.5f, SboDataObject.dianaTrackerTotal, "TIME", "items");
    @NotNull
    private static final SBOTimer timerSession = new SBOTimer("Session", 1.5f, SboDataObject.dianaTrackerSession, "TIME", "items");

    private SboTimerManager() {
    }

    @NotNull
    public final SBOTimer getTimerMayor() {
        return timerMayor;
    }

    @NotNull
    public final SBOTimer getTimerTotal() {
        return timerTotal;
    }

    @NotNull
    public final SBOTimer getTimerSession() {
        return timerSession;
    }

    public final void init() {
        Register.INSTANCE.onTick(1, (Function1<? super Function0<Unit>, Unit>)((Function1)SboTimerManager::init$lambda$1));
    }

    private final void addTimer(SBOTimer timer) {
        if (!activeTimers.contains(timer)) {
            activeTimers.add(timer);
        }
    }

    private final void removeTimer(SBOTimer timer) {
        activeTimers.remove(timer);
    }

    public final void onDisconnect(@NotNull DisconnectEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)activeTimers);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SBOTimer it = (SBOTimer)element$iv;
            boolean bl = false;
            it.pause();
        }
    }

    public final void updateAllActivity() {
        Iterable $this$forEach$iv = SBOTimer.Companion.getTimerList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SBOTimer it = (SBOTimer)element$iv;
            boolean bl = false;
            it.updateActivity();
        }
    }

    private static final Unit init$lambda$1(Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)activeTimers);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SBOTimer it2 = (SBOTimer)element$iv;
            boolean bl = false;
            it2.tick();
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u0006\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u0000 <2\u00020\u0001:\u0001<B3\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\t\u0010\nJ!\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0011\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\r\u0010\u0019\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\r\u0010\u001b\u001a\u00020\u0012\u00a2\u0006\u0004\b\u001b\u0010\u001aJ\u000f\u0010\u001c\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001aJ\r\u0010\u001d\u001a\u00020\u0012\u00a2\u0006\u0004\b\u001d\u0010\u001aJ\r\u0010\u001e\u001a\u00020\u0012\u00a2\u0006\u0004\b\u001e\u0010\u001aJ\r\u0010\u001f\u001a\u00020\u0012\u00a2\u0006\u0004\b\u001f\u0010\u001aJ\r\u0010!\u001a\u00020 \u00a2\u0006\u0004\b!\u0010\"J\r\u0010#\u001a\u00020\u0012\u00a2\u0006\u0004\b#\u0010\u001aJ\u000f\u0010$\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b$\u0010\u001aJ\u000f\u0010%\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b%\u0010\u001aR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010&\u001a\u0004\b'\u0010(R\u0014\u0010\u0006\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010)R\u0014\u0010\u0007\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010&R\u0016\u0010\b\u001a\u0004\u0018\u00010\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010&R\u0016\u0010*\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010+R\"\u0010,\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b,\u0010+\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\"\u00102\u001a\u0002018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b2\u00103\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u0016\u00108\u001a\u0002018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00103R\u0016\u00109\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b9\u0010+R\u0014\u0010:\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b:\u0010+R\u0016\u0010;\u001a\u0002018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b;\u00103\u00a8\u0006="}, d2={"Lnet/sbo/mod/utils/SboTimerManager$SBOTimer;", "", "", "name", "", "inactiveTimeLimit", "trackerObject", "dataFieldName", "dataFieldClass", "<init>", "(Ljava/lang/String;FLjava/lang/Object;Ljava/lang/String;Ljava/lang/String;)V", "obj", "fieldName", "Ljava/lang/reflect/Field;", "getField", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/reflect/Field;", "", "value", "", "setLongField", "(Ljava/lang/Object;Ljava/lang/String;J)V", "getLongField", "(Ljava/lang/Object;Ljava/lang/String;)J", "getTargetObject", "()Ljava/lang/Object;", "start", "()V", "tick", "updateElapsedTime", "pause", "continueTimer", "reset", "", "getHourTime", "()D", "updateActivity", "startInactivityCheck", "stopInactivityCheck", "Ljava/lang/String;", "getName", "()Ljava/lang/String;", "Ljava/lang/Object;", "startTime", "J", "elapsedTime", "getElapsedTime", "()J", "setElapsedTime", "(J)V", "", "running", "Z", "getRunning", "()Z", "setRunning", "(Z)V", "startedOnce", "lastActivityTime", "INACTIVITY_LIMIT", "inactivityFlag", "Companion", "sbo"})
    public static final class SBOTimer {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String name;
        @NotNull
        private final Object trackerObject;
        @NotNull
        private final String dataFieldName;
        @Nullable
        private final String dataFieldClass;
        private long startTime;
        private long elapsedTime;
        private boolean running;
        private boolean startedOnce;
        private long lastActivityTime;
        private final long INACTIVITY_LIMIT;
        private boolean inactivityFlag;
        @NotNull
        private static final List<SBOTimer> timerList = new ArrayList();

        public SBOTimer(@NotNull String name, float inactiveTimeLimit, @NotNull Object trackerObject, @NotNull String dataFieldName, @Nullable String dataFieldClass) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)trackerObject, (String)"trackerObject");
            Intrinsics.checkNotNullParameter((Object)dataFieldName, (String)"dataFieldName");
            this.name = name;
            this.trackerObject = trackerObject;
            this.dataFieldName = dataFieldName;
            this.dataFieldClass = dataFieldClass;
            this.lastActivityTime = System.currentTimeMillis();
            this.INACTIVITY_LIMIT = (long)(inactiveTimeLimit * (float)60 * (float)1000);
            timerList.add(this);
        }

        public /* synthetic */ SBOTimer(String string, float f, Object object, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                string3 = null;
            }
            this(string, f, object, string2, string3);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final long getElapsedTime() {
            return this.elapsedTime;
        }

        public final void setElapsedTime(long l) {
            this.elapsedTime = l;
        }

        public final boolean getRunning() {
            return this.running;
        }

        public final void setRunning(boolean bl) {
            this.running = bl;
        }

        private final Field getField(Object obj, String fieldName) {
            Object var3_3;
            try {
                Field field = obj.getClass().getDeclaredField(fieldName);
                field.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                SBOKotlin.INSTANCE.getLogger$sbo().warn("Field '" + fieldName + "' not found in object of class '" + obj.getClass().getName() + "'", (Throwable)e);
                var3_3 = null;
            }
            return var3_3;
        }

        private final void setLongField(Object obj, String fieldName, long value) {
            Field field = this.getField(obj, fieldName);
            if (field != null) {
                field.set(obj, value);
            } else {
                SBOKotlin.INSTANCE.getLogger$sbo().warn("Field '" + fieldName + "' not found in object of class '" + obj.getClass().getName() + "'");
            }
        }

        private final long getLongField(Object obj, String fieldName) {
            Field field = this.getField(obj, fieldName);
            if (field != null) {
                return field.getLong(obj);
            }
            return 0L;
        }

        private final Object getTargetObject() {
            Object object;
            if (this.dataFieldClass != null) {
                Field field;
                Field field2 = field = this.getField(this.trackerObject, this.dataFieldClass);
                object = field2 != null ? field2.get(this.trackerObject) : null;
            } else {
                object = this.trackerObject;
            }
            return object;
        }

        public final void start() {
            if (this.running || this.startedOnce) {
                return;
            }
            this.startTime = System.currentTimeMillis();
            Object object = this.getTargetObject();
            if (object == null) {
                return;
            }
            Object target = object;
            long storedTime = this.getLongField(target, this.dataFieldName);
            if (storedTime > 0L) {
                this.elapsedTime = storedTime;
            }
            this.running = true;
            this.startedOnce = true;
            this.updateElapsedTime();
            this.startInactivityCheck();
        }

        public final void tick() {
            if (!this.running) {
                return;
            }
            this.updateElapsedTime();
            if (System.currentTimeMillis() - this.lastActivityTime > this.INACTIVITY_LIMIT) {
                this.pause();
                if (!this.inactivityFlag) {
                    Object object = this.getTargetObject();
                    if (object == null) {
                        return;
                    }
                    Object target = object;
                    long currentTime = this.getLongField(target, this.dataFieldName);
                    this.setLongField(target, this.dataFieldName, currentTime - this.INACTIVITY_LIMIT);
                    this.inactivityFlag = true;
                }
            }
        }

        private final void updateElapsedTime() {
            if (!this.running) {
                return;
            }
            long now = System.currentTimeMillis();
            this.elapsedTime += now - this.startTime;
            this.startTime = now;
            Object object = this.getTargetObject();
            if (object == null) {
                return;
            }
            Object target = object;
            this.setLongField(target, this.dataFieldName, this.elapsedTime);
        }

        public final void pause() {
            if (!this.running) {
                return;
            }
            this.updateElapsedTime();
            this.running = false;
            this.stopInactivityCheck();
        }

        public final void continueTimer() {
            if (this.running) {
                return;
            }
            if (this.inactivityFlag) {
                this.elapsedTime -= this.INACTIVITY_LIMIT;
            }
            this.startTime = System.currentTimeMillis();
            this.running = true;
            this.startInactivityCheck();
        }

        public final void reset() {
            this.running = false;
            this.startedOnce = false;
            this.elapsedTime = 0L;
            this.startTime = 0L;
            Object object = this.getTargetObject();
            if (object == null) {
                return;
            }
            Object target = object;
            this.setLongField(target, this.dataFieldName, 0L);
            this.stopInactivityCheck();
        }

        public final double getHourTime() {
            Object object = this.getTargetObject();
            if (object == null) {
                return 0.0;
            }
            Object target = object;
            long millisecondTime = this.getLongField(target, this.dataFieldName);
            Locale locale = Locale.US;
            String string = "%.6f";
            Object[] objectArray = new Object[]{(double)millisecondTime / 3600000.0};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            String formattedString = string2;
            return Double.parseDouble(formattedString);
        }

        public final void updateActivity() {
            this.start();
            this.continueTimer();
            this.lastActivityTime = System.currentTimeMillis();
        }

        private final void startInactivityCheck() {
            INSTANCE.addTimer(this);
            this.inactivityFlag = false;
        }

        private final void stopInactivityCheck() {
            INSTANCE.removeTimer(this);
            this.inactivityFlag = false;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lnet/sbo/mod/utils/SboTimerManager$SBOTimer$Companion;", "", "<init>", "()V", "", "Lnet/sbo/mod/utils/SboTimerManager$SBOTimer;", "timerList", "Ljava/util/List;", "getTimerList", "()Ljava/util/List;", "sbo"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<SBOTimer> getTimerList() {
                return timerList;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

