/*
 * Decompiled with CFR 0.152.
 */
package net.sbo.mod.utils.chat;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_2561;
import net.sbo.mod.settings.categories.Debug;
import net.sbo.mod.utils.chat.ChatUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J/\u0010\r\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\t\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lnet/sbo/mod/utils/chat/ChatHandler;", "", "<init>", "()V", "", "init", "Ljava/util/regex/Pattern;", "pattern", "Lkotlin/Function2;", "Lnet/minecraft/class_2561;", "Ljava/util/regex/Matcher;", "", "action", "registerHandler", "(Ljava/util/regex/Pattern;Lkotlin/jvm/functions/Function2;)V", "message", "processMessage", "(Lnet/minecraft/class_2561;)Z", "", "Lnet/sbo/mod/utils/chat/ChatHandler$ChatRule;", "messageHandlers", "Ljava/util/List;", "Lkotlin/text/Regex;", "spammyPattern", "Lkotlin/text/Regex;", "ChatRule", "sbo"})
@SourceDebugExtension(value={"SMAP\nChatHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatHandler.kt\nnet/sbo/mod/utils/chat/ChatHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,49:1\n1869#2,2:50\n*S KotlinDebug\n*F\n+ 1 ChatHandler.kt\nnet/sbo/mod/utils/chat/ChatHandler\n*L\n34#1:50,2\n*E\n"})
public final class ChatHandler {
    @NotNull
    public static final ChatHandler INSTANCE = new ChatHandler();
    @NotNull
    private static final List<ChatRule> messageHandlers = new ArrayList();
    @NotNull
    private static final Regex spammyPattern = new Regex("\u00a7[0-9a-fk-or].+[0-9,]+\\/[0-9,]+\u2764.*");

    private ChatHandler() {
    }

    public final void init() {
        ClientReceiveMessageEvents.ALLOW_GAME.register(ChatHandler::init$lambda$0);
    }

    public final void registerHandler(@NotNull Pattern pattern, @NotNull Function2<? super class_2561, ? super Matcher, Boolean> action) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        messageHandlers.add(new ChatRule(pattern, action));
    }

    public final boolean processMessage(@NotNull class_2561 message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String messageString = StringsKt.replace$default((String)ChatUtils.INSTANCE.formattedString(message), (String)"\u00a7r", (String)"", (boolean)false, (int)4, null);
        if (Debug.INSTANCE.getDebugMessages() && !StringsKt.contains$default((CharSequence)messageString, (CharSequence)"\u2748 Defense", (boolean)false, (int)2, null)) {
            System.out.println((Object)("Processing chat message: " + messageString));
        }
        boolean allowMessage = false;
        allowMessage = true;
        Iterable $this$forEach$iv = messageHandlers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChatRule rule = (ChatRule)element$iv;
            boolean bl = false;
            Matcher matcher = rule.getPattern().matcher(messageString);
            if (!matcher.find()) continue;
            Function2<class_2561, Matcher, Boolean> function2 = rule.getAction();
            Intrinsics.checkNotNull((Object)matcher);
            boolean result = (Boolean)function2.invoke((Object)message, (Object)matcher);
            if (result) continue;
            allowMessage = false;
        }
        return allowMessage;
    }

    private static final boolean init$lambda$0(class_2561 message, boolean overlay) {
        String string = message.getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        if (spammyPattern.matches((CharSequence)string)) {
            return true;
        }
        Intrinsics.checkNotNull((Object)message);
        return INSTANCE.processMessage(message);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0082\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\"\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ6\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\u001a\b\u0002\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001a\u0010\u0012\u001a\u00020\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u0017H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001a\u001a\u0004\b\u001b\u0010\fR)\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00048\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u001c\u001a\u0004\b\u001d\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lnet/sbo/mod/utils/chat/ChatHandler$ChatRule;", "", "Ljava/util/regex/Pattern;", "pattern", "Lkotlin/Function2;", "Lnet/minecraft/class_2561;", "Ljava/util/regex/Matcher;", "", "action", "<init>", "(Ljava/util/regex/Pattern;Lkotlin/jvm/functions/Function2;)V", "component1", "()Ljava/util/regex/Pattern;", "component2", "()Lkotlin/jvm/functions/Function2;", "copy", "(Ljava/util/regex/Pattern;Lkotlin/jvm/functions/Function2;)Lnet/sbo/mod/utils/chat/ChatHandler$ChatRule;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/util/regex/Pattern;", "getPattern", "Lkotlin/jvm/functions/Function2;", "getAction", "sbo"})
    private static final class ChatRule {
        @NotNull
        private final Pattern pattern;
        @NotNull
        private final Function2<class_2561, Matcher, Boolean> action;

        public ChatRule(@NotNull Pattern pattern, @NotNull Function2<? super class_2561, ? super Matcher, Boolean> action) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            this.pattern = pattern;
            this.action = action;
        }

        @NotNull
        public final Pattern getPattern() {
            return this.pattern;
        }

        @NotNull
        public final Function2<class_2561, Matcher, Boolean> getAction() {
            return this.action;
        }

        @NotNull
        public final Pattern component1() {
            return this.pattern;
        }

        @NotNull
        public final Function2<class_2561, Matcher, Boolean> component2() {
            return this.action;
        }

        @NotNull
        public final ChatRule copy(@NotNull Pattern pattern, @NotNull Function2<? super class_2561, ? super Matcher, Boolean> action) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            return new ChatRule(pattern, action);
        }

        public static /* synthetic */ ChatRule copy$default(ChatRule chatRule, Pattern pattern, Function2 function2, int n, Object object) {
            if ((n & 1) != 0) {
                pattern = chatRule.pattern;
            }
            if ((n & 2) != 0) {
                function2 = chatRule.action;
            }
            return chatRule.copy(pattern, function2);
        }

        @NotNull
        public String toString() {
            return "ChatRule(pattern=" + this.pattern + ", action=" + this.action + ")";
        }

        public int hashCode() {
            int result = this.pattern.hashCode();
            result = result * 31 + this.action.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ChatRule)) {
                return false;
            }
            ChatRule chatRule = (ChatRule)other;
            if (!Intrinsics.areEqual((Object)this.pattern, (Object)chatRule.pattern)) {
                return false;
            }
            return Intrinsics.areEqual(this.action, chatRule.action);
        }
    }
}

