/*
 * Decompiled with CFR 0.152.
 */
package net.sbo.mod.diana;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_2561;
import net.minecraft.class_638;
import net.sbo.mod.SBOKotlin;
import net.sbo.mod.settings.categories.Diana;
import net.sbo.mod.utils.Helper;
import net.sbo.mod.utils.Player;
import net.sbo.mod.utils.chat.Chat;
import net.sbo.mod.utils.chat.ChatUtils;
import net.sbo.mod.utils.events.Register;
import net.sbo.mod.utils.math.SboVec;
import net.sbo.mod.utils.overlay.Overlay;
import net.sbo.mod.utils.overlay.OverlayTextLine;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J'\u0010\n\u001a\u00020\u00042\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ#\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00070\u00102\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001b\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0019\u0010\u0019\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0017J\r\u0010\u001a\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001a\u0010\u0003R \u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00070\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R,\u0010\"\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u00060!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0014\u0010%\u001a\u00020$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lnet/sbo/mod/diana/DianaMobDetect;", "", "<init>", "()V", "", "init", "Lkotlin/Function2;", "", "Lnet/minecraft/class_1531;", "listener", "onMobDeath", "(Lkotlin/jvm/functions/Function2;)V", "Lnet/minecraft/class_638;", "world", "updateTrackedArmorStands", "(Lnet/minecraft/class_638;)V", "", "", "getMatchingArmorStands", "(Lnet/minecraft/class_638;)Ljava/util/Map;", "name", "", "extractHealth", "(Ljava/lang/String;)Ljava/lang/Double;", "health", "parseHealth", "onInqSpawn", "", "trackedArmorStands", "Ljava/util/Map;", "", "defeatedMobs", "Ljava/util/Set;", "", "mobDeathListeners", "Ljava/util/List;", "Lnet/sbo/mod/utils/overlay/Overlay;", "mobHpOverlay", "Lnet/sbo/mod/utils/overlay/Overlay;", "sbo"})
@SourceDebugExtension(value={"SMAP\nDianaMobDetect.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DianaMobDetect.kt\nnet/sbo/mod/diana/DianaMobDetect\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1869#2,2:104\n*S KotlinDebug\n*F\n+ 1 DianaMobDetect.kt\nnet/sbo/mod/diana/DianaMobDetect\n*L\n63#1:104,2\n*E\n"})
public final class DianaMobDetect {
    @NotNull
    public static final DianaMobDetect INSTANCE = new DianaMobDetect();
    @NotNull
    private static final Map<Integer, String> trackedArmorStands = new LinkedHashMap();
    @NotNull
    private static final Set<Integer> defeatedMobs = new LinkedHashSet();
    @NotNull
    private static final List<Function2<String, class_1531, Unit>> mobDeathListeners = new ArrayList();
    @NotNull
    private static final Overlay mobHpOverlay = new Overlay("mythosMobHp", 10.0f, 10.0f, 1.0f, CollectionsKt.listOf((Object)"Chat screen")).setCondition((Function0<Boolean>)((Function0)DianaMobDetect::mobHpOverlay$lambda$0));

    private DianaMobDetect() {
    }

    public final void init() {
        mobHpOverlay.init();
        Register.INSTANCE.onTick(1, (Function1<? super Function0<Unit>, Unit>)((Function1)DianaMobDetect::init$lambda$1));
    }

    public final void onMobDeath(@NotNull Function2<? super String, ? super class_1531, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        mobDeathListeners.add(listener);
    }

    private final void updateTrackedArmorStands(class_638 world) {
        Map<Integer, String> currentArmorStands = this.getMatchingArmorStands(world);
        List overlayLines = new ArrayList();
        Set removed = SetsKt.minus(trackedArmorStands.keySet(), (Iterable)currentArmorStands.keySet());
        defeatedMobs.removeAll(removed);
        trackedArmorStands.keySet().retainAll((Collection)currentArmorStands.keySet());
        for (Map.Entry<Integer, String> entry : currentArmorStands.entrySet()) {
            int id = ((Number)entry.getKey()).intValue();
            String name = entry.getValue();
            Integer n = id;
            trackedArmorStands.put(n, name);
            overlayLines.add(new OverlayTextLine(name, false, false, 6, null));
        }
        mobHpOverlay.setLines(overlayLines);
    }

    private final Map<Integer, String> getMatchingArmorStands(class_638 world) {
        Map armorstands = new LinkedHashMap();
        for (class_1297 entity : world.method_18112()) {
            Object name;
            if (!(entity instanceof class_1531)) continue;
            Object object = ((class_1531)entity).method_5797();
            if (object == null || (object = ChatUtils.INSTANCE.formattedString((class_2561)object)) == null) {
                class_2561 class_25612 = ((class_1531)entity).method_5477();
                Intrinsics.checkNotNullExpressionValue((Object)class_25612, (String)"getName(...)");
                object = ChatUtils.INSTANCE.formattedString(class_25612);
            }
            if (((CharSequence)(name = object)).length() == 0 || Intrinsics.areEqual((Object)name, (Object)"Armor Stand") || !StringsKt.contains((CharSequence)((CharSequence)name), (CharSequence)"\u00a72\u273f", (boolean)true)) continue;
            Double currentHealth = this.extractHealth((String)name);
            if (currentHealth != null && currentHealth <= 0.0 && !defeatedMobs.contains(((class_1531)entity).method_5628())) {
                defeatedMobs.add(((class_1531)entity).method_5628());
                Iterable $this$forEach$iv = mobDeathListeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Function2 it = (Function2)element$iv;
                    boolean bl = false;
                    it.invoke(name, (Object)entity);
                }
            }
            armorstands.put(((class_1531)entity).method_5628(), name);
        }
        return armorstands;
    }

    private final Double extractHealth(String name) {
        if (name == null) {
            return null;
        }
        Regex regex = new Regex("([0-9]+(?:\\.[0-9]+)?[MK]?)\u00a7f/");
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)name, (int)0, (int)2, null);
        Object object = matchResult;
        if (object == null || (object = object.getGroups()) == null || (object = object.get(1)) == null || (object = object.getValue()) == null) {
            return null;
        }
        Object healthString = object;
        return this.parseHealth((String)healthString);
    }

    private final Double parseHealth(String health) {
        Double d;
        if (StringsKt.endsWith$default((String)health, (String)"M", (boolean)false, (int)2, null)) {
            Double d2 = StringsKt.toDoubleOrNull((String)StringsKt.dropLast((String)health, (int)1));
            d = d2 != null ? Double.valueOf(d2 * (double)1000000) : null;
        } else if (StringsKt.endsWith$default((String)health, (String)"K", (boolean)false, (int)2, null)) {
            Double d3 = StringsKt.toDoubleOrNull((String)StringsKt.dropLast((String)health, (int)1));
            d = d3 != null ? Double.valueOf(d3 * (double)1000) : null;
        } else {
            d = StringsKt.toDoubleOrNull((String)health);
        }
        return d;
    }

    public final void onInqSpawn() {
        block2: {
            if (Diana.INSTANCE.getShareInq()) {
                SboVec playerPos = Player.INSTANCE.getLastPosition();
                Chat.INSTANCE.command("pc x: " + MathKt.roundToInt((double)playerPos.getX()) + ", y: " + (MathKt.roundToInt((double)playerPos.getY()) - 1) + ", z: " + MathKt.roundToInt((double)playerPos.getZ()));
            }
            String string = (String)ArraysKt.firstOrNull((Object[])Diana.INSTANCE.getAnnounceKilltext());
            if (string == null) break block2;
            String killText = string;
            boolean bl = false;
            if (!StringsKt.isBlank((CharSequence)killText)) {
                Helper.INSTANCE.sleep(5000L, (Function0<Unit>)((Function0)DianaMobDetect::onInqSpawn$lambda$4$lambda$3));
            }
        }
    }

    private static final boolean mobHpOverlay$lambda$0() {
        return Diana.INSTANCE.getMythosMobHp();
    }

    private static final Unit init$lambda$1(Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        class_638 world = SBOKotlin.mc.field_1687;
        if (world != null) {
            INSTANCE.updateTrackedArmorStands(world);
        }
        return Unit.INSTANCE;
    }

    private static final Unit onInqSpawn$lambda$4$lambda$3() {
        Chat.INSTANCE.command("pc " + Diana.INSTANCE.getAnnounceKilltext()[0]);
        return Unit.INSTANCE;
    }
}

