/*
 * Decompiled with CFR 0.152.
 */
package net.sbo.mod.utils.http;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import net.sbo.mod.utils.http.HttpRequestHandle;
import net.sbo.mod.utils.http.HttpResponse;
import net.sbo.mod.utils.http.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0019\u0010\u0015\u001a\u00020\u0014*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001b\u0010\u0017\u001a\u0004\u0018\u00010\u0004*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001b\u0010\u001a\u001a\u0004\u0018\u00010\u0019*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001b\u0010\u001d\u001a\u0004\u0018\u00010\u001c*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001b\u0010 \u001a\u0004\u0018\u00010\u001f*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\u0004\b \u0010!J'\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0001\u0018\u00010\"*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\u0004\b#\u0010$J!\u0010&\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010%*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\u0004\b&\u0010'R\u0017\u0010)\u001a\u00020(8\u0006\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020\u00198\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0014\u0010/\u001a\u00020\u00198\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b/\u0010.R\u0014\u00100\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b0\u00101\u00a8\u00062"}, d2={"Lnet/sbo/mod/utils/http/Http;", "", "<init>", "()V", "", "urlString", "Lnet/sbo/mod/utils/http/HttpRequestHandle;", "sendGetRequest", "(Ljava/lang/String;)Lnet/sbo/mod/utils/http/HttpRequestHandle;", "jsonBody", "sendPostRequest", "(Ljava/lang/String;Ljava/lang/String;)Lnet/sbo/mod/utils/http/HttpRequestHandle;", "Ljava/net/HttpURLConnection;", "connection", "handle", "", "handleConnection", "(Ljava/net/HttpURLConnection;Lnet/sbo/mod/utils/http/HttpRequestHandle;)V", "Lkotlinx/serialization/json/JsonObject;", "key", "", "getBoolean", "(Lkotlinx/serialization/json/JsonObject;Ljava/lang/String;)Z", "getString", "(Lkotlinx/serialization/json/JsonObject;Ljava/lang/String;)Ljava/lang/String;", "", "getInt", "(Lkotlinx/serialization/json/JsonObject;Ljava/lang/String;)Ljava/lang/Integer;", "", "getLong", "(Lkotlinx/serialization/json/JsonObject;Ljava/lang/String;)Ljava/lang/Long;", "", "getDouble", "(Lkotlinx/serialization/json/JsonObject;Ljava/lang/String;)Ljava/lang/Double;", "", "getMutableMap", "(Lkotlinx/serialization/json/JsonObject;Ljava/lang/String;)Ljava/util/Map;", "", "getArray", "(Lkotlinx/serialization/json/JsonObject;Ljava/lang/String;)Ljava/util/List;", "Lkotlinx/serialization/json/Json;", "jsonParser", "Lkotlinx/serialization/json/Json;", "getJsonParser", "()Lkotlinx/serialization/json/Json;", "CONNECT_TIMEOUT", "I", "READ_TIMEOUT", "USER_AGENT", "Ljava/lang/String;", "sbo"})
@SourceDebugExtension(value={"SMAP\nHttp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http.kt\nnet/sbo/mod/utils/http/Http\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,140:1\n463#2:141\n413#2:142\n1252#3,4:143\n1563#3:147\n1634#3,3:148\n1#4:151\n*S KotlinDebug\n*F\n+ 1 Http.kt\nnet/sbo/mod/utils/http/Http\n*L\n124#1:141\n124#1:142\n124#1:143,4\n133#1:147\n133#1:148,3\n*E\n"})
public final class Http {
    @NotNull
    public static final Http INSTANCE = new Http();
    @NotNull
    private static final Json jsonParser = JsonKt.Json$default(null, Http::jsonParser$lambda$0, (int)1, null);
    private static final int CONNECT_TIMEOUT = 10000;
    private static final int READ_TIMEOUT = 10000;
    @NotNull
    private static final String USER_AGENT = "SBO-Kotlin-Mod/1.21.5";

    private Http() {
    }

    @NotNull
    public final Json getJsonParser() {
        return jsonParser;
    }

    @NotNull
    public final HttpRequestHandle sendGetRequest(@NotNull String urlString) {
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        HttpRequestHandle handle = new HttpRequestHandle();
        CompletableFuture.runAsync(() -> Http.sendGetRequest$lambda$2(urlString, handle));
        return handle;
    }

    @NotNull
    public final HttpRequestHandle sendPostRequest(@NotNull String urlString, @NotNull String jsonBody) {
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        Intrinsics.checkNotNullParameter((Object)jsonBody, (String)"jsonBody");
        HttpRequestHandle handle = new HttpRequestHandle();
        CompletableFuture.runAsync(() -> Http.sendPostRequest$lambda$5(urlString, handle, jsonBody));
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleConnection(HttpURLConnection connection, HttpRequestHandle handle) {
        try {
            String responseMessage;
            int responseCode = connection.getResponseCode();
            String string = connection.getResponseMessage();
            if (string == null) {
                string = responseMessage = "";
            }
            ResponseBody responseBody = (200 <= responseCode ? responseCode < 300 : false) ? new ResponseBody(connection.getInputStream()) : new ResponseBody(connection.getErrorStream());
            HttpResponse httpResponse = new HttpResponse(responseCode, responseMessage, responseBody);
            handle.complete$sbo(httpResponse);
        }
        catch (Exception e) {
            handle.fail(e);
        }
        finally {
            connection.disconnect();
        }
    }

    public final boolean getBoolean(@NotNull JsonObject $this$getBoolean, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)$this$getBoolean, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = (JsonElement)$this$getBoolean.get((Object)key);
        return object != null && (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) != null && (object = JsonElementKt.getBooleanOrNull((JsonPrimitive)object)) != null ? (Boolean)object : false;
    }

    @Nullable
    public final String getString(@NotNull JsonObject $this$getString, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)$this$getString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        JsonElement jsonElement = (JsonElement)$this$getString.get((Object)key);
        return jsonElement != null && (jsonElement = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null ? JsonElementKt.getContentOrNull((JsonPrimitive)jsonElement) : null;
    }

    @Nullable
    public final Integer getInt(@NotNull JsonObject $this$getInt, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)$this$getInt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = (JsonElement)$this$getInt.get((Object)key);
        return object != null && (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) != null && (object = JsonElementKt.getContentOrNull((JsonPrimitive)object)) != null ? StringsKt.toIntOrNull((String)object) : null;
    }

    @Nullable
    public final Long getLong(@NotNull JsonObject $this$getLong, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)$this$getLong, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = (JsonElement)$this$getLong.get((Object)key);
        return object != null && (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) != null && (object = JsonElementKt.getContentOrNull((JsonPrimitive)object)) != null ? StringsKt.toLongOrNull((String)object) : null;
    }

    @Nullable
    public final Double getDouble(@NotNull JsonObject $this$getDouble, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)$this$getDouble, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = (JsonElement)$this$getDouble.get((Object)key);
        return object != null && (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) != null && (object = JsonElementKt.getContentOrNull((JsonPrimitive)object)) != null ? StringsKt.toDoubleOrNull((String)object) : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Map<String, Object> getMutableMap(@NotNull JsonObject $this$getMutableMap, @NotNull String key) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)$this$getMutableMap, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        JsonElement jsonElement = (JsonElement)$this$getMutableMap.get((Object)key);
        if (jsonElement != null && (jsonElement = JsonElementKt.getJsonObject((JsonElement)jsonElement)) != null) {
            void $this$mapValuesTo$iv$iv;
            Map $this$mapValues$iv = (Map)jsonElement;
            boolean $i$f$mapValues = false;
            Map map2 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                Object object;
                void entry;
                void it$iv$iv;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map4 = map3;
                boolean bl2 = false;
                JsonElement value = (JsonElement)entry.getValue();
                if (value instanceof JsonObject) {
                    object = MapsKt.toMutableMap((Map)((Map)value));
                } else {
                    object = JsonElementKt.getContentOrNull((JsonPrimitive)JsonElementKt.getJsonPrimitive((JsonElement)value));
                    if (object == null) {
                        object = value;
                    }
                }
                Object object2 = object;
                map4.put(k, object2);
            }
            map = MapsKt.toMutableMap((Map)destination$iv$iv);
        } else {
            map = null;
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<Object> getArray(@NotNull JsonObject $this$getArray, @NotNull String key) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$getArray, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        JsonElement jsonElement = (JsonElement)$this$getArray.get((Object)key);
        if (jsonElement != null && (jsonElement = JsonElementKt.getJsonArray((JsonElement)jsonElement)) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)jsonElement;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Object object;
                void element;
                JsonElement jsonElement2 = (JsonElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (element instanceof JsonObject) {
                    object = MapsKt.toMutableMap((Map)((Map)element));
                } else {
                    object = JsonElementKt.getContentOrNull((JsonPrimitive)JsonElementKt.getJsonPrimitive((JsonElement)element));
                    if (object == null) {
                        object = element;
                    }
                }
                collection.add(object);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    private static final Unit jsonParser$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }

    private static final void sendGetRequest$lambda$2(String $urlString, HttpRequestHandle $handle) {
        try {
            HttpURLConnection httpURLConnection;
            URL url = new URI($urlString).toURL();
            URLConnection uRLConnection = url.openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection $this$sendGetRequest_u24lambda_u242_u24lambda_u241 = httpURLConnection = (HttpURLConnection)uRLConnection;
            boolean bl = false;
            $this$sendGetRequest_u24lambda_u242_u24lambda_u241.setRequestMethod("GET");
            $this$sendGetRequest_u24lambda_u242_u24lambda_u241.setConnectTimeout(10000);
            $this$sendGetRequest_u24lambda_u242_u24lambda_u241.setReadTimeout(10000);
            $this$sendGetRequest_u24lambda_u242_u24lambda_u241.setRequestProperty("User-Agent", USER_AGENT);
            HttpURLConnection connection = httpURLConnection;
            INSTANCE.handleConnection(connection, $handle);
        }
        catch (Exception e) {
            $handle.fail(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void sendPostRequest$lambda$5(String $urlString, HttpRequestHandle $handle, String $jsonBody) {
        try {
            URL url = new URI($urlString).toURL();
            URLConnection uRLConnection = url.openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            Object object = (HttpURLConnection)uRLConnection;
            HttpURLConnection $this$sendPostRequest_u24lambda_u245_u24lambda_u243 = object;
            boolean $i$a$-apply-Http$sendPostRequest$1$connection$22 = false;
            $this$sendPostRequest_u24lambda_u245_u24lambda_u243.setRequestMethod("POST");
            $this$sendPostRequest_u24lambda_u245_u24lambda_u243.setConnectTimeout(10000);
            $this$sendPostRequest_u24lambda_u245_u24lambda_u243.setReadTimeout(10000);
            $this$sendPostRequest_u24lambda_u245_u24lambda_u243.setDoOutput(true);
            $this$sendPostRequest_u24lambda_u245_u24lambda_u243.setRequestProperty("Content-Type", "application/json; utf-8");
            $this$sendPostRequest_u24lambda_u245_u24lambda_u243.setRequestProperty("Accept", "application/json");
            $this$sendPostRequest_u24lambda_u245_u24lambda_u243.setRequestProperty("User-Agent", USER_AGENT);
            HttpURLConnection connection = object;
            OutputStream outputStream = connection.getOutputStream();
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
            object = outputStream;
            Object object2 = Charsets.UTF_8;
            Writer $i$a$-apply-Http$sendPostRequest$1$connection$22 = new OutputStreamWriter((OutputStream)object, (Charset)object2);
            int n = 8192;
            object = $i$a$-apply-Http$sendPostRequest$1$connection$22 instanceof BufferedWriter ? (BufferedWriter)$i$a$-apply-Http$sendPostRequest$1$connection$22 : new BufferedWriter($i$a$-apply-Http$sendPostRequest$1$connection$22, n);
            object2 = null;
            try {
                BufferedWriter it = (BufferedWriter)object;
                boolean bl = false;
                it.write($jsonBody);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            INSTANCE.handleConnection(connection, $handle);
        }
        catch (Exception e) {
            $handle.fail(e);
        }
    }
}

