/*
 * Decompiled with CFR 0.152.
 */
package net.sbo.mod.utils.overlay;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.sbo.mod.SBOKotlin;
import net.sbo.mod.utils.Helper;
import net.sbo.mod.utils.data.OverlayValues;
import net.sbo.mod.utils.data.SboDataObject;
import net.sbo.mod.utils.game.World;
import net.sbo.mod.utils.overlay.OverlayManager;
import net.sbo.mod.utils.overlay.OverlayTextLine;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010!\n\u0002\b\n\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001b\u0010\u0012\u001a\u00020\u00002\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001d\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001b\u0010\u001d\u001a\u00020\f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\b\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001b\u0010\u001f\u001a\u00020\f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\b\u00a2\u0006\u0004\b\u001f\u0010\u001eJ\u0015\u0010 \u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b \u0010\u0017J\r\u0010!\u001a\u00020\f\u00a2\u0006\u0004\b!\u0010\u000eJ\u001d\u0010%\u001a\u00020\f2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\"\u00a2\u0006\u0004\b%\u0010&J\r\u0010'\u001a\u00020\u0018\u00a2\u0006\u0004\b'\u0010(J\r\u0010)\u001a\u00020\u0018\u00a2\u0006\u0004\b)\u0010(J\u001d\u0010*\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\"\u00a2\u0006\u0004\b*\u0010+J%\u0010.\u001a\u00020\f2\u0006\u0010-\u001a\u00020,2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\"\u00a2\u0006\u0004\b.\u0010/J7\u00102\u001a\u00020\f2\u0006\u0010-\u001a\u00020,2\u0006\u0010\u0005\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00182\u0006\u00100\u001a\u00020\u00182\u0006\u00101\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b2\u00103R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u00104\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u00109\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\"\u0010\u0006\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0006\u00109\u001a\u0004\b>\u0010;\"\u0004\b?\u0010=R\"\u0010\u0007\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u00109\u001a\u0004\b@\u0010;\"\u0004\bA\u0010=R(\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010B\u001a\u0004\bC\u0010D\"\u0004\bE\u0010\u001eR\u001c\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00140F8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bG\u0010BR\u0016\u0010H\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bH\u0010IR\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010JR\"\u0010K\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bK\u0010I\u001a\u0004\bL\u0010M\"\u0004\bN\u0010O\u00a8\u0006P"}, d2={"Lnet/sbo/mod/utils/overlay/Overlay;", "", "", "name", "", "x", "y", "scale", "", "allowedGuis", "<init>", "(Ljava/lang/String;FFFLjava/util/List;)V", "", "init", "()V", "Lkotlin/Function0;", "", "condition", "setCondition", "(Lkotlin/jvm/functions/Function0;)Lnet/sbo/mod/utils/overlay/Overlay;", "Lnet/sbo/mod/utils/overlay/OverlayTextLine;", "line", "addLine", "(Lnet/sbo/mod/utils/overlay/OverlayTextLine;)V", "", "index", "addLineAt", "(ILnet/sbo/mod/utils/overlay/OverlayTextLine;)V", "newLines", "addLines", "(Ljava/util/List;)V", "setLines", "removeLine", "clearLines", "", "mouseX", "mouseY", "overlayClicked", "(DD)V", "getTotalHeight", "()I", "getTotalWidth", "isOverOverlay", "(DD)Z", "Lnet/minecraft/class_332;", "drawContext", "render", "(Lnet/minecraft/class_332;DD)V", "width", "height", "drawDebugBox", "(Lnet/minecraft/class_332;IIII)V", "Ljava/lang/String;", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "F", "getX", "()F", "setX", "(F)V", "getY", "setY", "getScale", "setScale", "Ljava/util/List;", "getAllowedGuis", "()Ljava/util/List;", "setAllowedGuis", "", "lines", "renderGui", "Z", "Lkotlin/jvm/functions/Function0;", "selected", "getSelected", "()Z", "setSelected", "(Z)V", "sbo"})
public final class Overlay {
    @NotNull
    private String name;
    private float x;
    private float y;
    private float scale;
    @NotNull
    private List<String> allowedGuis;
    @NotNull
    private List<OverlayTextLine> lines;
    private boolean renderGui;
    @NotNull
    private Function0<Boolean> condition;
    private boolean selected;

    public Overlay(@NotNull String name, float x, float y, float scale, @NotNull List<String> allowedGuis) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(allowedGuis, (String)"allowedGuis");
        this.name = name;
        this.x = x;
        this.y = y;
        this.scale = scale;
        this.allowedGuis = allowedGuis;
        this.lines = new ArrayList();
        this.renderGui = true;
        this.condition = Overlay::condition$lambda$0;
    }

    public /* synthetic */ Overlay(String string, float f, float f2, float f3, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            f3 = 1.0f;
        }
        if ((n & 0x10) != 0) {
            list = CollectionsKt.listOf((Object)"Chat screen");
        }
        this(string, f, f2, f3, list);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    public final float getX() {
        return this.x;
    }

    public final void setX(float f) {
        this.x = f;
    }

    public final float getY() {
        return this.y;
    }

    public final void setY(float f) {
        this.y = f;
    }

    public final float getScale() {
        return this.scale;
    }

    public final void setScale(float f) {
        this.scale = f;
    }

    @NotNull
    public final List<String> getAllowedGuis() {
        return this.allowedGuis;
    }

    public final void setAllowedGuis(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.allowedGuis = list;
    }

    public final boolean getSelected() {
        return this.selected;
    }

    public final void setSelected(boolean bl) {
        this.selected = bl;
    }

    public final void init() {
        if (SboDataObject.overlayData.getOverlays().containsKey(this.name)) {
            OverlayValues overlayValues = SboDataObject.overlayData.getOverlays().get(this.name);
            Intrinsics.checkNotNull((Object)overlayValues);
            OverlayValues data = overlayValues;
            this.x = data.getX();
            this.y = data.getY();
            this.scale = data.getScale();
        } else {
            SboDataObject.overlayData.getOverlays().put(this.name, new OverlayValues(this.x, this.y, this.scale));
        }
        OverlayManager.INSTANCE.getOverlays().add(this);
    }

    @NotNull
    public final Overlay setCondition(@NotNull Function0<Boolean> condition) {
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        this.condition = condition;
        return this;
    }

    public final void addLine(@NotNull OverlayTextLine line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        this.lines.add(line);
    }

    public final void addLineAt(int index, @NotNull OverlayTextLine line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        this.lines.add(index, line);
    }

    public final void addLines(@NotNull List<OverlayTextLine> newLines) {
        Intrinsics.checkNotNullParameter(newLines, (String)"newLines");
        this.lines.addAll((Collection<OverlayTextLine>)newLines);
    }

    public final void setLines(@NotNull List<OverlayTextLine> newLines) {
        Intrinsics.checkNotNullParameter(newLines, (String)"newLines");
        this.lines = CollectionsKt.toMutableList((Collection)newLines);
    }

    public final void removeLine(@NotNull OverlayTextLine line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        this.lines.remove(line);
    }

    public final void clearLines() {
        this.lines = new ArrayList();
    }

    public final void overlayClicked(double mouseX, double mouseY) {
        if (!World.INSTANCE.isInSkyblock()) {
            return;
        }
        if (!this.renderGui) {
            return;
        }
        if (!((Boolean)this.condition.invoke()).booleanValue()) {
            return;
        }
        if (!this.allowedGuis.contains(Helper.INSTANCE.getGuiName())) {
            return;
        }
        class_327 class_3272 = SBOKotlin.mc.field_1772;
        if (class_3272 == null) {
            return;
        }
        class_327 textRenderer = class_3272;
        if (!this.isOverOverlay(mouseX, mouseY)) {
            return;
        }
        float currentY = this.y / this.scale;
        float currentX = this.x / this.scale;
        for (OverlayTextLine line : this.lines) {
            line.lineClicked(mouseX, mouseY, currentX * this.scale, currentY * this.scale, textRenderer, this.scale);
            if (line.getLinebreak()) {
                currentY += (float)(textRenderer.field_2000 + 1);
                currentX = this.x / this.scale;
                continue;
            }
            currentX += (float)textRenderer.method_1727(line.getText()) / this.scale;
        }
    }

    public final int getTotalHeight() {
        class_327 class_3272 = SBOKotlin.mc.field_1772;
        if (class_3272 == null) {
            return 0;
        }
        class_327 textRenderer = class_3272;
        int totalHeight = 0;
        for (OverlayTextLine line : this.lines) {
            if (!line.getLinebreak()) continue;
            totalHeight += textRenderer.field_2000 + 1;
        }
        if (!((Collection)this.lines).isEmpty()) {
            totalHeight += textRenderer.field_2000 + 1;
        }
        return totalHeight;
    }

    public final int getTotalWidth() {
        class_327 class_3272 = SBOKotlin.mc.field_1772;
        if (class_3272 == null) {
            return 0;
        }
        class_327 textRenderer = class_3272;
        int maxWidth = 0;
        int currentWidth = 0;
        for (OverlayTextLine line : this.lines) {
            currentWidth += textRenderer.method_1727(line.getText());
            if (!line.getLinebreak()) continue;
            if (currentWidth > maxWidth) {
                maxWidth = currentWidth;
            }
            currentWidth = 0;
        }
        if (currentWidth > maxWidth) {
            maxWidth = currentWidth;
        }
        return maxWidth;
    }

    public final boolean isOverOverlay(double mouseX, double mouseY) {
        float totalWidth = (float)this.getTotalWidth() * this.scale;
        float totalHeight = (float)this.getTotalHeight() * this.scale;
        return mouseX >= (double)this.x && mouseX <= (double)(this.x + totalWidth) && mouseY >= (double)this.y && mouseY <= (double)(this.y + totalHeight);
    }

    public final void render(@NotNull class_332 drawContext, double mouseX, double mouseY) {
        Intrinsics.checkNotNullParameter((Object)drawContext, (String)"drawContext");
        if (!this.renderGui) {
            return;
        }
        if (!((Boolean)this.condition.invoke()).booleanValue()) {
            return;
        }
        class_327 class_3272 = SBOKotlin.mc.field_1772;
        if (class_3272 == null) {
            return;
        }
        class_327 textRenderer = class_3272;
        drawContext.method_51448().method_22903();
        drawContext.method_51448().method_22905(this.scale, this.scale, 1.0f);
        float currentY = this.y / this.scale;
        float currentX = this.x / this.scale;
        int totalWidth = this.getTotalWidth();
        int totalHeight = this.getTotalHeight();
        if (this.selected) {
            this.drawDebugBox(drawContext, (int)currentX, (int)currentY, totalWidth, totalHeight);
            int n = (int)this.x;
            int n2 = (int)this.y;
            String string = "%.1f";
            Object[] objectArray = new Object[]{Float.valueOf(this.scale)};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            drawContext.method_51433(textRenderer, "X: " + n + " Y: " + n2 + " Scale: " + string2, (int)currentX, (int)(currentY - (float)textRenderer.field_2000 - 1.0f), new Color(255, 255, 255, 200).getRGB(), true);
        }
        for (OverlayTextLine line : this.lines) {
            if (!line.checkCondition()) continue;
            if (this.allowedGuis.contains(Helper.INSTANCE.getGuiName())) {
                line.updateMouseInteraction(mouseX, mouseY, currentX * this.scale, currentY * this.scale, textRenderer, this.scale, drawContext);
            }
            line.draw(drawContext, (int)currentX, (int)currentY, textRenderer);
            if (line.getLinebreak()) {
                currentY += (float)(textRenderer.field_2000 + 1);
                currentX = this.x / this.scale;
                continue;
            }
            currentX += (float)textRenderer.method_1727(line.getText());
        }
        drawContext.method_51448().method_22909();
    }

    private final void drawDebugBox(class_332 drawContext, int x, int y, int width, int height) {
        drawContext.method_49601(x, y, width, height, new Color(255, 0, 0, 170).getRGB());
    }

    private static final boolean condition$lambda$0() {
        return true;
    }
}

