/*
 * Decompiled with CFR 0.152.
 */
package net.sbo.mod.diana.sphinx;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_408;
import net.sbo.mod.diana.sphinx.SphinxQuestions;
import net.sbo.mod.diana.sphinx.SphinxSession;
import net.sbo.mod.settings.categories.Diana;
import net.sbo.mod.utils.Helper;
import net.sbo.mod.utils.chat.Chat;
import net.sbo.mod.utils.chat.ChatUtils;
import net.sbo.mod.utils.events.Register;
import net.sbo.mod.utils.events.impl.guis.GuiMouseClickBefore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0015\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\n\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u0003J\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001b\u0010\u0017\u001a\u00020\u0014*\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lnet/sbo/mod/diana/sphinx/SphinxSolver;", "", "<init>", "()V", "", "init", "Lnet/sbo/mod/utils/events/impl/guis/GuiMouseClickBefore;", "event", "onGuiMouseClick", "(Lnet/sbo/mod/utils/events/impl/guis/GuiMouseClickBefore;)V", "detectQuestion", "", "letter", "", "letterToIndex", "(Ljava/lang/String;)I", "Lnet/sbo/mod/diana/sphinx/SphinxSession;", "session", "handleSessionComplete", "(Lnet/sbo/mod/diana/sphinx/SphinxSession;)V", "Lnet/minecraft/class_2561;", "", "isCorrect", "createStyledAnswerText", "(Lnet/minecraft/class_2561;Z)Lnet/minecraft/class_2561;", "currentSession", "Lnet/sbo/mod/diana/sphinx/SphinxSession;", "SBO"})
@SourceDebugExtension(value={"SMAP\nSphinxSolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SphinxSolver.kt\nnet/sbo/mod/diana/sphinx/SphinxSolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1#2:104\n*E\n"})
public final class SphinxSolver {
    @NotNull
    public static final SphinxSolver INSTANCE = new SphinxSolver();
    @Nullable
    private static SphinxSession currentSession;

    private SphinxSolver() {
    }

    public final void init() {
        this.detectQuestion();
    }

    public final void onGuiMouseClick(@NotNull GuiMouseClickBefore event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Diana.INSTANCE.getSphinxSolver()) {
            return;
        }
        SphinxSession sphinxSession = currentSession;
        if (sphinxSession == null) {
            return;
        }
        int index = sphinxSession.getCorrectAnswersIndex();
        if (event.getButton() != 0) {
            return;
        }
        if (index == -1) {
            return;
        }
        if (!(event.getScreen() instanceof class_408)) {
            return;
        }
        Chat.INSTANCE.command("/sphinxanswer " + index);
        currentSession = null;
    }

    public final void detectQuestion() {
        Pattern pattern = Pattern.compile("^(.*?)$", 32);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        Register.INSTANCE.onChatMessageCancable(pattern, (Function2<? super class_2561, ? super Matcher, Boolean>)((Function2)SphinxSolver::detectQuestion$lambda$1));
        Pattern pattern2 = Pattern.compile("^\u00a77 {3}([ABC])\\) \u00a7f(.*?)$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        Register.INSTANCE.onChatMessageCancable(pattern2, (Function2<? super class_2561, ? super Matcher, Boolean>)((Function2)SphinxSolver::detectQuestion$lambda$3));
    }

    private final int letterToIndex(String letter) {
        return switch (letter) {
            case "A" -> 0;
            case "B" -> 1;
            case "C" -> 2;
            default -> -1;
        };
    }

    private final void handleSessionComplete(SphinxSession session) {
        if (session.getCorrectAnswersIndex() == -1) {
            return;
        }
        for (class_2561 msg : session.getAnswerTexts().values()) {
            class_2561 clickableText = ChatUtils.INSTANCE.toClickableText$SBO(msg, "/sphinxanswer " + session.getCorrectAnswersIndex());
            Chat.INSTANCE.chat(clickableText);
        }
    }

    private final class_2561 createStyledAnswerText(class_2561 $this$createStyledAnswerText, boolean isCorrect) {
        String newColorCode = isCorrect ? "\u00a7a\u00a7n" : "\u00a7c";
        String newString = StringsKt.replace$default((String)ChatUtils.INSTANCE.formattedString($this$createStyledAnswerText), (String)"\u00a7f", (String)newColorCode, (boolean)false, (int)4, null);
        class_2568 originalHoverEvent = ChatUtils.INSTANCE.getShowTextHoverEvent$SBO($this$createStyledAnswerText);
        return ChatUtils.INSTANCE.toStyledText$SBO(newString, null, originalHoverEvent);
    }

    private static final Unit detectQuestion$lambda$1$lambda$0() {
        Chat.INSTANCE.chat("\u00a76[SBO] \u00a7bClick anywhere on the screen to answer while the chat is open.");
        return Unit.INSTANCE;
    }

    private static final boolean detectQuestion$lambda$1(class_2561 message, Matcher matchResult) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
        if (!Diana.INSTANCE.getSphinxSolver()) {
            return true;
        }
        String string = matchResult.group(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
        String questionText = ((Object)StringsKt.trim((CharSequence)string)).toString();
        for (SphinxQuestions.SphinxQuestion sphinxQuestion : SphinxQuestions.INSTANCE.getQUESTIONS()) {
            if (!StringsKt.equals((String)sphinxQuestion.getQuestion(), (String)Helper.INSTANCE.removeFormatting(questionText), (boolean)true)) continue;
            Helper.INSTANCE.sleep(100L, (Function0<Unit>)((Function0)SphinxSolver::detectQuestion$lambda$1$lambda$0));
        }
        return true;
    }

    private static final boolean detectQuestion$lambda$3(class_2561 msg, Matcher matcher) {
        SphinxSession session;
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        if (!Diana.INSTANCE.getSphinxSolver()) {
            return true;
        }
        String letter = matcher.group(1);
        String string = matcher.group(2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
        String possibleAnswer = ((Object)StringsKt.trim((CharSequence)string)).toString();
        Intrinsics.checkNotNull((Object)letter);
        int index = INSTANCE.letterToIndex(letter);
        boolean isCorrect = SphinxQuestions.INSTANCE.getCORRECT_ANSWERS().contains(possibleAnswer);
        SphinxSession sphinxSession = currentSession;
        if (sphinxSession == null) {
            SphinxSession sphinxSession2;
            SphinxSession it = sphinxSession2 = new SphinxSession(0, null, 0, 7, null);
            boolean bl = false;
            currentSession = it;
            sphinxSession = session = sphinxSession2;
        }
        if (isCorrect) {
            session.setCorrectAnswersIndex(index);
        }
        class_2561 formattedMsg = INSTANCE.createStyledAnswerText(msg, isCorrect);
        session.getAnswerTexts().put(letter, formattedMsg);
        if (session.isComplete()) {
            INSTANCE.handleSessionComplete(session);
        }
        return false;
    }
}

