/*
 * Decompiled with CFR 0.152.
 */
package net.sbo.mod.utils.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KMutableProperty1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import net.fabricmc.loader.api.FabricLoader;
import net.sbo.mod.SBOKotlin;
import net.sbo.mod.utils.data.AchievementsData;
import net.sbo.mod.utils.data.DianaFilters;
import net.sbo.mod.utils.data.DianaInputs;
import net.sbo.mod.utils.data.DianaTracker;
import net.sbo.mod.utils.data.DianaTrackerMayorData;
import net.sbo.mod.utils.data.DianaTrackerSessionData;
import net.sbo.mod.utils.data.DianaTrackerTotalData;
import net.sbo.mod.utils.data.Filters;
import net.sbo.mod.utils.data.OverlayData;
import net.sbo.mod.utils.data.PartyFinderConfigState;
import net.sbo.mod.utils.data.PartyFinderData;
import net.sbo.mod.utils.data.PastDianaEventsData;
import net.sbo.mod.utils.data.SboConfigBundle;
import net.sbo.mod.utils.data.SboData;
import net.sbo.mod.utils.events.Register;
import net.sbo.mod.utils.events.impl.game.GameCloseEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0015\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ9\u0010\u0011\u001a\u00028\u0000\"\u0004\b\u0000\u0010\n2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00028\u00002\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J/\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0016H\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019J/\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000bH\u0000\u00a2\u0006\u0004\b\u0018\u0010\u001bJ\u0017\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010 \u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b \u0010!J\u001f\u0010%\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010'\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b'\u0010(J-\u0010+\u001a\u00020\u0004\"\u0004\b\u0000\u0010\n2\u0006\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b+\u0010,J\u000f\u0010-\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b-\u0010\u0003J\u0015\u0010.\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b.\u0010(J\u0015\u0010/\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b/\u0010(J\u0015\u00102\u001a\u00020\u00042\u0006\u00101\u001a\u000200\u00a2\u0006\u0004\b2\u00103J+\u00104\u001a\u00020\u0004\"\u0004\b\u0000\u0010\n2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010*\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u000b\u00a2\u0006\u0004\b4\u00105J\u0015\u00104\u001a\u00020\u00042\u0006\u00106\u001a\u00020\u000b\u00a2\u0006\u0004\b4\u0010(J\r\u00107\u001a\u00020\u0004\u00a2\u0006\u0004\b7\u0010\u0003R\u0016\u00109\u001a\u0002088\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b9\u0010:R\u0016\u0010;\u001a\u00020\u001c8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b;\u0010<R\u0016\u0010>\u001a\u00020=8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b>\u0010?R\u0016\u0010A\u001a\u00020@8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\bA\u0010BR\u0016\u0010D\u001a\u00020C8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\bD\u0010ER\u0016\u0010G\u001a\u00020F8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\bG\u0010HR\u0016\u0010J\u001a\u00020I8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\bJ\u0010KR\u0016\u0010M\u001a\u00020L8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\bM\u0010NR\u0016\u0010P\u001a\u00020O8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\bP\u0010QR\"\u0010R\u001a\u00020\u001f8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\bR\u0010S\u001a\u0004\bT\u0010U\"\u0004\bV\u0010WR\u0014\u0010Y\u001a\u00020X8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bY\u0010ZR\u0014\u0010[\u001a\u0002008\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b[\u0010\\R\u0014\u0010^\u001a\u00020]8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b^\u0010_R5\u0010c\u001a \u0012\u0004\u0012\u00020\u000b\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040b\u0012\u0004\u0012\u00020\u00010a0`8\u0006\u00a2\u0006\f\n\u0004\bc\u0010d\u001a\u0004\be\u0010f\u00a8\u0006g"}, d2={"Lnet/sbo/mod/utils/data/SboDataObject;", "", "<init>", "()V", "", "init", "Lnet/sbo/mod/utils/events/impl/game/GameCloseEvent;", "event", "onGameClose", "(Lnet/sbo/mod/utils/events/impl/game/GameCloseEvent;)V", "T", "", "modName", "fileName", "defaultData", "Ljava/lang/Class;", "type", "load", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;", "category", "list", "key", "", "value", "updatePfConfigState$SBO", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "updatePfConfigState", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "Lnet/sbo/mod/utils/data/AchievementsData;", "loadAchievementsData", "(Ljava/lang/String;)Lnet/sbo/mod/utils/data/AchievementsData;", "Lnet/sbo/mod/utils/data/SboConfigBundle;", "loadAllData", "(Ljava/lang/String;)Lnet/sbo/mod/utils/data/SboConfigBundle;", "Ljava/io/File;", "folderToZip", "zipFilePath", "zipFolder", "(Ljava/io/File;Ljava/io/File;)V", "createBackup", "(Ljava/lang/String;)V", "folder", "data", "saveToFolder", "(Ljava/io/File;Ljava/lang/Object;Ljava/lang/String;)V", "saveAllData", "saveAllDataThreaded", "saveAndBackupAllDataThreaded", "", "interval", "savePeriodically", "(I)V", "save", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;)V", "configName", "saveTrackerData", "Lnet/sbo/mod/utils/data/SboData;", "sboData", "Lnet/sbo/mod/utils/data/SboData;", "achievementsData", "Lnet/sbo/mod/utils/data/AchievementsData;", "Lnet/sbo/mod/utils/data/PastDianaEventsData;", "pastDianaEventsData", "Lnet/sbo/mod/utils/data/PastDianaEventsData;", "Lnet/sbo/mod/utils/data/DianaTrackerTotalData;", "dianaTrackerTotal", "Lnet/sbo/mod/utils/data/DianaTrackerTotalData;", "Lnet/sbo/mod/utils/data/DianaTrackerSessionData;", "dianaTrackerSession", "Lnet/sbo/mod/utils/data/DianaTrackerSessionData;", "Lnet/sbo/mod/utils/data/DianaTrackerMayorData;", "dianaTrackerMayor", "Lnet/sbo/mod/utils/data/DianaTrackerMayorData;", "Lnet/sbo/mod/utils/data/PartyFinderConfigState;", "pfConfigState", "Lnet/sbo/mod/utils/data/PartyFinderConfigState;", "Lnet/sbo/mod/utils/data/PartyFinderData;", "partyFinderData", "Lnet/sbo/mod/utils/data/PartyFinderData;", "Lnet/sbo/mod/utils/data/OverlayData;", "overlayData", "Lnet/sbo/mod/utils/data/OverlayData;", "SBOConfigBundle", "Lnet/sbo/mod/utils/data/SboConfigBundle;", "getSBOConfigBundle", "()Lnet/sbo/mod/utils/data/SboConfigBundle;", "setSBOConfigBundle", "(Lnet/sbo/mod/utils/data/SboConfigBundle;)V", "Lcom/google/gson/Gson;", "gson", "Lcom/google/gson/Gson;", "MAX_BACKUPS", "I", "Ljava/util/concurrent/ExecutorService;", "DATA_SAVER_EXECUTOR", "Ljava/util/concurrent/ExecutorService;", "", "Lkotlin/Pair;", "Lkotlin/Function0;", "configMapforSave", "Ljava/util/Map;", "getConfigMapforSave", "()Ljava/util/Map;", "SBO"})
@SourceDebugExtension(value={"SMAP\nSboDataObject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SboDataObject.kt\nnet/sbo/mod/utils/data/SboDataObject\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,433:1\n1#2:434\n808#3,11:435\n2423#3,14:448\n1321#4,2:446\n216#5,2:462\n*S KotlinDebug\n*F\n+ 1 SboDataObject.kt\nnet/sbo/mod/utils/data/SboDataObject\n*L\n259#1:435,11\n340#1:448,14\n298#1:446,2\n370#1:462,2\n*E\n"})
public final class SboDataObject {
    @NotNull
    public static final SboDataObject INSTANCE = new SboDataObject();
    @JvmField
    @NotNull
    public static SboData sboData = new SboData(null, null, null, false, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, null, null, null, 0L, 0L, 0L, 0L, false, false, false, false, false, null, null, 0, false, 0, false, 0, false, 0, false, 0, false, 0, false, 0, false, 0, false, 0, false, 0, false, 0, false, -1, 524287, null);
    @JvmField
    @NotNull
    public static AchievementsData achievementsData = new AchievementsData(null, 1, null);
    @JvmField
    @NotNull
    public static PastDianaEventsData pastDianaEventsData = new PastDianaEventsData(null, 1, null);
    @JvmField
    @NotNull
    public static DianaTrackerTotalData dianaTrackerTotal = new DianaTrackerTotalData(null, null, 3, null);
    @JvmField
    @NotNull
    public static DianaTrackerSessionData dianaTrackerSession = new DianaTrackerSessionData(null, null, 3, null);
    @JvmField
    @NotNull
    public static DianaTrackerMayorData dianaTrackerMayor = new DianaTrackerMayorData(0, null, null, 7, null);
    @JvmField
    @NotNull
    public static PartyFinderConfigState pfConfigState = new PartyFinderConfigState(null, null, null, 7, null);
    @JvmField
    @NotNull
    public static PartyFinderData partyFinderData = new PartyFinderData(0L, null, 3, null);
    @JvmField
    @NotNull
    public static OverlayData overlayData = new OverlayData(null, 1, null);
    public static SboConfigBundle SBOConfigBundle;
    @NotNull
    private static final Gson gson;
    private static final int MAX_BACKUPS = 10;
    @NotNull
    private static final ExecutorService DATA_SAVER_EXECUTOR;
    @NotNull
    private static final Map<String, Pair<Function0<Unit>, Object>> configMapforSave;

    private SboDataObject() {
    }

    @NotNull
    public final SboConfigBundle getSBOConfigBundle() {
        SboConfigBundle sboConfigBundle = SBOConfigBundle;
        if (sboConfigBundle != null) {
            return sboConfigBundle;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"SBOConfigBundle");
        return null;
    }

    public final void setSBOConfigBundle(@NotNull SboConfigBundle sboConfigBundle) {
        Intrinsics.checkNotNullParameter((Object)sboConfigBundle, (String)"<set-?>");
        SBOConfigBundle = sboConfigBundle;
    }

    public final void init() {
        this.setSBOConfigBundle(this.loadAllData("SBO"));
        sboData = this.getSBOConfigBundle().getSboData();
        achievementsData = this.getSBOConfigBundle().getAchievementsData();
        pastDianaEventsData = this.getSBOConfigBundle().getPastDianaEventsData();
        dianaTrackerTotal = this.getSBOConfigBundle().getDianaTrackerTotalData();
        dianaTrackerSession = this.getSBOConfigBundle().getDianaTrackerSessionData();
        dianaTrackerMayor = this.getSBOConfigBundle().getDianaTrackerMayorData();
        pfConfigState = this.getSBOConfigBundle().getPartyFinderConfigState();
        partyFinderData = this.getSBOConfigBundle().getPartyFinderData();
        overlayData = this.getSBOConfigBundle().getOverlayData();
        this.saveAllDataThreaded("SBO");
        this.savePeriodically(5);
    }

    public final void onGameClose(@NotNull GameCloseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.saveAndBackupAllDataThreaded("SBO");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T load(@NotNull String modName, @NotNull String fileName, T defaultData, @NotNull Class<T> type) {
        Object object;
        File dataFile;
        Intrinsics.checkNotNullParameter((Object)modName, (String)"modName");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        File modConfigDir = new File(FabricLoader.getInstance().getConfigDir().toFile(), modName);
        if (!modConfigDir.exists()) {
            modConfigDir.mkdirs();
        }
        if (!(dataFile = new File(modConfigDir, fileName)).exists()) {
            SBOKotlin.INSTANCE.getLogger$SBO().info("[" + modName + "] " + fileName + " not found. Creating with default data.");
            this.save(modName, defaultData, fileName);
            return defaultData;
        }
        try {
            JsonArray eventsArray;
            long oldTime;
            FileReader reader;
            Object reader2;
            Closeable closeable = new FileReader(dataFile);
            Object object2 = null;
            try {
                reader2 = (FileReader)closeable;
                boolean bl = false;
                reader2 = gson.fromJson((Reader)reader2, type);
            }
            catch (Throwable bl) {
                object2 = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
            }
            Object loadedData = reader2;
            object2 = new FileReader(dataFile);
            reader2 = null;
            try {
                reader = (FileReader)object2;
                boolean bl = false;
                reader = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            }
            catch (Throwable throwable) {
                reader2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)reader2);
            }
            FileReader jsonObject = reader;
            boolean dataModified = false;
            if (loadedData instanceof DianaTracker && jsonObject.has("items")) {
                JsonObject itemsObject = jsonObject.getAsJsonObject("items");
                JsonElement jsonElement = itemsObject.get("totalTime");
                long totalTime = jsonElement != null ? jsonElement.getAsLong() : 0L;
                JsonElement jsonElement2 = itemsObject.get("sessionTime");
                long sessionTime = jsonElement2 != null ? jsonElement2.getAsLong() : 0L;
                JsonElement jsonElement3 = itemsObject.get("mayorTime");
                long mayorTime = jsonElement3 != null ? jsonElement3.getAsLong() : 0L;
                oldTime = Math.max(totalTime, Math.max(sessionTime, mayorTime));
                if (oldTime > 0L) {
                    ((DianaTracker)loadedData).getItems().setTIME(oldTime);
                    dataModified = true;
                }
            }
            if (loadedData instanceof PastDianaEventsData && (eventsArray = jsonObject.getAsJsonArray("events")) != null) {
                Iterator iterator = ((Iterable)eventsArray).iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    int index = n++;
                    JsonElement element = (JsonElement)iterator.next();
                    JsonObject eventObject = element.getAsJsonObject();
                    if (!eventObject.has("items")) continue;
                    JsonObject itemsObject = eventObject.getAsJsonObject("items");
                    JsonElement jsonElement = itemsObject.get("mayorTime");
                    oldTime = jsonElement != null ? jsonElement.getAsLong() : 0L;
                    if (oldTime <= 0L) continue;
                    ((PastDianaEventsData)loadedData).getEvents().get(index).getItems().setTIME(oldTime);
                    dataModified = true;
                }
            }
            if (dataModified) {
                SBOKotlin.INSTANCE.getLogger$SBO().info("[" + modName + "] Old data format detected and migrated. Saving updated file.");
                this.save(modName, loadedData, fileName);
            }
            object = loadedData;
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            SBOKotlin.INSTANCE.getLogger$SBO().error("[" + modName + "] Error parsing JSON in " + fileName + ", resetting to default data.");
            this.save(modName, defaultData, fileName);
            object = defaultData;
        }
        catch (Exception e) {
            SBOKotlin.INSTANCE.getLogger$SBO().error("[" + modName + "] Error reading data file " + fileName + ", resetting to default data.", (Throwable)e);
            e.printStackTrace();
            this.save(modName, defaultData, fileName);
            object = defaultData;
        }
        return object;
    }

    public final void updatePfConfigState$SBO(@NotNull String category, @NotNull String list, @NotNull String key, boolean value) {
        Filters categoryInstance;
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = category;
        Filters filters = Intrinsics.areEqual((Object)string, (Object)"filters") ? pfConfigState.getFilters() : (categoryInstance = Intrinsics.areEqual((Object)string, (Object)"checkboxes") ? pfConfigState.getCheckboxes() : null);
        if (categoryInstance != null) {
            DianaFilters listInstance;
            String string2 = list;
            Object object = Intrinsics.areEqual((Object)string2, (Object)"diana") ? (Intrinsics.areEqual((Object)category, (Object)"filters") ? pfConfigState.getFilters().getDiana() : pfConfigState.getCheckboxes().getDiana()) : (Intrinsics.areEqual((Object)string2, (Object)"custom") ? (Intrinsics.areEqual((Object)category, (Object)"filters") ? pfConfigState.getFilters().getCustom() : pfConfigState.getCheckboxes().getCustom()) : (listInstance = null));
            if (listInstance != null) {
                Object v2;
                block5: {
                    Iterable iterable = Reflection.getOrCreateKotlinClass(listInstance.getClass()).getMembers();
                    for (Object t : iterable) {
                        KCallable it = (KCallable)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)key)) continue;
                        v2 = t;
                        break block5;
                    }
                    v2 = null;
                }
                KCallable property = v2;
                if (property instanceof KMutableProperty1) {
                    Object[] objectArray = new Object[]{listInstance};
                    if (!Intrinsics.areEqual((Object)((KMutableProperty1)property).getGetter().call(objectArray), (Object)value)) {
                        objectArray = new Object[]{listInstance, value};
                        ((KMutableProperty1)property).getSetter().call(objectArray);
                        this.save("PartyFinderConfigState");
                    }
                }
            }
        }
    }

    public final void updatePfConfigState$SBO(@NotNull String category, @NotNull String list, @NotNull String key, @NotNull String value) {
        DianaInputs listInstance;
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!Intrinsics.areEqual((Object)category, (Object)"inputs")) {
            return;
        }
        String string = list;
        DianaInputs dianaInputs = Intrinsics.areEqual((Object)string, (Object)"diana") ? pfConfigState.getInputs().getDiana() : (listInstance = Intrinsics.areEqual((Object)string, (Object)"custom") ? pfConfigState.getInputs().getCustom() : null);
        if (listInstance != null) {
            Object v1;
            block11: {
                Iterable iterable = Reflection.getOrCreateKotlinClass(listInstance.getClass()).getMembers();
                for (Object t : iterable) {
                    KCallable it = (KCallable)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)key)) continue;
                    v1 = t;
                    break block11;
                }
                v1 = null;
            }
            KCallable property = v1;
            if (property instanceof KMutableProperty1) {
                Integer convertedValue;
                KMutableProperty1 prop = (KMutableProperty1)property;
                KClassifier kClassifier = prop.getReturnType().getClassifier();
                if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                    v2 = StringsKt.toIntOrNull((String)value);
                } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                    v2 = value;
                } else {
                    SBOKotlin.INSTANCE.getLogger$SBO().warn("[" + key + "] hasn an Unsupported type: " + prop.getReturnType().getClassifier());
                    v2 = convertedValue = null;
                }
                if (convertedValue != null) {
                    Object currentValue = prop.get((Object)listInstance);
                    if (!Intrinsics.areEqual((Object)currentValue, (Object)convertedValue)) {
                        prop.set((Object)listInstance, (Object)convertedValue);
                        this.save("PartyFinderConfigState");
                    }
                } else {
                    SBOKotlin.INSTANCE.getLogger$SBO().warn("Failed to convert '" + value + "' to type " + prop.getReturnType().getClassifier() + " for key '" + key + "'");
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final AchievementsData loadAchievementsData(String modName) {
        AchievementsData achievementsData;
        File modConfigDir = new File(FabricLoader.getInstance().getConfigDir().toFile(), modName);
        File dataFile = new File(modConfigDir, "sbo_achievements.json");
        AchievementsData defaultData = new AchievementsData(null, 1, null);
        if (!dataFile.exists()) {
            SBOKotlin.INSTANCE.getLogger$SBO().info("[" + modName + "] sbo_achievements.json not found. Creating with default data.");
            this.save(modName, defaultData, "sbo_achievements.json");
            return defaultData;
        }
        try {
            AchievementsData achievementsData2;
            List list;
            Type typeToken2 = new TypeToken<Map<String, ? extends Object>>(){}.getType();
            Object object = gson.fromJson((Reader)new FileReader(dataFile), typeToken2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
            Map oldFormatData = (Map)object;
            Set combinedUnlockedIds = new LinkedHashSet();
            Map achievementMap = new LinkedHashMap();
            boolean isOldFormat = false;
            for (Map.Entry entry : oldFormatData.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (Intrinsics.areEqual((Object)key, (Object)"unlocked") || !(value instanceof Boolean)) continue;
                achievementMap.put(Integer.parseInt(key), value);
                Integer n = StringsKt.toIntOrNull((String)key);
                if (n != null) {
                    int it = ((Number)n).intValue();
                    boolean bl = false;
                    combinedUnlockedIds.add(it);
                }
                isOldFormat = true;
            }
            Object v = oldFormatData.get("unlocked");
            List list2 = v instanceof List ? (List)v : null;
            if (list2 != null) {
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = list2;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof Integer)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            List existingUnlockedList = list;
            combinedUnlockedIds.addAll(existingUnlockedList);
            if (isOldFormat) {
                SBOKotlin.INSTANCE.getLogger$SBO().info("[" + modName + "] Old achievements file format detected. Migrating to new format.");
                AchievementsData newAchievementsData = new AchievementsData(achievementMap);
                this.save(modName, newAchievementsData, "sbo_achievements.json");
                SBOKotlin.INSTANCE.getLogger$SBO().info("[" + modName + "] Achievements data migrated successfully.");
                achievementsData2 = newAchievementsData;
            } else {
                achievementsData2 = this.load(modName, "sbo_achievements.json", defaultData, AchievementsData.class);
            }
            achievementsData = achievementsData2;
        }
        catch (Exception e) {
            SBOKotlin.INSTANCE.getLogger$SBO().error("[" + modName + "] Error reading sbo_achievements.json, resetting to default data.", (Throwable)e);
            this.save(modName, defaultData, "sbo_achievements.json");
            achievementsData = defaultData;
        }
        return achievementsData;
    }

    @NotNull
    public final SboConfigBundle loadAllData(@NotNull String modName) {
        Intrinsics.checkNotNullParameter((Object)modName, (String)"modName");
        SboData sboData = this.load(modName, "SboData.json", new SboData(null, null, null, false, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, null, null, null, 0L, 0L, 0L, 0L, false, false, false, false, false, null, null, 0, false, 0, false, 0, false, 0, false, 0, false, 0, false, 0, false, 0, false, 0, false, 0, false, 0, false, -1, 524287, null), SboData.class);
        AchievementsData achievementsData = this.loadAchievementsData(modName);
        PastDianaEventsData pastDianaEventsData = this.load(modName, "pastDianaEvents.json", new PastDianaEventsData(null, 1, null), PastDianaEventsData.class);
        DianaTrackerTotalData dianaTrackerTotalData = this.load(modName, "dianaTrackerTotal.json", new DianaTrackerTotalData(null, null, 3, null), DianaTrackerTotalData.class);
        DianaTrackerSessionData dianaTrackerSessionData = this.load(modName, "dianaTrackerSession.json", new DianaTrackerSessionData(null, null, 3, null), DianaTrackerSessionData.class);
        DianaTrackerMayorData dianaTrackerMayorData = this.load(modName, "dianaTrackerMayor.json", new DianaTrackerMayorData(0, null, null, 7, null), DianaTrackerMayorData.class);
        PartyFinderConfigState partyFinderConfigState = this.load(modName, "partyFinderConfigState.json", new PartyFinderConfigState(null, null, null, 7, null), PartyFinderConfigState.class);
        PartyFinderData partyFinderData = this.load(modName, "partyFinderData.json", new PartyFinderData(0L, null, 3, null), PartyFinderData.class);
        OverlayData overlayData = this.load(modName, "overlayData.json", new OverlayData(null, 1, null), OverlayData.class);
        return new SboConfigBundle(sboData, achievementsData, pastDianaEventsData, dianaTrackerTotalData, dianaTrackerSessionData, dianaTrackerMayorData, partyFinderConfigState, partyFinderData, overlayData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zipFolder(File folderToZip, File zipFilePath) {
        Closeable closeable = new ZipOutputStream(new FileOutputStream(zipFilePath));
        Throwable throwable = null;
        try {
            ZipOutputStream zos = (ZipOutputStream)closeable;
            boolean bl = false;
            Sequence $this$forEach$iv = SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)folderToZip, null, (int)1, null)), SboDataObject::zipFolder$lambda$10$lambda$7);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File file = (File)element$iv;
                boolean bl2 = false;
                ZipEntry entry = new ZipEntry(file.getName());
                zos.putNextEntry(entry);
                Closeable closeable2 = new FileInputStream(file);
                Throwable throwable2 = null;
                try {
                    FileInputStream fis = (FileInputStream)closeable2;
                    boolean bl3 = false;
                    long l = ByteStreamsKt.copyTo$default((InputStream)fis, (OutputStream)zos, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                zos.closeEntry();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void createBackup(String modName) {
        try {
            Object existingBackups;
            File modConfigDir = new File(FabricLoader.getInstance().getConfigDir().toFile(), modName);
            File backupDir = new File(modConfigDir, "backup");
            if (!backupDir.exists()) {
                backupDir.mkdirs();
            }
            String timestamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
            File tempBackupDir = new File(backupDir, "SBOBackup_" + timestamp);
            tempBackupDir.mkdirs();
            SboConfigBundle bundle = this.getSBOConfigBundle();
            this.saveToFolder(tempBackupDir, bundle.getSboData(), "SboData.json");
            this.saveToFolder(tempBackupDir, bundle.getAchievementsData(), "sbo_achievements.json");
            this.saveToFolder(tempBackupDir, bundle.getPastDianaEventsData(), "pastDianaEvents.json");
            this.saveToFolder(tempBackupDir, bundle.getDianaTrackerTotalData(), "dianaTrackerTotal.json");
            this.saveToFolder(tempBackupDir, bundle.getDianaTrackerSessionData(), "dianaTrackerSession.json");
            this.saveToFolder(tempBackupDir, bundle.getDianaTrackerMayorData(), "dianaTrackerMayor.json");
            this.saveToFolder(tempBackupDir, bundle.getPartyFinderConfigState(), "partyFinderConfigState.json");
            this.saveToFolder(tempBackupDir, bundle.getPartyFinderData(), "partyFinderData.json");
            this.saveToFolder(tempBackupDir, bundle.getOverlayData(), "overlayData.json");
            File zipFile = new File(backupDir, "SBOBackup_" + timestamp + ".zip");
            this.zipFolder(tempBackupDir, zipFile);
            FilesKt.deleteRecursively((File)tempBackupDir);
            SBOKotlin.INSTANCE.getLogger$SBO().info("[" + modName + "] Created new backup: " + zipFile.getName());
            Object object = backupDir.listFiles(SboDataObject::createBackup$lambda$11);
            if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
                object = CollectionsKt.emptyList();
            }
            if ((existingBackups = object).size() > 10) {
                File oldestBackup;
                Object v1;
                Iterable $this$minByOrNull$iv = (Iterable)existingBackups;
                boolean $i$f$minByOrNull = false;
                Iterator iterator$iv = $this$minByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v1 = null;
                } else {
                    Object minElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v1 = minElem$iv;
                    } else {
                        File it = (File)minElem$iv;
                        boolean bl = false;
                        long minValue$iv = it.lastModified();
                        do {
                            Object e$iv = iterator$iv.next();
                            File it2 = (File)e$iv;
                            $i$a$-minByOrNull-SboDataObject$createBackup$oldestBackup$1 = false;
                            long v$iv = it2.lastModified();
                            if (minValue$iv <= v$iv) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v1 = minElem$iv;
                    }
                }
                File file = oldestBackup = (File)v1;
                if (file != null) {
                    File it = file;
                    boolean bl = false;
                    it.delete();
                    SBOKotlin.INSTANCE.getLogger$SBO().info("[" + modName + "] Deleted old backup: " + it.getName());
                }
            }
        }
        catch (Exception e) {
            SBOKotlin.INSTANCE.getLogger$SBO().error("[" + modName + "] Error creating backup:", (Throwable)e);
        }
    }

    @NotNull
    public final Map<String, Pair<Function0<Unit>, Object>> getConfigMapforSave() {
        return configMapforSave;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> void saveToFolder(File folder, T data, String fileName) {
        Closeable closeable = new FileWriter(new File(folder, fileName));
        Throwable throwable = null;
        try {
            FileWriter writer = (FileWriter)closeable;
            boolean bl = false;
            gson.toJson(data, (Appendable)writer);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void saveAllData() {
        Map<String, Pair<Function0<Unit>, Object>> $this$forEach$iv = configMapforSave;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Pair<Function0<Unit>, Object>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Pair<Function0<Unit>, Object>> element$iv;
            Map.Entry<String, Pair<Function0<Unit>, Object>> entry = element$iv = iterator.next();
            boolean bl = false;
            Pair<Function0<Unit>, Object> configData = entry.getValue();
            ((Function0)configData.getFirst()).invoke();
        }
    }

    public final void saveAllDataThreaded(@NotNull String modName) {
        Intrinsics.checkNotNullParameter((Object)modName, (String)"modName");
        DATA_SAVER_EXECUTOR.execute(() -> SboDataObject.saveAllDataThreaded$lambda$25(modName));
    }

    public final void saveAndBackupAllDataThreaded(@NotNull String modName) {
        Intrinsics.checkNotNullParameter((Object)modName, (String)"modName");
        DATA_SAVER_EXECUTOR.execute(() -> SboDataObject.saveAndBackupAllDataThreaded$lambda$26(modName));
    }

    public final void savePeriodically(int interval) {
        Register.INSTANCE.onTick(1200 * interval, (Function1<? super Function0<Unit>, Unit>)((Function1)SboDataObject::savePeriodically$lambda$27));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> void save(@NotNull String modName, T data, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)modName, (String)"modName");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        File modConfigDir = new File(FabricLoader.getInstance().getConfigDir().toFile(), modName);
        if (!modConfigDir.exists()) {
            modConfigDir.mkdirs();
        }
        File dataFile = new File(modConfigDir, fileName);
        Closeable closeable = new FileWriter(dataFile);
        Throwable throwable = null;
        try {
            FileWriter writer = (FileWriter)closeable;
            boolean bl = false;
            gson.toJson(data, (Appendable)writer);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public final void save(@NotNull String configName) {
        Intrinsics.checkNotNullParameter((Object)configName, (String)"configName");
        DATA_SAVER_EXECUTOR.execute(() -> SboDataObject.save$lambda$29(configName));
    }

    public final void saveTrackerData() {
        DATA_SAVER_EXECUTOR.execute(SboDataObject::saveTrackerData$lambda$30);
    }

    private static final Thread DATA_SAVER_EXECUTOR$lambda$1(Runnable r) {
        Thread thread;
        Thread $this$DATA_SAVER_EXECUTOR_u24lambda_u241_u24lambda_u240 = thread = new Thread(r, "sbo-data-saver-thread");
        boolean bl = false;
        $this$DATA_SAVER_EXECUTOR_u24lambda_u241_u24lambda_u240.setDaemon(true);
        return thread;
    }

    private static final boolean zipFolder$lambda$10$lambda$7(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isFile();
    }

    private static final boolean createBackup$lambda$11(File file, String name) {
        Intrinsics.checkNotNull((Object)name);
        return StringsKt.endsWith$default((String)name, (String)".zip", (boolean)false, (int)2, null);
    }

    private static final Unit configMapforSave$lambda$14() {
        INSTANCE.save("SBO", sboData, "SboData.json");
        return Unit.INSTANCE;
    }

    private static final Unit configMapforSave$lambda$15() {
        INSTANCE.save("SBO", achievementsData, "sbo_achievements.json");
        return Unit.INSTANCE;
    }

    private static final Unit configMapforSave$lambda$16() {
        INSTANCE.save("SBO", pastDianaEventsData, "pastDianaEvents.json");
        return Unit.INSTANCE;
    }

    private static final Unit configMapforSave$lambda$17() {
        INSTANCE.save("SBO", dianaTrackerTotal, "dianaTrackerTotal.json");
        return Unit.INSTANCE;
    }

    private static final Unit configMapforSave$lambda$18() {
        INSTANCE.save("SBO", dianaTrackerSession, "dianaTrackerSession.json");
        return Unit.INSTANCE;
    }

    private static final Unit configMapforSave$lambda$19() {
        INSTANCE.save("SBO", dianaTrackerMayor, "dianaTrackerMayor.json");
        return Unit.INSTANCE;
    }

    private static final Unit configMapforSave$lambda$20() {
        INSTANCE.save("SBO", pfConfigState, "partyFinderConfigState.json");
        return Unit.INSTANCE;
    }

    private static final Unit configMapforSave$lambda$21() {
        INSTANCE.save("SBO", partyFinderData, "partyFinderData.json");
        return Unit.INSTANCE;
    }

    private static final Unit configMapforSave$lambda$22() {
        INSTANCE.save("SBO", overlayData, "overlayData.json");
        return Unit.INSTANCE;
    }

    private static final void saveAllDataThreaded$lambda$25(String $modName) {
        SBOKotlin.INSTANCE.getLogger$SBO().info("[" + $modName + "] Saving all data to disk...");
        INSTANCE.saveAllData();
        SBOKotlin.INSTANCE.getLogger$SBO().info("[" + $modName + "] All data saved successfully.");
    }

    private static final void saveAndBackupAllDataThreaded$lambda$26(String $modName) {
        SBOKotlin.INSTANCE.getLogger$SBO().info("Saving all data to disk and creating backup...");
        INSTANCE.saveAllData();
        SBOKotlin.INSTANCE.getLogger$SBO().info("All data saved successfully.");
        INSTANCE.createBackup($modName);
    }

    private static final Unit savePeriodically$lambda$27(Function0 client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        INSTANCE.saveAllDataThreaded("SBO");
        return Unit.INSTANCE;
    }

    private static final void save$lambda$29(String $configName) {
        Function0 function0 = configMapforSave.get($configName);
        if (function0 != null && (function0 = (Function0)function0.getFirst()) != null) {
            function0.invoke();
        } else {
            SBOKotlin.INSTANCE.getLogger$SBO().warn("[" + $configName + "] is not a valid config name. Please use a valid config name");
        }
    }

    private static final void saveTrackerData$lambda$30() {
        INSTANCE.save("SBO", dianaTrackerTotal, "dianaTrackerTotal.json");
        INSTANCE.save("SBO", dianaTrackerSession, "dianaTrackerSession.json");
        INSTANCE.save("SBO", dianaTrackerMayor, "dianaTrackerMayor.json");
        SBOKotlin.INSTANCE.getLogger$SBO().debug("[SBO] Diana Tracker data saved successfully.");
    }

    static {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        SboDataObject.gson = gson;
        ExecutorService executorService = Executors.newSingleThreadExecutor(SboDataObject::DATA_SAVER_EXECUTOR$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor(...)");
        DATA_SAVER_EXECUTOR = executorService;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"SboData", (Object)new Pair(SboDataObject::configMapforSave$lambda$14, (Object)sboData)), TuplesKt.to((Object)"AchievementsData", (Object)new Pair(SboDataObject::configMapforSave$lambda$15, (Object)achievementsData)), TuplesKt.to((Object)"PastDianaEventsData", (Object)new Pair(SboDataObject::configMapforSave$lambda$16, (Object)pastDianaEventsData)), TuplesKt.to((Object)"DianaTrackerTotalData", (Object)new Pair(SboDataObject::configMapforSave$lambda$17, (Object)dianaTrackerTotal)), TuplesKt.to((Object)"DianaTrackerSessionData", (Object)new Pair(SboDataObject::configMapforSave$lambda$18, (Object)dianaTrackerSession)), TuplesKt.to((Object)"DianaTrackerMayorData", (Object)new Pair(SboDataObject::configMapforSave$lambda$19, (Object)dianaTrackerMayor)), TuplesKt.to((Object)"PartyFinderConfigState", (Object)new Pair(SboDataObject::configMapforSave$lambda$20, (Object)pfConfigState)), TuplesKt.to((Object)"PartyFinderData", (Object)new Pair(SboDataObject::configMapforSave$lambda$21, (Object)partyFinderData)), TuplesKt.to((Object)"OverlayData", (Object)new Pair(SboDataObject::configMapforSave$lambda$22, (Object)overlayData))};
        configMapforSave = MapsKt.mapOf((Pair[])pairArray);
    }
}

