/*
 * Decompiled with CFR 0.152.
 */
package io.shantek;

import io.shantek.functions.Commands;
import io.shantek.functions.Helpers;
import io.shantek.functions.Language;
import io.shantek.functions.Metrics;
import io.shantek.functions.PluginConfig;
import io.shantek.functions.TabCompleter;
import io.shantek.functions.UpdateChecker;
import io.shantek.listeners.BarrelProtection;
import io.shantek.listeners.InventoryClick;
import io.shantek.listeners.InventoryClose;
import io.shantek.listeners.InventoryOpen;
import io.shantek.listeners.PlayerJoin;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class PostOffice
extends JavaPlugin {
    public UpdateChecker updateChecker;
    public Commands commands;
    public Language language;
    public Metrics metrics;
    public PluginConfig pluginConfig;
    public Helpers helpers;
    public BarrelProtection barrelProtection;
    public TabCompleter tabCompleter;
    public static PostOffice instance;
    public String customBarrelName = "pobox";
    public File mailFile;
    public int previousItemCount = 0;
    public int newItemCount = 0;
    public Set<String> playersWithMail = new HashSet<String>();
    public boolean updateNotificationEnabled = true;
    public boolean postBoxProtection = true;
    public boolean consoleLogs = true;
    public boolean gotMailDelay = true;
    public boolean signNotification = true;
    public boolean hopperProtection = false;
    public boolean debugLogs = false;

    public void onEnable() {
        instance = this;
        this.commands = new Commands(this);
        this.language = new Language(this);
        this.barrelProtection = new BarrelProtection(this);
        this.helpers = new Helpers(this);
        TabCompleter tabCompleter = new TabCompleter(this);
        Objects.requireNonNull(this.getCommand("postoffice")).setTabCompleter((org.bukkit.command.TabCompleter)new TabCompleter(this));
        this.helpers.checkForDataFolder();
        this.mailFile = new File(this.getDataFolder(), "hasmail.txt");
        Objects.requireNonNull(this.getCommand("postoffice")).setExecutor((CommandExecutor)new Commands(this));
        this.updateChecker = new UpdateChecker();
        this.pluginConfig = new PluginConfig(this);
        this.pluginConfig.initializeAndLoadConfig();
        this.pluginConfig.initializeAndLoadLang();
        if (this.mailFile.exists()) {
            try (Stream<String> lines = Files.lines(this.mailFile.toPath());){
                this.playersWithMail = lines.filter(line -> !line.isEmpty()).collect(Collectors.toCollection(HashSet::new));
            }
            catch (IOException e) {
                this.getLogger().log(Level.SEVERE, "Could not read mail file", e);
            }
        } else {
            try {
                boolean fileCreated = this.mailFile.createNewFile();
                if (fileCreated) {
                    this.getLogger().info("Mail file created successfully.");
                } else {
                    this.getLogger().warning("Mail file creation failed. It may already exist.");
                }
            }
            catch (IOException e) {
                this.getLogger().log(Level.SEVERE, "Could not create mail file", e);
            }
        }
        int pluginId = 20173;
        Metrics metrics = new Metrics(this, pluginId);
        if (this.updateNotificationEnabled) {
            UpdateChecker.checkForUpdatesAsync(this.getDescription().getVersion(), (Plugin)this);
        }
        this.registerEventListeners();
        this.helpers.loadBlacklist();
    }

    public void registerEventListeners() {
        Bukkit.getPluginManager().registerEvents((Listener)new InventoryClick(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new InventoryClose(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new InventoryOpen(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerJoin(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new BarrelProtection(this), (Plugin)this);
    }

    public static PostOffice getInstance() {
        if (instance == null) {
            instance = new PostOffice();
        }
        return instance;
    }

    public void onDisable() {
        this.helpers.saveCacheToFile();
    }

    public void printInfoMessage(String message) {
        this.getLogger().info(message);
    }
}

