/*
 * Decompiled with CFR 0.152.
 */
package io.shantek.functions;

import io.shantek.PostOffice;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Tag;
import org.bukkit.block.Barrel;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Commands
implements CommandExecutor {
    public PostOffice postOffice;

    public Commands(PostOffice postOffice) {
        this.postOffice = postOffice;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!cmd.getName().equalsIgnoreCase("postoffice")) {
            return false;
        }
        if (args.length == 0) {
            return true;
        }
        if (args[0].equalsIgnoreCase("remove")) {
            return this.onCommandRemove(sender);
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
            return this.onCommandReload(sender);
        }
        if (args[0].equalsIgnoreCase("info")) {
            return this.onCommandInfo(sender);
        }
        if (args[0].equalsIgnoreCase("register")) {
            return this.onCommandRegister(sender);
        }
        if (args[0].equalsIgnoreCase("claim") && args.length == 2) {
            return this.onCommandClaimOthers(sender, args);
        }
        if (args[0].equalsIgnoreCase("claim")) {
            return this.onCommandClaim(sender);
        }
        sender.sendMessage(ChatColor.RED + "Unknown command or insufficient permission.");
        return true;
    }

    public boolean onCommandRemove(CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (player.hasPermission("shantek.postoffice.register") || player.isOp()) {
                Block targetBlock = this.postOffice.helpers.getBlockLookingAt(player, 6.0);
                if (targetBlock == null) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.lookAtPostBox));
                    return true;
                }
                Block barrelBlock = null;
                if (Tag.SIGNS.isTagged((Keyed)targetBlock.getType())) {
                    barrelBlock = this.postOffice.helpers.getAttachedBarrel(targetBlock);
                } else if (targetBlock.getType() == Material.BARREL) {
                    barrelBlock = targetBlock;
                }
                if (barrelBlock == null || barrelBlock.getType() != Material.BARREL) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.lookAtPostBox));
                    return true;
                }
                if (!this.postOffice.helpers.isBarrelInConfig(barrelBlock)) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.notRegistered));
                    return true;
                }
                Block signBlock = this.postOffice.helpers.getSignForBarrel(barrelBlock);
                if (signBlock != null && signBlock.getState() instanceof Sign) {
                    Sign sign = (Sign)signBlock.getState();
                    for (int i = 0; i < 4; ++i) {
                        sign.setLine(i, "");
                    }
                    boolean signUpdated = sign.update();
                    if (!signUpdated) {
                        player.sendMessage(ChatColor.RED + "There was an issue updating the sign.");
                    }
                }
                this.postOffice.helpers.removeBarrelFromCache(barrelBlock);
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.postBoxRemoved));
                return true;
            }
            this.invalidPermission(sender);
            return false;
        }
        sender.sendMessage(ChatColor.RED + "This command can only be used by players.");
        return true;
    }

    public boolean onCommandReload(CommandSender sender) {
        if (sender.hasPermission("shantek.postoffice.reload") || sender.isOp()) {
            this.postOffice.pluginConfig.initializeAndLoadConfig();
            this.postOffice.pluginConfig.initializeAndLoadLang();
            this.postOffice.helpers.saveCacheToFile();
            this.postOffice.helpers.reloadBarrelsConfig();
            this.postOffice.helpers.loadBlacklist();
            sender.sendMessage(ChatColor.GREEN + "Post Office config file has been reloaded.");
            return true;
        }
        this.invalidPermission(sender);
        return false;
    }

    public boolean onCommandInfo(CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            Block targetBlock = this.postOffice.helpers.getBlockLookingAt(player, 6.0);
            if (targetBlock == null) {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.lookAtPostBox));
                return true;
            }
            Block barrelBlock = null;
            if (Tag.SIGNS.isTagged((Keyed)targetBlock.getType())) {
                barrelBlock = this.postOffice.helpers.getBarrelFromSign(targetBlock);
                if (barrelBlock == null || barrelBlock.getType() != Material.BARREL) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.notRegistered));
                    return true;
                }
            } else if (targetBlock.getType() == Material.BARREL) {
                barrelBlock = targetBlock;
            }
            if (barrelBlock == null || barrelBlock.getType() != Material.BARREL) {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.notRegistered));
                return true;
            }
            String barrelLocation = this.postOffice.helpers.getBlockLocationString(barrelBlock);
            String owner = this.postOffice.helpers.getOwnerNameFromConfig(barrelLocation);
            String state = this.postOffice.helpers.getStateFromConfig(barrelLocation);
            if (owner != null && !owner.equals("none")) {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.postBoxOwner.replace("%owner%", owner)));
            } else if (state != null && state.equals("registered")) {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.unclaimedPostbox));
            } else {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.invalidPostbox));
            }
            return true;
        }
        this.invalidPermission(sender);
        return false;
    }

    public boolean onCommandRegister(CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (sender.hasPermission("shantek.postoffice.register") || sender.isOp()) {
                Block targetBlock = this.postOffice.helpers.getBlockLookingAt(player, 6.0);
                if (targetBlock == null || !(targetBlock.getState() instanceof Sign)) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.lookAtPostBox));
                    return true;
                }
                Block attachedBarrel = this.postOffice.helpers.getAttachedBarrel(targetBlock);
                if (attachedBarrel == null || attachedBarrel.getType() != Material.BARREL) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.signOnBarrel));
                    return true;
                }
                String barrelLocation = this.postOffice.helpers.getBlockLocationString(attachedBarrel);
                String currentOwner = this.postOffice.helpers.getOwnerNameFromConfig(barrelLocation);
                String currentState = this.postOffice.helpers.getStateFromConfig(barrelLocation);
                if (currentOwner != null && !currentOwner.equals("none")) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.postBoxOwner.replace("%owner%", currentOwner)));
                    return true;
                }
                if (currentState != null && currentState.equals("registered")) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.alreadyRegistered));
                    return true;
                }
                Barrel barrel = (Barrel)attachedBarrel.getState();
                barrel.setCustomName(this.postOffice.customBarrelName);
                barrel.update();
                UUID barrelOwnerUUID = null;
                this.postOffice.helpers.addOrUpdateBarrelInCache(attachedBarrel, targetBlock, barrelOwnerUUID, "registered");
                Sign sign = (Sign)targetBlock.getState();
                sign.setLine(1, ChatColor.RED + "Unclaimed");
                sign.update();
                this.postOffice.helpers.saveCacheToFile();
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.successfulRegistration));
                return true;
            }
            this.invalidPermission(sender);
            return false;
        }
        sender.sendMessage(ChatColor.RED + "This command can only be used by players.");
        return true;
    }

    public boolean onCommandClaim(CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            UUID playerUUID = player.getUniqueId();
            if (sender.hasPermission("shantek.postoffice.claim") || sender.isOp()) {
                Block targetBlock = this.postOffice.helpers.getBlockLookingAt(player, 6.0);
                if (targetBlock == null) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.lookAtPostBox));
                    return true;
                }
                if (!(targetBlock.getState() instanceof Sign)) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.lookAtPostBox));
                    return true;
                }
                Block attachedBarrel = this.postOffice.helpers.getAttachedBarrel(targetBlock);
                if (attachedBarrel == null || attachedBarrel.getType() != Material.BARREL) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.signOnBarrel));
                    return true;
                }
                Block savedSign = this.postOffice.helpers.getSignForBarrel(attachedBarrel);
                if (savedSign == null) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.notRegistered));
                    return true;
                }
                String barrelLocation = this.postOffice.helpers.getBlockLocationString(attachedBarrel);
                String currentOwner = this.postOffice.helpers.getOwnerNameFromConfig(barrelLocation);
                if (currentOwner != null && !currentOwner.equals("none")) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.alreadyClaimed));
                    return true;
                }
                if (this.postOffice.helpers.doesPlayerHavePostBox(playerUUID)) {
                    String existingPostBoxLocation = this.postOffice.helpers.getPlayerPostBoxLocation(playerUUID);
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.alreadyHasPostBox.replace("%player%", player.getName()).replace("%location%", existingPostBoxLocation)));
                    return true;
                }
                this.postOffice.helpers.addOrUpdateBarrelInCache(attachedBarrel, targetBlock, playerUUID, "claimed");
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.successfullyClaimed));
                if (targetBlock.getState() instanceof Sign) {
                    Sign sign = (Sign)targetBlock.getState();
                    sign.setLine(1, player.getName());
                    sign.update();
                }
                this.postOffice.helpers.saveCacheToFile();
                return true;
            }
            this.invalidPermission(sender);
            return false;
        }
        sender.sendMessage(ChatColor.RED + "This command can only be used by players.");
        return true;
    }

    public boolean onCommandClaimOthers(CommandSender sender, String[] args) {
        if (sender.hasPermission("shantek.postoffice.claim.others") || sender.isOp()) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(ChatColor.RED + "This command can only be used by players.");
                return true;
            }
            Player player = (Player)sender;
            Block targetBlock = this.postOffice.helpers.getBlockLookingAt(player, 6.0);
            if (targetBlock == null) {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.lookAtPostBox));
                return true;
            }
            if (!(targetBlock.getState() instanceof Sign)) {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.lookAtPostBox));
                return true;
            }
            Block attachedBarrel = this.postOffice.helpers.getAttachedBarrel(targetBlock);
            if (attachedBarrel == null || attachedBarrel.getType() != Material.BARREL) {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.signOnBarrel));
                return true;
            }
            Block savedSign = this.postOffice.helpers.getSignForBarrel(attachedBarrel);
            if (savedSign == null) {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.signOnBarrel));
                return true;
            }
            String barrelLocation = this.postOffice.helpers.getBlockLocationString(attachedBarrel);
            String targetPlayerName = args[1];
            OfflinePlayer targetPlayer = Bukkit.getOfflinePlayer((String)targetPlayerName);
            if (!targetPlayer.hasPlayedBefore()) {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.notPlayedBefore.replace("%player%", targetPlayer.toString())));
                return true;
            }
            UUID targetPlayerUUID = targetPlayer.getUniqueId();
            if (this.postOffice.helpers.doesPlayerHavePostBox(targetPlayerUUID)) {
                String existingPostBoxLocation = this.postOffice.helpers.getPlayerPostBoxLocation(targetPlayerUUID);
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.alreadyHasPostBox.replace("%player%", targetPlayerName).replace("%location%", existingPostBoxLocation)));
                return true;
            }
            String currentOwner = this.postOffice.helpers.getOwnerNameFromConfig(barrelLocation);
            if (currentOwner != null && !currentOwner.equals("none")) {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.alreadyClaimed));
                return true;
            }
            this.postOffice.helpers.addOrUpdateBarrelInCache(attachedBarrel, targetBlock, targetPlayerUUID, "claimed");
            if (targetBlock.getState() instanceof Sign) {
                Sign sign = (Sign)targetBlock.getState();
                sign.setLine(1, targetPlayer.getName());
                sign.update();
            }
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.claimedFor.replace("%owner%", targetPlayerName)));
            if (targetPlayer.isOnline()) {
                Objects.requireNonNull(targetPlayer.getPlayer()).sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.claimedForOtherPlayer));
            }
            this.postOffice.helpers.saveCacheToFile();
            return true;
        }
        this.invalidPermission(sender);
        return false;
    }

    public void invalidPermission(CommandSender sender) {
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.noPermission));
    }
}

