/*
 * Decompiled with CFR 0.152.
 */
package io.shantek.functions;

import io.shantek.PostOffice;
import io.shantek.functions.BarrelData;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Barrel;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.RayTraceResult;

public class Helpers {
    private final PostOffice postOffice;
    private FileConfiguration blacklistConfig = null;
    private File blacklistConfigFile = null;
    private Set<Material> blacklistedItems = new HashSet<Material>();
    public Map<String, BarrelData> barrelsCache;
    private FileConfiguration barrelsConfig = null;
    private File barrelsConfigFile = null;

    public Helpers(PostOffice postOffice) {
        this.postOffice = postOffice;
        this.barrelsCache = new HashMap<String, BarrelData>();
        this.loadBarrelsIntoCache();
    }

    public void loadBlacklist() {
        if (this.blacklistConfigFile == null) {
            this.blacklistConfigFile = new File(this.postOffice.getDataFolder(), "blacklist.yml");
        }
        if (!this.blacklistConfigFile.exists()) {
            this.postOffice.saveResource("blacklist.yml", false);
        }
        this.blacklistConfig = YamlConfiguration.loadConfiguration((File)this.blacklistConfigFile);
        this.blacklistedItems.clear();
        List itemNames = this.blacklistConfig.getStringList("items");
        for (String name : itemNames) {
            try {
                Material material = Material.valueOf((String)name.toUpperCase(Locale.ROOT));
                this.blacklistedItems.add(material);
            }
            catch (IllegalArgumentException e) {
                this.postOffice.getLogger().warning("Invalid material in blacklist.yml: " + name);
            }
        }
        this.postOffice.getLogger().info("Loaded " + this.blacklistedItems.size() + " blacklisted items.");
    }

    public boolean isBlacklisted(Material material) {
        return this.blacklistedItems.contains(material);
    }

    public String getBlockLocationString(Block block) {
        return block.getWorld().getName() + "_" + block.getX() + "_" + block.getY() + "_" + block.getZ();
    }

    public String getOwnerNameFromConfig(String barrelLocationString) {
        FileConfiguration barrelsConfig = this.getBarrelsConfig();
        String ownerUUIDString = barrelsConfig.getString("barrels." + barrelLocationString + ".owner");
        if (ownerUUIDString != null && !ownerUUIDString.equals("none")) {
            UUID ownerUUID = UUID.fromString(ownerUUIDString);
            return this.getPlayerName(ownerUUID);
        }
        return "none";
    }

    public boolean doesPlayerHavePostBox(UUID playerUUID) {
        FileConfiguration barrelsConfig = this.getBarrelsConfig();
        if (barrelsConfig.contains("barrels")) {
            ConfigurationSection barrelsSection = barrelsConfig.getConfigurationSection("barrels");
            assert (barrelsSection != null);
            for (String barrelLocation : barrelsSection.getKeys(false)) {
                String ownerUUIDString = barrelsConfig.getString("barrels." + barrelLocation + ".owner");
                if (ownerUUIDString == null || !ownerUUIDString.equals(playerUUID.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public String getPlayerPostBoxLocation(UUID playerUUID) {
        FileConfiguration barrelsConfig = this.getBarrelsConfig();
        for (String barrelLocation : Objects.requireNonNull(barrelsConfig.getConfigurationSection("barrels")).getKeys(false)) {
            Block barrelBlock;
            String ownerUUIDString = barrelsConfig.getString("barrels." + barrelLocation + ".owner");
            if (ownerUUIDString == null || !ownerUUIDString.equals(playerUUID.toString()) || (barrelBlock = this.getBlockFromLocationString(barrelLocation)) == null) continue;
            return barrelBlock.getWorld().getName() + " [" + barrelBlock.getX() + ", " + barrelBlock.getY() + ", " + barrelBlock.getZ() + "]";
        }
        return "Unknown location";
    }

    public int countNonNullItems(ItemStack[] items) {
        int count = 0;
        for (ItemStack item : items) {
            if (item == null || item.getType() == Material.AIR) continue;
            count += item.getAmount();
        }
        return count;
    }

    public OfflinePlayer getPlayer(UUID uuid) {
        return Bukkit.getOfflinePlayer((UUID)uuid);
    }

    public boolean isPostBoxOwner(Block block, Player player) {
        UUID playerUUID = player.getUniqueId();
        return this.getOwnerUUID(block).equals(playerUUID);
    }

    public UUID getOwnerUUID(Block block) {
        String blockLocationString = this.getBlockLocationString(block);
        BarrelData barrelData = this.barrelsCache.get(blockLocationString);
        return barrelData != null ? barrelData.getOwnerUUID() : null;
    }

    public String getPlayerName(UUID uuid) {
        Player onlinePlayer = Bukkit.getPlayer((UUID)uuid);
        if (onlinePlayer != null) {
            return onlinePlayer.getName();
        }
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
        return offlinePlayer.getName();
    }

    public Block getSignForBarrel(Block barrelBlock) {
        String barrelLocationString = this.getBlockLocationString(barrelBlock);
        String signLocationString = this.barrelsConfig.getString("barrels." + barrelLocationString + ".sign");
        if (signLocationString != null) {
            return this.getBlockFromLocationString(signLocationString);
        }
        this.postOffice.getLogger().warning("Sign location not found for barrel: " + barrelLocationString);
        return null;
    }

    public Block getAttachedBarrel(Block signBlock) {
        for (BlockFace face : BlockFace.values()) {
            Block attachedBlock = signBlock.getRelative(face);
            if (attachedBlock.getType() != Material.BARREL) continue;
            return attachedBlock;
        }
        return null;
    }

    public Block getBarrelFromSign(Block signBlock) {
        String signLocationString = this.getBlockLocationString(signBlock);
        FileConfiguration barrelsConfig = this.getBarrelsConfig();
        ConfigurationSection section = barrelsConfig.getConfigurationSection("barrels");
        if (section == null) {
            this.postOffice.getLogger().severe("Barrels section is missing in the config");
            return null;
        }
        for (String barrelLocation : section.getKeys(false)) {
            String storedSignLocation = barrelsConfig.getString("barrels." + barrelLocation + ".sign");
            if (!signLocationString.equals(storedSignLocation)) continue;
            return this.getBlockFromLocationString(barrelLocation);
        }
        return null;
    }

    public boolean hasBarrelNearby(Block block) {
        Barrel barrel;
        String barrelCustomName;
        if (block.getType() == Material.BARREL && (barrelCustomName = (barrel = (Barrel)block.getState()).getCustomName()) != null && barrelCustomName.equalsIgnoreCase(this.postOffice.customBarrelName)) {
            return true;
        }
        for (BlockFace blockFace : BlockFace.values()) {
            Barrel barrel2;
            String barrelCustomName2;
            Block relativeBlock = block.getRelative(blockFace);
            if (relativeBlock.getType() != Material.BARREL || (barrelCustomName2 = (barrel2 = (Barrel)relativeBlock.getState()).getCustomName()) == null || !barrelCustomName2.equalsIgnoreCase(this.postOffice.customBarrelName)) continue;
            return true;
        }
        return false;
    }

    public boolean isProtectedPostBox(Block block) {
        if (block.getType() == Material.BARREL) {
            Barrel barrel = (Barrel)block.getState();
            String barrelCustomName = barrel.getCustomName();
            return barrelCustomName != null && barrelCustomName.equalsIgnoreCase(this.postOffice.customBarrelName);
        }
        if (Tag.SIGNS.isTagged((Keyed)block.getType())) {
            return this.isSignNextToProtectedBarrel(block);
        }
        return false;
    }

    public boolean isSignNextToProtectedBarrel(Block signBlock) {
        BlockFace[] adjacentFaces;
        for (BlockFace face : adjacentFaces = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN}) {
            Barrel barrel;
            String barrelCustomName;
            Block adjacentBlock = signBlock.getRelative(face);
            if (adjacentBlock.getType() != Material.BARREL || (barrelCustomName = (barrel = (Barrel)adjacentBlock.getState()).getCustomName()) == null || !barrelCustomName.equalsIgnoreCase(this.postOffice.customBarrelName)) continue;
            return true;
        }
        return false;
    }

    public Block getBlockLookingAt(Player player, double maxDistance) {
        Block targetBlock = null;
        RayTraceResult result = player.rayTraceBlocks(maxDistance);
        if (result != null && result.getHitBlock() != null) {
            targetBlock = result.getHitBlock();
        }
        return targetBlock;
    }

    public void removeBarrelFromCache(Block barrelBlock) {
        Block signBlock;
        String signLocationString;
        String barrelLocationString = this.getBlockLocationString(barrelBlock);
        BarrelData barrelData = this.barrelsCache.get(barrelLocationString);
        if (barrelData != null && (signLocationString = barrelData.getSignLocation()) != null && (signBlock = this.getBlockFromLocationString(signLocationString)) != null && signBlock.getState() instanceof Sign) {
            Sign sign = (Sign)signBlock.getState();
            for (int i = 0; i < 4; ++i) {
                sign.setLine(i, "");
            }
            sign.update();
        }
        this.barrelsCache.remove(barrelLocationString);
        this.saveCacheToFile();
    }

    public String getStateFromConfig(String barrelLocationString) {
        FileConfiguration barrelsConfig = this.getBarrelsConfig();
        return barrelsConfig.getString("barrels." + barrelLocationString + ".state", "unregistered");
    }

    public boolean isBarrelInConfig(Block block) {
        String blockLocationString = this.getBlockLocationString(block);
        return this.barrelsCache.containsKey(blockLocationString);
    }

    public void loadBarrelsIntoCache() {
        this.barrelsCache.clear();
        FileConfiguration barrelsConfig = this.getBarrelsConfig();
        if (barrelsConfig.contains("barrels")) {
            Set keys = Objects.requireNonNull(barrelsConfig.getConfigurationSection("barrels")).getKeys(false);
            for (String key : keys) {
                String path = "barrels." + key;
                String ownerUUIDString = barrelsConfig.getString(path + ".owner");
                String state = barrelsConfig.getString(path + ".state", "unregistered");
                String signLocation = barrelsConfig.getString(path + ".sign");
                UUID ownerUUID = null;
                if (ownerUUIDString != null && !ownerUUIDString.equalsIgnoreCase("none")) {
                    try {
                        ownerUUID = UUID.fromString(ownerUUIDString);
                    }
                    catch (IllegalArgumentException e) {
                        this.postOffice.getLogger().warning("Invalid UUID found for barrel at " + key);
                        continue;
                    }
                }
                BarrelData barrelData = new BarrelData(ownerUUID, state, signLocation);
                this.barrelsCache.put(key, barrelData);
            }
        } else {
            this.postOffice.getLogger().warning("No barrels found in barrels.yml during cache load.");
        }
    }

    public void addOrUpdateBarrelInCache(Block barrelBlock, Block signBlock, UUID ownerUUID, String state) {
        String barrelLocationString = this.getBlockLocationString(barrelBlock);
        String signLocationString = this.getBlockLocationString(signBlock);
        BarrelData barrelData = new BarrelData(ownerUUID, state, signLocationString);
        this.barrelsCache.put(barrelLocationString, barrelData);
        this.postOffice.getLogger().info("Adding/Updating barrel at: " + barrelLocationString);
        this.postOffice.getLogger().info("Sign location for barrel: " + signLocationString);
        this.postOffice.getLogger().info("Post box state: " + state);
        this.saveCacheToFile();
    }

    public void saveCacheToFile() {
        FileConfiguration cfg = this.getBarrelsConfig();
        cfg.set("barrels", null);
        for (Map.Entry<String, BarrelData> entry : this.barrelsCache.entrySet()) {
            String barrelLocationString = entry.getKey();
            BarrelData barrelData = entry.getValue();
            String path = "barrels." + barrelLocationString;
            cfg.set(path + ".owner", (Object)(barrelData.getOwnerUUID() != null ? barrelData.getOwnerUUID().toString() : "none"));
            cfg.set(path + ".sign", (Object)barrelData.getSignLocation());
            cfg.set(path + ".state", (Object)barrelData.getState());
            Block barrelBlock = this.getBlockFromLocationString(barrelLocationString);
            if (barrelBlock != null) {
                cfg.set(path + ".world", (Object)barrelBlock.getWorld().getName());
                cfg.set(path + ".x", (Object)barrelBlock.getX());
                cfg.set(path + ".y", (Object)barrelBlock.getY());
                cfg.set(path + ".z", (Object)barrelBlock.getZ());
                continue;
            }
            String[] parts = barrelLocationString.split("_");
            if (parts.length < 4) continue;
            try {
                int x = Integer.parseInt(parts[parts.length - 3]);
                int y = Integer.parseInt(parts[parts.length - 2]);
                int z = Integer.parseInt(parts[parts.length - 1]);
                String worldName = String.join((CharSequence)"_", Arrays.copyOf(parts, parts.length - 3));
                cfg.set(path + ".world", (Object)worldName);
                cfg.set(path + ".x", (Object)x);
                cfg.set(path + ".y", (Object)y);
                cfg.set(path + ".z", (Object)z);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.saveBarrelsConfig();
    }

    public void checkForDataFolder() {
        if (!this.postOffice.getDataFolder().exists()) {
            if (this.postOffice.getDataFolder().mkdir()) {
                this.postOffice.getLogger().info("Data folder created successfully.");
            } else {
                this.postOffice.getLogger().warning("Error creating the data folder.");
            }
        }
    }

    public void saveMailFile() {
        try {
            if (this.postOffice.consoleLogs) {
                this.postOffice.getLogger().info("The mail list has been updated.");
            }
            Files.write(this.postOffice.mailFile.toPath(), this.postOffice.playersWithMail, new OpenOption[0]);
        }
        catch (IOException e) {
            this.postOffice.getLogger().log(Level.SEVERE, "Error updating the mail file.", e);
        }
    }

    public void reloadBarrelsConfig() {
        if (this.barrelsConfigFile == null) {
            this.barrelsConfigFile = new File(this.postOffice.getDataFolder(), "barrels.yml");
        }
        this.barrelsConfig = YamlConfiguration.loadConfiguration((File)this.barrelsConfigFile);
        if (!this.barrelsConfigFile.exists()) {
            this.postOffice.saveResource("barrels.yml", false);
        }
        if (this.barrelsConfig.contains("barrels")) {
            Set keys = Objects.requireNonNull(this.barrelsConfig.getConfigurationSection("barrels")).getKeys(false);
            this.postOffice.getLogger().info("Keys in barrels.yml after reload: " + keys.toString());
        } else {
            this.postOffice.getLogger().warning("No barrels found in barrels.yml during reload.");
        }
    }

    public FileConfiguration getBarrelsConfig() {
        if (this.barrelsConfig == null) {
            this.reloadBarrelsConfig();
        }
        return this.barrelsConfig;
    }

    public void saveBarrelsConfig() {
        if (this.barrelsConfig == null || this.barrelsConfigFile == null) {
            return;
        }
        try {
            this.barrelsConfig.save(this.barrelsConfigFile);
        }
        catch (IOException e) {
            this.postOffice.getLogger().severe("Could not save barrels.yml: " + e.getMessage());
        }
    }

    public Block getBlockFromLocationString(String locationString) {
        String[] parts = locationString.split("_");
        if (parts.length < 4) {
            this.postOffice.getLogger().warning("Invalid location string format: " + locationString);
            return null;
        }
        try {
            int x = Integer.parseInt(parts[parts.length - 3]);
            int y = Integer.parseInt(parts[parts.length - 2]);
            int z = Integer.parseInt(parts[parts.length - 1]);
            String worldName = String.join((CharSequence)"_", Arrays.copyOf(parts, parts.length - 3));
            World world = Bukkit.getWorld((String)worldName);
            if (world != null) {
                return world.getBlockAt(x, y, z);
            }
            this.postOffice.getLogger().warning("World not found: " + worldName);
        }
        catch (NumberFormatException e) {
            this.postOffice.getLogger().warning("Invalid number format in location string: " + locationString + " - Error: " + e.getMessage());
        }
        return null;
    }

    public Block getSignFromConfig(Block barrelBlock) {
        int z;
        int y;
        int x;
        String barrelLocationString = this.getBlockLocationString(barrelBlock);
        String path = "barrels." + barrelLocationString + ".sign";
        FileConfiguration cfg = this.getBarrelsConfig();
        if (!cfg.contains(path)) {
            return null;
        }
        String signLocation = cfg.getString(path);
        if (signLocation == null || signLocation.isEmpty()) {
            return null;
        }
        String[] parts = signLocation.split("_");
        if (parts.length < 4) {
            return null;
        }
        int len = parts.length;
        try {
            x = Integer.parseInt(parts[len - 3]);
            y = Integer.parseInt(parts[len - 2]);
            z = Integer.parseInt(parts[len - 1]);
        }
        catch (NumberFormatException e) {
            return null;
        }
        String worldName = String.join((CharSequence)"_", Arrays.copyOf(parts, len - 3));
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            return null;
        }
        return world.getBlockAt(x, y, z);
    }
}

