/*
 * Decompiled with CFR 0.152.
 */
package io.shantek.functions;

import io.shantek.PostOffice;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Set;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class PluginConfig {
    private final PostOffice postOffice;
    private final File configFile;
    private final File backupConfigFile;
    private final File backupLangFile;
    private final File langFile;
    private YamlConfiguration config;
    private YamlConfiguration langConfig;

    public PluginConfig(PostOffice postOffice) {
        this.postOffice = postOffice;
        this.configFile = new File(postOffice.getDataFolder(), "config.yml");
        this.backupConfigFile = new File(postOffice.getDataFolder(), "config-backup.yml");
        this.backupLangFile = new File(postOffice.getDataFolder(), "lang-backup.yml");
        this.langFile = new File(postOffice.getDataFolder(), "lang.yml");
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.langConfig = YamlConfiguration.loadConfiguration((File)this.langFile);
    }

    public void initializeAndLoadConfig() {
        try {
            if (!this.configFile.exists()) {
                this.createDefaultConfig();
            }
            if (this.shouldReloadConfig()) {
                this.createConfigBackup();
                this.reloadConfig();
            } else {
                this.loadConfigIntoMemory();
            }
        }
        catch (Exception e) {
            this.postOffice.getLogger().severe("Error initializing and loading configuration: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private boolean shouldReloadConfig() {
        boolean needsReload;
        YamlConfiguration newConfig = YamlConfiguration.loadConfiguration((File)this.configFile);
        boolean bl = needsReload = !this.isConfigValid(this.configFile) || newConfig.getInt("config-version") != this.getCurrentConfigVersion();
        if (needsReload) {
            this.postOffice.getLogger().info("Configuration needs reloading.");
        }
        return needsReload;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getCurrentConfigVersion() {
        try (InputStream defConfigStream = this.postOffice.getResource("config.yml");){
            if (defConfigStream == null) return 0;
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream, StandardCharsets.UTF_8));
            int n = defConfig.getInt("config-version", 0);
            return n;
        }
        catch (IOException e) {
            this.postOffice.getLogger().severe("Failed to read the default configuration version: " + e.getMessage());
        }
        return 0;
    }

    private boolean isConfigValid(File configFile) {
        try {
            if (!configFile.exists()) {
                return false;
            }
            YamlConfiguration loadedConfig = new YamlConfiguration();
            loadedConfig.load(configFile);
            return loadedConfig.contains("config-version");
        }
        catch (IOException | InvalidConfigurationException e) {
            this.postOffice.getLogger().severe("Invalid configuration file detected: " + e.getMessage());
            return false;
        }
    }

    private void createConfigBackup() {
        try {
            if (this.configFile.exists()) {
                Files.copy(this.configFile.toPath(), this.backupConfigFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.postOffice.getLogger().info("Configuration file backed up as config-backup.yml.");
            }
        }
        catch (IOException e) {
            this.postOffice.getLogger().severe("Failed to backup configuration file: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void createDefaultConfig() {
        try (InputStream defConfigStream = this.postOffice.getResource("config.yml");){
            if (defConfigStream != null) {
                Files.copy(defConfigStream, this.configFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.postOffice.getLogger().info("Configuration file created successfully");
            } else {
                this.postOffice.getLogger().severe("Default configuration file (config.yml) not found in resources!");
            }
        }
        catch (IOException e) {
            this.postOffice.getLogger().severe("An error occurred while creating the default configuration: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void reloadConfig() {
        try {
            if (!this.configFile.exists()) {
                this.createDefaultConfig();
            }
            try (InputStream defConfigStream = this.postOffice.getResource("config.yml");){
                if (defConfigStream == null) {
                    this.postOffice.getLogger().severe("Default configuration file (config.yml) not found in resources!");
                    return;
                }
                Files.copy(defConfigStream, this.configFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            this.config = new YamlConfiguration();
            YamlConfiguration newConfig = YamlConfiguration.loadConfiguration((File)this.configFile);
            if (this.isConfigValid(this.backupConfigFile)) {
                YamlConfiguration backupConfig = YamlConfiguration.loadConfiguration((File)this.backupConfigFile);
                this.mergeConfigs(newConfig, backupConfig);
            }
            newConfig.save(this.configFile);
            this.postOffice.getLogger().info("Configuration file successfully migrated");
            this.config.load(this.configFile);
            this.loadConfigIntoMemory();
        }
        catch (IOException | InvalidConfigurationException e) {
            this.postOffice.getLogger().severe("An error occurred while handling the configuration file: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void mergeConfigs(YamlConfiguration baseConfig, YamlConfiguration overrideConfig) {
        Set keys = overrideConfig.getKeys(true);
        for (String key : keys) {
            if ("config-version".equals(key)) continue;
            baseConfig.set(key, overrideConfig.get(key));
        }
    }

    private void loadConfigIntoMemory() {
        YamlConfiguration newConfig = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.postOffice.customBarrelName = newConfig.getString("custom-barrel-name", "pobox");
        this.postOffice.signNotification = newConfig.getBoolean("sign-notification", true);
        this.postOffice.gotMailDelay = newConfig.getBoolean("got-mail-delay", true);
        this.postOffice.postBoxProtection = newConfig.getBoolean("postbox-protection", true);
        this.postOffice.hopperProtection = newConfig.getBoolean("hopper-protection", false);
        this.postOffice.updateNotificationEnabled = newConfig.getBoolean("update-notification", true);
        this.postOffice.consoleLogs = newConfig.getBoolean("console-logs", true);
        this.postOffice.debugLogs = newConfig.getBoolean("debug", false);
        this.postOffice.getLogger().info("Configuration file loaded into memory.");
    }

    public void initializeAndLoadLang() {
        try {
            if (!this.langFile.exists()) {
                this.createDefaultLang();
            }
            if (this.shouldReloadLang()) {
                this.createLangBackup();
                this.reloadLang();
            } else {
                this.loadLangIntoMemory();
            }
        }
        catch (Exception e) {
            this.postOffice.getLogger().severe("Error initializing and loading lang file: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private boolean shouldReloadLang() {
        boolean needsReload;
        YamlConfiguration newLang = YamlConfiguration.loadConfiguration((File)this.langFile);
        boolean bl = needsReload = !this.isLangValid(this.langFile) || newLang.getInt("lang-version") != this.getCurrentLangVersion();
        if (needsReload) {
            this.postOffice.getLogger().info("Lang file needs reloading.");
        }
        return needsReload;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getCurrentLangVersion() {
        try (InputStream defLangStream = this.postOffice.getResource("lang.yml");){
            if (defLangStream == null) return 0;
            YamlConfiguration defLang = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defLangStream, StandardCharsets.UTF_8));
            int n = defLang.getInt("lang-version", 0);
            return n;
        }
        catch (IOException e) {
            this.postOffice.getLogger().severe("Failed to read the default lang version: " + e.getMessage());
        }
        return 0;
    }

    private boolean isLangValid(File langFile) {
        try {
            if (!langFile.exists()) {
                return false;
            }
            YamlConfiguration loadedLang = new YamlConfiguration();
            loadedLang.load(langFile);
            return loadedLang.contains("lang-version");
        }
        catch (IOException | InvalidConfigurationException e) {
            this.postOffice.getLogger().severe("Invalid lang file detected: " + e.getMessage());
            return false;
        }
    }

    private void createLangBackup() {
        try {
            if (this.langFile.exists()) {
                Files.copy(this.langFile.toPath(), this.backupLangFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.postOffice.getLogger().info("Lang file backed up as lang-backup.yml.");
            }
        }
        catch (IOException e) {
            this.postOffice.getLogger().severe("Failed to backup lang file: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void createDefaultLang() {
        try (InputStream defLangStream = this.postOffice.getResource("lang.yml");){
            if (defLangStream != null) {
                Files.copy(defLangStream, this.langFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.postOffice.getLogger().info("Lang file created successfully");
            } else {
                this.postOffice.getLogger().severe("Default lang file (lang.yml) not found in resources!");
            }
        }
        catch (IOException e) {
            this.postOffice.getLogger().severe("An error occurred while creating the default lang file: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void reloadLang() {
        try {
            if (!this.langFile.exists()) {
                this.createDefaultLang();
            }
            try (InputStream defLangStream = this.postOffice.getResource("lang.yml");){
                if (defLangStream == null) {
                    this.postOffice.getLogger().severe("Default lang file (lang.yml) not found in resources!");
                    return;
                }
                Files.copy(defLangStream, this.langFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            this.langConfig = new YamlConfiguration();
            YamlConfiguration newLang = YamlConfiguration.loadConfiguration((File)this.langFile);
            if (this.isLangValid(this.backupLangFile)) {
                YamlConfiguration backupLang = YamlConfiguration.loadConfiguration((File)this.backupLangFile);
                this.mergeLangs(newLang, backupLang);
            }
            newLang.save(this.langFile);
            this.postOffice.getLogger().info("Lang file successfully migrated");
            this.langConfig.load(this.langFile);
            this.loadLangIntoMemory();
        }
        catch (IOException | InvalidConfigurationException e) {
            this.postOffice.getLogger().severe("An error occurred while handling the lang file: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void mergeLangs(YamlConfiguration baseConfig, YamlConfiguration overrideConfig) {
        Set keys = overrideConfig.getKeys(true);
        for (String key : keys) {
            if ("lang-version".equals(key)) continue;
            baseConfig.set(key, overrideConfig.get(key));
        }
    }

    private void loadLangIntoMemory() {
        YamlConfiguration newLang = YamlConfiguration.loadConfiguration((File)this.langFile);
        this.postOffice.language.sentMessage = newLang.getString("sent-message", "&a[Post Office] &aMail sent to %receiver%.");
        this.postOffice.language.receivedMessage = newLang.getString("received-message", "&a[Post Office] &eYou received mail from %sender%!");
        this.postOffice.language.gotMailMessage = newLang.getString("got-mail-message", "&a[Post Office] &fYou got mail!");
        this.postOffice.language.noPermission = newLang.getString("no-permission", "&a[Post Office] &4You don't have permission to do that.");
        this.postOffice.language.denyAction = newLang.getString("deny-action", "&a[Post Office] &4You can't do that here!");
        this.postOffice.language.notRegistered = newLang.getString("not-registered", "&a[Post Office] &4This isn't a registered post office box.");
        this.postOffice.language.postBoxRemoved = newLang.getString("post-box-removed", "&a[Post Office] &aPost box removed successfully.");
        this.postOffice.language.successfulRegistration = newLang.getString("successful-registration", "&a[Post Office] &aPost box registered successfully.");
        this.postOffice.language.alreadyRegistered = newLang.getString("already-registered", "&a[Post Office] &4This post box is already registered.");
        this.postOffice.language.postboxCreated = newLang.getString("postbox-created", "&a[Post Office] &4 Box successfully created for %username%");
        this.postOffice.language.removeFromConfig = newLang.getString("remove-from-config", "&a[Post Office] &aPost box successfully removed from the config.");
        this.postOffice.language.lookAtPostBox = newLang.getString("look-at-post-box", "&a[Post Office] &4You must be looking at a barrel or a sign attached to a barrel.");
        this.postOffice.language.signOnBarrel = newLang.getString("sign-on-barrel", "&a[Post Office] &4The sign must be attached to a barrel.");
        this.postOffice.language.alreadyClaimed = newLang.getString("already-claimed", "&a[Post Office] &4This post box has already been claimed.");
        this.postOffice.language.invalidPostbox = newLang.getString("invalid-postbox", "&a[Post Office] &4This isn't a valid post box.");
        this.postOffice.language.successfullyClaimed = newLang.getString("successfully-claimed", "&a[Post Office] &aYou have successfully registered this post box.");
        this.postOffice.language.modifySign = newLang.getString("modify-sign", "&a[Post Office] &4You cannot modify a post box sign.");
        this.postOffice.language.unclaimedPostbox = newLang.getString("unclaimed-postbox", "&a[Post Office] &4This post box is unclaimed.");
        this.postOffice.language.userBanned = newLang.getString("user-banned", "&a[Post Office] &4You aren't able to interact with this post box.");
        this.postOffice.language.postBoxOwner = newLang.getString("post-box-owner", "&a[Post Office] &aThis post box is owned by %owner%");
        this.postOffice.language.claimedFor = newLang.getString("claimed-for", "&a[Post Office] &aThis post box has been claimed for %owner%");
        this.postOffice.language.alreadyHasPostBox = newLang.getString("already-has-postbox", "&a[Post Office] &4%player% already has a post box at: %location%");
        this.postOffice.language.notPlayedBefore = newLang.getString("not-played-before", "&a[Post Office] &4The player %player% has not played on this server.");
        this.postOffice.language.claimedForOtherPlayer = newLang.getString("claimed-for-other-player", "&a[Post Office] &aA post box has been created for you.");
        this.postOffice.language.pluginUpToDate = newLang.getString("plugin-up-to-date", "Your plugin is up-to-date.");
        this.postOffice.language.blacklistedItem = newLang.getString("blacklisted-item", "&a[Post Office] &4This is a blacklisted item.");
        this.postOffice.getLogger().info("Lang file loaded into memory.");
    }
}

