/*
 * Decompiled with CFR 0.152.
 */
package io.shantek.functions;

import io.shantek.PostOffice;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TabCompleter
implements org.bukkit.command.TabCompleter {
    public PostOffice postOffice;

    public TabCompleter(PostOffice postOffice) {
        this.postOffice = postOffice;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (cmd.getName().equalsIgnoreCase("postoffice")) {
            if (args.length == 1) {
                if (sender.hasPermission("shantek.postoffice.reload")) {
                    completions.add("reload");
                }
                if (sender.hasPermission("shantek.postoffice.claim") || sender.hasPermission("shantek.postoffice.claim.others")) {
                    completions.add("claim");
                }
                if (sender.hasPermission("shantek.postoffice.register")) {
                    completions.add("register");
                    completions.add("remove");
                }
                completions.add("info");
                return completions.stream().filter(c -> c.startsWith(args[0].toLowerCase())).sorted().collect(Collectors.toList());
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("claim") && sender.hasPermission("shantek.postoffice.claim.others")) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    completions.add(player.getName());
                }
                return completions.stream().filter(c -> c.toLowerCase().startsWith(args[1].toLowerCase())).sorted().collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }
}

