/*
 * Decompiled with CFR 0.152.
 */
package io.shantek.functions;

import io.shantek.PostOffice;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;

public class UpdateChecker {
    public static String remoteVersion = null;

    public static void checkForUpdatesAsync(String currentVersion, Plugin plugin) {
        CompletableFuture.runAsync(() -> UpdateChecker.checkForUpdates(currentVersion, plugin));
    }

    private static void checkForUpdates(String currentVersion, Plugin plugin) {
        PostOffice postOffice = PostOffice.getInstance();
        String updateUrl = "https://api.shantek.dev/postoffice.txt";
        try {
            URL url = new URL(updateUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                remoteVersion = reader.readLine();
                if (remoteVersion.matches("\\d+\\.\\d+(\\.\\d+)?")) {
                    if (UpdateChecker.isNewVersionAvailable(currentVersion, remoteVersion)) {
                        plugin.getLogger().log(Level.WARNING, "Plugin outdated. Installed version: " + currentVersion + ", Latest version: " + remoteVersion);
                    } else {
                        postOffice.printInfoMessage(postOffice.language.pluginUpToDate);
                    }
                } else {
                    plugin.getLogger().log(Level.WARNING, "Failed to check for updates. Ignoring.");
                    remoteVersion = currentVersion;
                }
            } else {
                plugin.getLogger().log(Level.WARNING, "Failed to check for updates. Response Code: " + responseCode);
            }
        }
        catch (IOException e) {
            plugin.getLogger().log(Level.WARNING, "Error checking for updates.");
        }
    }

    public static boolean isNewVersionAvailable(String currentVersion, String remoteVersion) {
        if (remoteVersion == null || remoteVersion.isEmpty()) {
            return false;
        }
        String[] currentVersionParts = currentVersion.split("\\.");
        String[] remoteVersionParts = remoteVersion.split("\\.");
        boolean isDevBuild = currentVersion.toLowerCase().contains("snapshot") || currentVersion.toLowerCase().contains("dev");
        for (int i = 0; i < Math.min(currentVersionParts.length, remoteVersionParts.length); ++i) {
            try {
                int currentPart = Integer.parseInt(currentVersionParts[i]);
                int remotePart = Integer.parseInt(remoteVersionParts[i]);
                if (currentPart < remotePart) {
                    return true;
                }
                if (currentPart <= remotePart) continue;
                return false;
            }
            catch (NumberFormatException e) {
                if (!isDevBuild) continue;
                return false;
            }
        }
        return currentVersionParts.length < remoteVersionParts.length;
    }
}

