/*
 * Decompiled with CFR 0.152.
 */
package io.shantek.listeners;

import io.shantek.PostOffice;
import java.util.ArrayList;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Barrel;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Hopper;
import org.bukkit.block.Sign;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;

public class BarrelProtection
implements Listener {
    private final PostOffice postOffice;

    public BarrelProtection(PostOffice postOffice) {
        this.postOffice = postOffice;
    }

    @EventHandler
    public void onSignChange(SignChangeEvent event) {
        if (!this.postOffice.postBoxProtection) {
            return;
        }
        Player player = event.getPlayer();
        Block signBlock = event.getBlock();
        Block attachedBarrel = this.postOffice.helpers.getAttachedBarrel(signBlock);
        if (attachedBarrel != null && attachedBarrel.getType() == Material.BARREL && this.postOffice.helpers.isBarrelInConfig(attachedBarrel)) {
            if (player.hasPermission("shantek.postoffice.register")) {
                String rawLine = Optional.ofNullable(event.getLine(0)).orElse("");
                String attemptedLine0 = ChatColor.translateAlternateColorCodes((char)'&', (String)rawLine);
                event.setCancelled(true);
                Bukkit.getScheduler().runTaskLater((Plugin)this.postOffice, () -> {
                    BlockState state = signBlock.getState();
                    if (state instanceof Sign) {
                        Sign sign = (Sign)state;
                        sign.setLine(0, attemptedLine0);
                        sign.update();
                    }
                }, 1L);
            } else {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.modifySign));
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (!this.postOffice.postBoxProtection) {
            return;
        }
        Player player = event.getPlayer();
        Block brokenBlock = event.getBlock();
        if (this.postOffice.helpers.isProtectedPostBox(brokenBlock)) {
            if (player.isOp() || player.hasPermission("shantek.postoffice.break")) {
                Block barrelBlock = null;
                if (Tag.SIGNS.isTagged((Keyed)brokenBlock.getType())) {
                    barrelBlock = this.postOffice.helpers.getAttachedBarrel(brokenBlock);
                } else if (brokenBlock.getType() == Material.BARREL) {
                    barrelBlock = brokenBlock;
                }
                if (barrelBlock == null) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.notRegistered));
                    return;
                }
                if (this.postOffice.helpers.isBarrelInConfig(barrelBlock)) {
                    this.postOffice.helpers.removeBarrelFromCache(barrelBlock);
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.removeFromConfig));
                }
            } else {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.noPermission));
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (!this.postOffice.postBoxProtection) {
            return;
        }
        Player player = event.getPlayer();
        Block placedBlock = event.getBlockPlaced();
        if (placedBlock.getState() instanceof Sign && this.postOffice.helpers.hasBarrelNearby(placedBlock) && !player.isOp() && !player.hasPermission("shantek.postoffice.create")) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.noPermission));
            placedBlock.breakNaturally();
        }
    }

    @EventHandler
    public void onInventoryMoveItem(InventoryMoveItemEvent event) {
        if (!this.postOffice.postBoxProtection) {
            return;
        }
        if (!this.postOffice.hopperProtection) {
            return;
        }
        InventoryHolder sourceHolder = event.getSource().getHolder();
        if (!(sourceHolder instanceof Barrel)) {
            return;
        }
        InventoryHolder destinationHolder = event.getDestination().getHolder();
        if (!(destinationHolder instanceof Hopper) && !(destinationHolder instanceof HopperMinecart)) {
            return;
        }
        Barrel barrel = (Barrel)sourceHolder;
        if (this.postOffice.helpers.isProtectedPostBox(barrel.getBlock())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent event) {
        if (!this.postOffice.postBoxProtection) {
            return;
        }
        event.blockList().removeIf(this.postOffice.helpers::isProtectedPostBox);
    }

    @EventHandler
    public void onBlockExplode(BlockExplodeEvent event) {
        if (!this.postOffice.postBoxProtection) {
            return;
        }
        event.blockList().removeIf(this.postOffice.helpers::isProtectedPostBox);
    }

    @EventHandler
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        Block block;
        if (!this.postOffice.postBoxProtection) {
            return;
        }
        if (event.getEntityType() == EntityType.WITHER && this.postOffice.helpers.isProtectedPostBox(block = event.getBlock())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        Block hitBlock;
        if (!this.postOffice.postBoxProtection) {
            return;
        }
        if (event.getEntity() instanceof WitherSkull && (hitBlock = event.getHitBlock()) != null && this.postOffice.helpers.isProtectedPostBox(hitBlock)) {
            event.getEntity().remove();
        }
    }

    @EventHandler
    public void onStructureGrow(StructureGrowEvent event) {
        if (!this.postOffice.postBoxProtection) {
            return;
        }
        ArrayList<BlockState> blocksToRemove = new ArrayList<BlockState>();
        for (BlockState blockState : event.getBlocks()) {
            Block block = blockState.getBlock();
            if (!this.postOffice.helpers.isProtectedPostBox(block)) continue;
            blocksToRemove.add(blockState);
        }
        event.getBlocks().removeAll(blocksToRemove);
    }
}

