/*
 * Decompiled with CFR 0.152.
 */
package io.shantek.listeners;

import io.shantek.PostOffice;
import java.util.Objects;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Barrel;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class InventoryClick
implements Listener {
    public PostOffice postOffice;

    public InventoryClick(PostOffice postOffice) {
        this.postOffice = postOffice;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        Inventory clickedInventory = event.getClickedInventory();
        if (this.shouldIgnoreEvent(clickedInventory, event.getInventory())) {
            return;
        }
        if (this.isDoubleClickOnPlayerInventory(event, clickedInventory, player)) {
            this.cancelIfBarrelNameMatches(event, player.getOpenInventory().getTopInventory());
            return;
        }
        this.handleBarrelInteractions(event, player, clickedInventory);
    }

    private boolean shouldIgnoreEvent(Inventory clickedInventory, Inventory inventory) {
        return clickedInventory == null || inventory.getType() != InventoryType.BARREL;
    }

    private boolean isDoubleClickOnPlayerInventory(InventoryClickEvent event, Inventory clickedInventory, Player player) {
        return event.getClick() == ClickType.DOUBLE_CLICK && (clickedInventory == player.getInventory() || clickedInventory.getType() == InventoryType.PLAYER);
    }

    private void cancelIfBarrelNameMatches(InventoryClickEvent event, Inventory inventory) {
        Block clickedBlock = Objects.requireNonNull(inventory.getLocation()).getBlock();
        if (this.isBarrelWithName(clickedBlock, PostOffice.instance.customBarrelName)) {
            event.setCancelled(true);
        }
    }

    private boolean isBarrelWithName(Block block, String name) {
        BlockState blockState;
        if (block.getType() == Material.BARREL && (blockState = block.getState()) instanceof Barrel) {
            Barrel barrel = (Barrel)blockState;
            return name.equalsIgnoreCase(barrel.getCustomName());
        }
        return false;
    }

    private void handleBarrelInteractions(InventoryClickEvent event, Player player, Inventory clickedInventory) {
        Block clickedBlock = Objects.requireNonNull(clickedInventory.getLocation()).getBlock();
        if (this.isBarrelWithName(clickedBlock, PostOffice.instance.customBarrelName)) {
            String ownerName = this.findOwnerName(clickedBlock, player);
            boolean isOwner = ownerName.equalsIgnoreCase(player.getName());
            if (this.shouldCancelEvent(event, player, isOwner)) {
                event.setCancelled(true);
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)PostOffice.instance.language.denyAction));
                return;
            }
            if (this.postOffice.helpers.isBlacklisted(event.getCurrentItem().getType()) || this.postOffice.helpers.isBlacklisted(event.getCursor().getType())) {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)PostOffice.instance.language.blacklistedItem));
                event.setCancelled(true);
                return;
            }
            if (player.isOp() || player.hasPermission("shantek.postoffice.removeitems") || isOwner) {
                return;
            }
            if (this.isItemAlreadyInBarrel(event, clickedInventory)) {
                event.setCancelled(true);
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)PostOffice.instance.language.denyAction));
            }
        }
    }

    private String findOwnerName(Block clickedBlock, Player player) {
        for (BlockFace blockFace : BlockFace.values()) {
            Block relativeBlock = clickedBlock.getRelative(blockFace);
            if (!relativeBlock.getType().name().toUpperCase().contains("SIGN")) continue;
            Sign sign = (Sign)relativeBlock.getState();
            Location signLoc = relativeBlock.getLocation().subtract(blockFace.getDirection());
            if (!sign.getLine(1).equalsIgnoreCase(player.getName()) || !signLoc.equals((Object)clickedBlock.getLocation())) continue;
            return sign.getLine(1);
        }
        return "";
    }

    private boolean shouldCancelEvent(InventoryClickEvent event, Player player, boolean isOwner) {
        return !player.isOp() && !isOwner && !player.hasPermission("shantek.postoffice.removeitems") && (event.getAction().name().contains("PICKUP") || event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY || event.getClick() == ClickType.NUMBER_KEY || event.getAction() == InventoryAction.SWAP_WITH_CURSOR || event.getAction() == InventoryAction.HOTBAR_SWAP || event.getClick() == ClickType.DROP || event.getClick() == ClickType.CONTROL_DROP);
    }

    private boolean isItemAlreadyInBarrel(InventoryClickEvent event, Inventory inventory) {
        ItemStack[] contents;
        for (ItemStack item : contents = inventory.getContents()) {
            if (item == null || event.getCurrentItem() == null || !item.isSimilar(event.getCurrentItem()) || item.getAmount() >= item.getMaxStackSize()) continue;
            return true;
        }
        return false;
    }
}

