/*
 * Decompiled with CFR 0.152.
 */
package io.shantek.listeners;

import io.shantek.PostOffice;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;

public class InventoryClose
implements Listener {
    public PostOffice postOffice;

    public InventoryClose(PostOffice postOffice) {
        this.postOffice = postOffice;
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Block barrelBlock;
        PostOffice plugin = PostOffice.getInstance();
        Inventory inventory = event.getInventory();
        Player player = (Player)event.getPlayer();
        if (inventory.getType() != InventoryType.BARREL || inventory.getLocation() == null) {
            return;
        }
        if (this.isBarrelInventory(inventory, event) && this.postOffice.helpers.isBarrelInConfig(barrelBlock = this.getBarrelBlock(event))) {
            this.processBarrelInventoryClose(plugin, inventory, player, barrelBlock);
        }
    }

    private boolean isBarrelInventory(Inventory inventory, InventoryCloseEvent event) {
        return inventory.getType() == InventoryType.BARREL && Objects.requireNonNull(event.getInventory().getLocation()).getBlock().getType() == Material.BARREL;
    }

    private void processBarrelInventoryClose(PostOffice plugin, Inventory inventory, Player player, Block barrelBlock) {
        UUID boxOwnerUUID = this.postOffice.helpers.getOwnerUUID(barrelBlock);
        if (boxOwnerUUID == null) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)plugin.language.unclaimedPostbox));
        } else {
            this.logValidPostBox(plugin, this.postOffice.helpers.getPlayer(boxOwnerUUID));
        }
        if (boxOwnerUUID != null && this.postOffice.helpers.isPostBoxOwner(barrelBlock, player)) {
            this.clearSignAndNotifications(plugin, barrelBlock, player);
        } else if (boxOwnerUUID != null) {
            this.checkForItemChanges(plugin, inventory, barrelBlock, player, boxOwnerUUID);
        }
    }

    private void logValidPostBox(PostOffice plugin, OfflinePlayer boxOwner) {
        if (plugin.consoleLogs) {
            plugin.getLogger().info("Closing valid post box. Owner: " + boxOwner.getName());
        }
    }

    private void clearSignAndNotifications(PostOffice plugin, Block barrelBlock, Player player) {
        Block signBlock = this.postOffice.helpers.getSignFromConfig(barrelBlock);
        if (signBlock != null && signBlock.getState() instanceof Sign) {
            Sign sign = (Sign)signBlock.getState();
            sign.setLine(2, "");
            sign.update();
        }
        plugin.playersWithMail.remove(player.getUniqueId().toString());
        this.postOffice.helpers.saveMailFile();
    }

    private void checkForItemChanges(PostOffice plugin, Inventory inventory, Block barrelBlock, Player player, UUID boxOwnerUUID) {
        plugin.newItemCount = this.postOffice.helpers.countNonNullItems(inventory.getContents());
        if (plugin.newItemCount > plugin.previousItemCount) {
            this.updateSignAndNotifyOwner(plugin, barrelBlock, player, boxOwnerUUID);
        }
    }

    private void updateSignAndNotifyOwner(PostOffice plugin, Block barrelBlock, Player player, UUID boxOwnerUUID) {
        Block signBlock = plugin.helpers.getSignFromConfig(barrelBlock);
        if (plugin.signNotification && signBlock != null && signBlock.getState() instanceof Sign) {
            Sign sign = (Sign)signBlock.getState();
            sign.setLine(2, ChatColor.GREEN + "You have mail");
            sign.update();
        }
        this.sendPlayerMessage(plugin, player, boxOwnerUUID);
        plugin.playersWithMail.add(boxOwnerUUID.toString());
        plugin.helpers.saveMailFile();
        this.notifyOwner(plugin, player, boxOwnerUUID);
    }

    private void sendPlayerMessage(PostOffice plugin, Player player, UUID boxOwnerUUID) {
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)plugin.language.sentMessage.replace("%sender%", player.getName()).replace("%receiver%", Objects.requireNonNull(Bukkit.getOfflinePlayer((UUID)boxOwnerUUID).getName()))));
        if (plugin.consoleLogs) {
            plugin.getLogger().info(player.getName() + " added mail for " + Bukkit.getOfflinePlayer((UUID)boxOwnerUUID).getName());
        }
    }

    private void notifyOwner(PostOffice plugin, Player player, UUID boxOwnerUUID) {
        Player owner = Bukkit.getPlayer((UUID)boxOwnerUUID);
        if (owner != null) {
            owner.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)plugin.language.receivedMessage.replace("%sender%", player.getName()).replace("%receiver%", owner.getName())));
        }
    }

    private Block getBarrelBlock(InventoryCloseEvent event) {
        return Objects.requireNonNull(event.getInventory().getLocation()).getBlock();
    }
}

