/*
 * Decompiled with CFR 0.152.
 */
package io.shantek.listeners;

import io.shantek.PostOffice;
import java.util.Objects;
import org.bukkit.ChatColor;
import org.bukkit.block.Barrel;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;

public class InventoryOpen
implements Listener {
    public PostOffice postOffice;

    public InventoryOpen(PostOffice postOffice) {
        this.postOffice = postOffice;
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        Barrel barrel;
        Inventory inventory = event.getInventory();
        Player player = (Player)event.getPlayer();
        if (inventory.getType() != InventoryType.BARREL || inventory.getLocation() == null) {
            return;
        }
        Block clickedBlock = Objects.requireNonNull(inventory.getLocation()).getBlock();
        BlockState blockState = clickedBlock.getState();
        if (blockState instanceof Barrel && (barrel = (Barrel)blockState).getCustomName() != null && barrel.getCustomName().equalsIgnoreCase(this.postOffice.customBarrelName)) {
            if (player.hasPermission("shantek.postoffice.use")) {
                this.postOffice.previousItemCount = this.postOffice.helpers.countNonNullItems(inventory.getContents());
            } else {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.userBanned));
                event.setCancelled(true);
                if (this.postOffice.debugLogs) {
                    this.postOffice.getLogger().severe("Player " + player.getName() + " (" + player.getUniqueId() + ") tried to use a post box but doesn't have the use permission/is banned.");
                }
            }
        }
    }
}

