/*
 * Decompiled with CFR 0.152.
 */
package io.shantek.listeners;

import io.shantek.PostOffice;
import io.shantek.functions.UpdateChecker;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class PlayerJoin
implements Listener {
    public PostOffice postOffice;

    public PlayerJoin(PostOffice postOffice) {
        this.postOffice = postOffice;
    }

    @EventHandler
    public void onPlayerLogin(PlayerJoinEvent event) {
        String remoteVersion;
        String currentVersion;
        Player player = event.getPlayer();
        if (this.postOffice.playersWithMail.contains(player.getUniqueId().toString())) {
            long messageDelay = 20L;
            if (this.postOffice.gotMailDelay) {
                messageDelay = 200L;
            }
            Bukkit.getScheduler().runTaskLater((Plugin)this.postOffice, () -> player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.postOffice.language.gotMailMessage)), messageDelay);
            if (this.postOffice.debugLogs) {
                this.postOffice.getLogger().severe("Sent mail notification to player " + player.getName() + " (" + player.getUniqueId() + ")");
            }
        }
        if (this.postOffice.updateNotificationEnabled && (player.isOp() || player.hasPermission("shantek.postoffice.updatenotification")) && UpdateChecker.isNewVersionAvailable(currentVersion = this.postOffice.getDescription().getVersion(), remoteVersion = UpdateChecker.remoteVersion)) {
            player.sendMessage("[Post Office] An update is available! New version: " + remoteVersion);
        }
    }
}

