/*
 * Decompiled with CFR 0.152.
 */
package net.createteleporters.procedures;

import net.createteleporters.init.CreateteleportersModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class CustomPortalBaseBlockAddedProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, BlockState blockstate) {
        BlockPos offset2;
        BlockPos offset1;
        boolean eastWest;
        BlockPos basePos = BlockPos.containing((double)x, (double)y, (double)z);
        Direction facing = CustomPortalBaseBlockAddedProcedure.getDirectionFromBlockState(blockstate);
        if (!world.isClientSide()) {
            BlockEntity be = world.getBlockEntity(basePos);
            BlockState bs = world.getBlockState(basePos);
            if (be != null) {
                be.getPersistentData().putString("rotation", facing.getName());
            }
            if (world instanceof Level) {
                Level level = (Level)world;
                level.sendBlockUpdated(basePos, bs, bs, 3);
            }
        }
        boolean bl = eastWest = facing == Direction.EAST || facing == Direction.WEST;
        if (eastWest) {
            offset1 = basePos.offset(0, 0, 1);
            offset2 = basePos.offset(0, 0, -1);
        } else {
            offset1 = basePos.offset(1, 0, 0);
            offset2 = basePos.offset(-1, 0, 0);
        }
        if (!CustomPortalBaseBlockAddedProcedure.canReplace(world, offset1) || !CustomPortalBaseBlockAddedProcedure.canReplace(world, offset2)) {
            Block.dropResources((BlockState)blockstate, (Level)((Level)world), (BlockPos)basePos);
            world.destroyBlock(basePos, false);
            return;
        }
        world.setBlock(offset1, ((Block)CreateteleportersModBlocks.CUSTOM_PORTAL_BASE_DUMMY_BLOCK.get()).defaultBlockState(), 3);
        world.setBlock(offset2, ((Block)CreateteleportersModBlocks.CUSTOM_PORTAL_BASE_DUMMY_BLOCK.get()).defaultBlockState(), 3);
        CustomPortalBaseBlockAddedProcedure.setMainData(world, offset1, x, y, z);
        CustomPortalBaseBlockAddedProcedure.setMainData(world, offset2, x, y, z);
    }

    private static boolean canReplace(LevelAccessor world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        return state.canBeReplaced() || state.isAir();
    }

    private static void setMainData(LevelAccessor world, BlockPos pos, double x, double y, double z) {
        if (!world.isClientSide()) {
            BlockEntity be = world.getBlockEntity(pos);
            BlockState bs = world.getBlockState(pos);
            if (be != null) {
                be.getPersistentData().putDouble("main_x", x);
                be.getPersistentData().putDouble("main_y", y);
                be.getPersistentData().putDouble("main_z", z);
            }
            if (world instanceof Level) {
                Level level = (Level)world;
                level.sendBlockUpdated(pos, bs, bs, 3);
            }
        }
    }

    private static Direction getDirectionFromBlockState(BlockState blockState) {
        EnumProperty ep;
        Property prop = blockState.getBlock().getStateDefinition().getProperty("facing");
        if (prop instanceof DirectionProperty) {
            DirectionProperty dp = (DirectionProperty)prop;
            return (Direction)blockState.getValue((Property)dp);
        }
        prop = blockState.getBlock().getStateDefinition().getProperty("axis");
        return prop instanceof EnumProperty && (ep = (EnumProperty)prop).getPossibleValues().toArray()[0] instanceof Direction.Axis ? Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)blockState.getValue((Property)ep)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE) : Direction.NORTH;
    }
}

