/*
 * Decompiled with CFR 0.152.
 */
package net.createteleporters.procedures;

import net.createteleporters.block.BlockTeleporterBlock;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;

public class HelixSpawnProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, BlockState blockstate) {
        double height = 2.0;
        double radius = 0.75;
        int turns = 4;
        double speed = 0.015;
        float r = 0.9f;
        float g = 0.1f;
        float b = 0.1f;
        float scale = 1.0f;
        DustParticleOptions particle = new DustParticleOptions(new Vector3f(r, g, b), scale);
        if (world instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)world;
            long gameTime = level.getGameTime();
            double time = (double)(gameTime % (long)((int)(height / speed))) * speed;
            double centerX = x + 0.5;
            double centerY = y + 0.5;
            double centerZ = z + 0.5;
            Direction dir = (Direction)blockstate.getValue((Property)BlockTeleporterBlock.FACING);
            double dx = dir.getStepX();
            double dy = dir.getStepY();
            double dz = dir.getStepZ();
            double angle1 = time / height * (double)turns * 2.0 * Math.PI;
            double px1 = centerX + dx * time + Math.cos(angle1) * radius;
            double py1 = centerY + dy * time + Math.sin(angle1) * radius;
            double pz1 = centerZ + dz * time;
            double angle2 = angle1 + Math.PI;
            double px2 = centerX + dx * time + Math.cos(angle2) * radius;
            double py2 = centerY + dy * time + Math.sin(angle2) * radius;
            double pz2 = centerZ + dz * time;
            level.sendParticles((ParticleOptions)particle, px1, py1, pz1, 1, 0.0, 0.0, 0.0, 0.0);
            level.sendParticles((ParticleOptions)particle, px2, py2, pz2, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

