/*
 * Decompiled with CFR 0.152.
 */
package lee.fnafmod.fabric.network;

import java.util.Optional;
import lee.fnafmod.network.NetworkHandler;
import lee.fnafmod.network.SpawnMobPacket;
import lee.fnafmod.util.ArmorRandomizer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_5819;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public class FabricNetworkHandler
implements NetworkHandler {
    public static final class_8710.class_9154<SpawnMobPayload> SPAWN_MOB_TYPE = new class_8710.class_9154(class_2960.method_60655((String)"fnafmod", (String)"spawn_mob"));

    public FabricNetworkHandler() {
        PayloadTypeRegistry.playC2S().register(SPAWN_MOB_TYPE, SpawnMobPayload.STREAM_CODEC);
        ServerPlayNetworking.registerGlobalReceiver(SPAWN_MOB_TYPE, (payload, context) -> SpawnMobPayload.handle(payload, context.player()));
    }

    @Override
    public void sendSpawnMobPacket(class_2960 mobId, String spawnName, int offX, int offY, int offZ, String[] armor) {
        SpawnMobPayload payload = new SpawnMobPayload(new SpawnMobPacket(mobId, spawnName, offX, offY, offZ, armor));
        ClientPlayNetworking.send((class_8710)payload);
    }

    public record SpawnMobPayload(SpawnMobPacket packet) implements class_8710
    {
        public static final class_9139<class_2540, SpawnMobPayload> STREAM_CODEC = class_9139.method_56437(SpawnMobPayload::write, SpawnMobPayload::read);

        public static void write(class_2540 buf, SpawnMobPayload payload) {
            SpawnMobPacket packet = payload.packet;
            buf.method_10812(packet.mobId());
            buf.method_52964(packet.spawnName() != null);
            if (packet.spawnName() != null) {
                buf.method_10814(packet.spawnName());
            }
            buf.method_53002(packet.offX());
            buf.method_53002(packet.offY());
            buf.method_53002(packet.offZ());
            for (int i = 0; i < 4; ++i) {
                String s = packet.armor() != null && i < packet.armor().length ? packet.armor()[i] : null;
                buf.method_52964(s != null);
                if (s == null) continue;
                buf.method_10814(s);
            }
        }

        public static SpawnMobPayload read(class_2540 buf) {
            class_2960 id = buf.method_10810();
            String spawnName = buf.readBoolean() ? buf.method_10800(Short.MAX_VALUE) : null;
            int x = buf.readInt();
            int y = buf.readInt();
            int z = buf.readInt();
            String[] armor = new String[4];
            for (int i = 0; i < 4; ++i) {
                boolean present = buf.readBoolean();
                armor[i] = present ? buf.method_10800(Short.MAX_VALUE) : null;
            }
            return new SpawnMobPayload(new SpawnMobPacket(id, spawnName, x, y, z, armor));
        }

        public static void handle(SpawnMobPayload payload, class_3222 sender) {
            if (sender == null) {
                return;
            }
            SpawnMobPacket msg = payload.packet;
            class_3218 level = sender.method_51469();
            if (level.method_8608() || !(level instanceof class_3218)) {
                return;
            }
            class_3218 serverLevel = level;
            MinecraftServer server = level.method_8503();
            server.execute(() -> SpawnMobPayload.lambda$handle$1((class_1937)level, msg, sender, serverLevel));
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return SPAWN_MOB_TYPE;
        }

        private static /* synthetic */ void lambda$handle$1(class_1937 level, SpawnMobPacket msg, class_3222 sender, class_3218 serverLevel) {
            class_2378 entityTypeRegistry = level.method_30349().method_30530(class_7924.field_41266);
            Optional entityTypeOpt = entityTypeRegistry.method_17966(msg.mobId());
            class_243 spawnPos = new class_243(sender.method_23317() + (double)msg.offX(), sender.method_23318() + (double)msg.offY(), sender.method_23321() + (double)msg.offZ());
            entityTypeOpt.ifPresent(type -> {
                class_2338 spawnBlockPos = class_2338.method_49638((class_2374)spawnPos);
                class_1297 e = type.method_5894(serverLevel, null, null, spawnBlockPos, class_3730.field_16462, true, false);
                if (e instanceof class_1308) {
                    class_1308 mob = (class_1308)e;
                    mob.method_36456(sender.method_36454());
                    mob.method_36457(sender.method_36455());
                    if (msg.spawnName() != null) {
                        mob.method_5665((class_2561)class_2561.method_43470((String)msg.spawnName()));
                        mob.method_5880(true);
                    }
                    class_1304[] slots = new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166};
                    class_5819 rnd = mob.method_59922();
                    if (msg.armor() == null) {
                        ArmorRandomizer.equipRandomArmor(mob, rnd, false);
                    } else {
                        for (int i = 0; i < 4; ++i) {
                            String id;
                            String string = id = msg.armor().length > i ? msg.armor()[i] : null;
                            if (id == null) continue;
                            if ("random".equalsIgnoreCase(id)) {
                                class_1792 item = ArmorRandomizer.pickArmorForSlot(rnd, slots[i]);
                                if (item == class_1802.field_8162) continue;
                                mob.method_5673(slots[i], new class_1799((class_1935)item));
                                continue;
                            }
                            class_2378 itemRegistry = level.method_30349().method_30530(class_7924.field_41197);
                            class_1792 item = itemRegistry.method_17966(class_2960.method_12829((String)id)).orElse(class_1802.field_8162);
                            if (item == class_1802.field_8162) continue;
                            mob.method_5673(slots[i], new class_1799((class_1935)item));
                        }
                    }
                }
            });
        }
    }
}

