/*
 * Decompiled with CFR 0.152.
 */
package net.lee.fnafmod.client;

import net.lee.fnafmod.client.JumpscareManager;
import net.lee.fnafmod.client.Keybinds;
import net.lee.fnafmod.client.overlay.JumpscareOverlay;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="fnafmod", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEvents {
    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(ClientEvents::onClientTickEnd);
        MinecraftForge.EVENT_BUS.addListener(ClientEvents::onScreenRenderPost);
        MinecraftForge.EVENT_BUS.addListener(ClientEvents::onKeyInput);
    }

    @SubscribeEvent
    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent e) {
        Keybinds.register(e);
    }

    @SubscribeEvent
    public static void onRegisterGuiOverlays(RegisterGuiOverlaysEvent e) {
        e.registerAboveAll("jumpscare", (IGuiOverlay)new JumpscareOverlay());
    }

    public static void onClientTickEnd(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            if (Keybinds.TEST_SCARE.m_90859_()) {
                JumpscareManager.get().triggerRandom();
            }
            JumpscareManager.get().tick();
        }
    }

    public static void onKeyInput(InputEvent.Key e) {
        if (e.getAction() == 1 && Keybinds.TEST_SCARE.m_90832_(e.getKey(), e.getScanCode()) && !JumpscareManager.get().isActive()) {
            JumpscareManager.get().triggerRandom();
        }
    }

    public static void onScreenRenderPost(ScreenEvent.Render.Post e) {
        JumpscareManager.get().render(e.getGuiGraphics());
    }
}

