/*
 * Decompiled with CFR 0.152.
 */
package net.lee.fnafmod.client;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.lee.fnafmod.client.Jumpscare;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.sounds.SoundEvent;

public class JumpscareManager {
    private static final JumpscareManager INSTANCE = new JumpscareManager();
    private long lastTriggerNs = 0L;
    private static final long MIN_RETRIGGER_NS = 250000000L;
    private static final double CHECK_MIN_SECONDS = 60.0;
    private static final double CHECK_MAX_SECONDS = 120.0;
    private static final double BASE_TRIGGER_CHANCE = 0.3;
    private static final double IDLE_MULTIPLIER = 1.6;
    private static final double MAX_CHANCE_CLAMP = 0.85;
    private static final double MIN_COOLDOWN_SECONDS = 10.0;
    private long nextCheckAtNanos = -1L;
    private final Random rng = new Random();
    private final List<Jumpscare> catalog = new ArrayList<Jumpscare>();
    private final List<Jumpscare> unusedPool = new ArrayList<Jumpscare>();
    private Jumpscare active = null;
    private long startNanos = 0L;
    private boolean soundPlayed = false;
    private long nextTriggerAtNanos = -1L;
    private static final int HOLD_LAST_MS = 140;

    public static JumpscareManager get() {
        return INSTANCE;
    }

    public boolean isActive() {
        return this.active != null;
    }

    private JumpscareManager() {
        this.loadCatalog();
        if (this.nextTriggerAtNanos < 0L) {
            this.scheduleNextCheckFromNow();
        }
    }

    private long nowNs() {
        return System.nanoTime();
    }

    private long randomDelayNs(double minSec, double maxSec) {
        double span = Math.max(0.0, maxSec - minSec);
        double sec = minSec + this.rng.nextDouble() * span;
        return (long)(sec * 1.0E9);
    }

    private void scheduleNextCheckFromNow() {
        this.nextCheckAtNanos = this.nowNs() + this.randomDelayNs(60.0, 120.0);
    }

    private boolean isIdleContext() {
        return Minecraft.m_91087_().f_91080_ != null;
    }

    private double currentTriggerChance() {
        double chance = 0.3;
        if (this.isIdleContext()) {
            chance *= 1.6;
        }
        return Math.min(chance, 0.85);
    }

    private void loadCatalog() {
        try {
            ResourceLocation manifest = ResourceLocation.parse((String)"fnafmod:jumpscares/jumpscares.json");
            Optional res = Minecraft.m_91087_().m_91098_().m_213713_(manifest);
            if (res.isEmpty()) {
                return;
            }
            JsonObject root = (JsonObject)new Gson().fromJson((Reader)new InputStreamReader(((Resource)res.get()).m_215507_(), StandardCharsets.UTF_8), JsonObject.class);
            JsonArray arr = root.getAsJsonArray("entries");
            for (int i = 0; i < arr.size(); ++i) {
                JsonObject e = arr.get(i).getAsJsonObject();
                String id = e.get("id").getAsString();
                String folder = e.get("folder").getAsString();
                String pattern = e.get("pattern").getAsString();
                int frameCount = e.get("frameCount").getAsInt();
                int fps = e.get("fps").getAsInt();
                String sound = e.get("sound").getAsString();
                ResourceLocation[] frames = new ResourceLocation[frameCount];
                for (int f = 0; f < frameCount; ++f) {
                    String file = String.format(pattern, f + 1);
                    frames[f] = ResourceLocation.parse((String)(folder + file));
                }
                this.catalog.add(new Jumpscare(id, frames, fps, ResourceLocation.parse((String)sound)));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void triggerRandom() {
        if (this.active != null) {
            return;
        }
        long now = System.nanoTime();
        if (now - this.lastTriggerNs < 250000000L) {
            return;
        }
        if (this.unusedPool.isEmpty()) {
            this.unusedPool.addAll(this.catalog);
            Collections.shuffle(this.unusedPool, this.rng);
        }
        Jumpscare next = this.unusedPool.remove(0);
        this.trigger(next);
        this.lastTriggerNs = now;
    }

    public void trigger(Jumpscare js) {
        if (this.active != null) {
            return;
        }
        this.active = js;
        this.startNanos = System.nanoTime();
        Minecraft mc = Minecraft.m_91087_();
        SoundEvent se = SoundEvent.m_262824_((ResourceLocation)js.soundKey);
        mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)se, (float)1.0f));
    }

    public void tick() {
        if (this.active != null) {
            return;
        }
        long now = this.nowNs();
        if (this.nextCheckAtNanos > 0L && now >= this.nextCheckAtNanos && !this.catalog.isEmpty()) {
            double p = this.currentTriggerChance();
            if (this.rng.nextDouble() < p) {
                this.triggerRandom();
                this.nextCheckAtNanos = now + 10000000000L;
            } else {
                this.scheduleNextCheckFromNow();
            }
        }
    }

    private int currentFrameIndex(Jumpscare js) {
        long elapsedNs = System.nanoTime() - this.startNanos;
        double t = (double)elapsedNs / 1.0E9;
        int idx = (int)Math.floor(t * (double)js.fps);
        return Math.min(idx, js.frames.length - 1);
    }

    public void render(GuiGraphics g) {
        if (this.active == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        int sw = mc.m_91268_().m_85445_();
        int sh = mc.m_91268_().m_85446_();
        if (!this.soundPlayed) {
            SoundEvent se = SoundEvent.m_262824_((ResourceLocation)this.active.soundKey);
            mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)se, (float)1.0f));
            this.soundPlayed = true;
        }
        int idx = this.currentFrameIndex(this.active);
        ResourceLocation frame = this.active.frames[idx];
        g.m_280163_(frame, 0, 0, 0.0f, 0.0f, sw, sh, sw, sh);
        double duration = (double)this.active.frames.length / (double)this.active.fps;
        duration += 0.14;
        double elapsed = (double)(System.nanoTime() - this.startNanos) / 1.0E9;
        if (elapsed > duration) {
            this.active = null;
            long soonest = this.nowNs() + 10000000000L;
            if (this.nextCheckAtNanos < soonest) {
                this.nextCheckAtNanos = soonest;
            }
        }
    }

    public void resetCycle() {
        this.unusedPool.clear();
        this.scheduleNextCheckFromNow();
    }
}

