/*
 * Decompiled with CFR 0.152.
 */
package lee.fnafmod.client;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import lee.fnafmod.client.Jumpscare;
import lee.fnafmod.network.NetworkHandler;
import net.minecraft.class_1011;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import org.joml.Matrix3x2fStack;

public class JumpscareManager {
    private static final long MIN_RETRIGGER_NS = 250000000L;
    private static final double CHECK_MIN_SECONDS = 300.0;
    private static final double CHECK_MAX_SECONDS = 600.0;
    private static final double BASE_TRIGGER_CHANCE = 0.35;
    private static final double IDLE_MULTIPLIER = 0.8;
    private static final double MAX_CHANCE_CLAMP = 0.85;
    private static final double MIN_COOLDOWN_SECONDS = 60.0;
    private static final int HOLD_LAST_SECS = 0;
    private static final double MAX_FALLBACK_AUDIO_SECS = 12.0;
    private static final Gson GSON = new Gson();
    private static final Map<class_2960, int[]> TEX_SIZE_CACHE = new ConcurrentHashMap<class_2960, int[]>();
    private static final Map<class_2960, class_3414> SOUND_CACHE = new ConcurrentHashMap<class_2960, class_3414>();
    private static final JumpscareManager INSTANCE = new JumpscareManager();
    private final Random rng = new Random();
    private final List<Jumpscare> catalog = new ArrayList<Jumpscare>();
    private final List<Jumpscare> unusedPool = new ArrayList<Jumpscare>();
    private long lastTriggerNs = 0L;
    private long nextCheckAtNanos = -1L;
    private Jumpscare active = null;
    private long startNanos = 0L;
    private class_1109 playingSound = null;

    private JumpscareManager() {
        this.loadCatalog();
        this.scheduleNextCheckFromNow();
    }

    private static boolean resourceExists(class_2960 rl) {
        return class_310.method_1551().method_1478().method_14486(rl).isPresent();
    }

    private static class_2960 toggleTexturesPrefix(class_2960 rl) {
        String p = rl.method_12832();
        if (p.startsWith("textures/")) {
            return class_2960.method_60655((String)rl.method_12836(), (String)p.substring("textures/".length()));
        }
        return class_2960.method_60655((String)rl.method_12836(), (String)("textures/" + p));
    }

    private static class_2960 validateAndCorrectTexturePath(class_2960 rl) {
        if (JumpscareManager.resourceExists(rl)) {
            return rl;
        }
        class_2960 alt = JumpscareManager.toggleTexturesPrefix(rl);
        if (JumpscareManager.resourceExists(alt)) {
            return alt;
        }
        return rl;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static int[] getTextureSize(class_2960 id) {
        block15: {
            int[] cached = TEX_SIZE_CACHE.get(id);
            if (cached != null) {
                return cached;
            }
            try {
                class_3300 rm = class_310.method_1551().method_1478();
                Optional opt = rm.method_14486(id);
                if (!opt.isPresent()) break block15;
                try (InputStream in = ((class_3298)opt.get()).method_14482();){
                    int[] nArray;
                    block16: {
                        class_1011 img = class_1011.method_4309((InputStream)in);
                        try {
                            int[] dims = new int[]{img.method_4307(), img.method_4323()};
                            TEX_SIZE_CACHE.put(id, dims);
                            nArray = dims;
                            if (img == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (img != null) {
                                try {
                                    img.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        img.close();
                    }
                    return nArray;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new int[]{256, 256};
    }

    public static JumpscareManager get() {
        return INSTANCE;
    }

    public boolean isActive() {
        return this.active != null;
    }

    private long nowNs() {
        return System.nanoTime();
    }

    private long randomDelayNs(double minSec, double maxSec) {
        double span = Math.max(0.0, maxSec - minSec);
        double sec = minSec + this.rng.nextDouble() * span;
        return (long)(sec * 1.0E9);
    }

    private void scheduleNextCheckFromNow() {
        this.nextCheckAtNanos = this.nowNs() + this.randomDelayNs(300.0, 600.0);
    }

    private boolean isIdleContext(class_310 mc) {
        return mc.field_1755 != null;
    }

    private double currentTriggerChance(class_310 mc) {
        double chance = 0.35;
        if (this.isIdleContext(mc)) {
            chance *= 0.8;
        }
        return Math.min(chance, 0.85);
    }

    private void loadCatalog() {
        try {
            class_2960 manifest = class_2960.method_12829((String)"fnafmod:jumpscares/jumpscares.json");
            if (manifest == null) {
                return;
            }
            Optional res = class_310.method_1551().method_1478().method_14486(manifest);
            if (res.isEmpty()) {
                return;
            }
            JsonObject root = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(((class_3298)res.get()).method_14482(), StandardCharsets.UTF_8), JsonObject.class);
            JsonArray arr = root.getAsJsonArray("entries");
            for (int i = 0; i < arr.size(); ++i) {
                class_2960 base;
                Object basePath;
                JsonArray off;
                JsonObject e = arr.get(i).getAsJsonObject();
                String id = e.get("id").getAsString();
                String folder = e.get("folder").getAsString();
                String pattern = e.get("pattern").getAsString();
                int frameCount = e.get("frameCount").getAsInt();
                int fps = e.get("fps").getAsInt();
                String sound = e.get("sound").getAsString();
                String anchor = e.has("anchor") ? e.get("anchor").getAsString() : "fullscreen";
                double scale = e.has("scale") ? e.get("scale").getAsDouble() : 1.0;
                boolean loop = e.has("loop") && e.get("loop").getAsBoolean();
                boolean wantsSpawn = e.has("spawn_mob") || e.has("spawn") && e.get("spawn").getAsBoolean();
                class_2960 spawnMobId = null;
                String spawnName = null;
                int offX = 0;
                int offY = 0;
                int offZ = 0;
                String[] armor = null;
                if (wantsSpawn && e.has("spawn_mob")) {
                    spawnMobId = class_2960.method_12829((String)e.get("spawn_mob").getAsString());
                }
                if (wantsSpawn && e.has("spawn_name") && (spawnName = e.get("spawn_name").getAsString()) != null && spawnName.isBlank()) {
                    spawnName = null;
                }
                if (wantsSpawn && e.has("spawn_offset") && (off = e.getAsJsonArray("spawn_offset")).size() >= 3) {
                    offX = off.get(0).getAsInt();
                    offY = off.get(1).getAsInt();
                    offZ = off.get(2).getAsInt();
                }
                if (wantsSpawn && e.has("armor")) {
                    JsonArray armorArray = e.getAsJsonArray("armor");
                    armor = new String[armorArray.size()];
                    for (int j = 0; j < armorArray.size(); ++j) {
                        armor[j] = armorArray.get(j).getAsString();
                    }
                }
                if (!((String)(basePath = (base = class_2960.method_60654((String)folder)).method_12832())).endsWith("/")) {
                    basePath = (String)basePath + "/";
                }
                class_2960[] frames = new class_2960[frameCount];
                for (int f = 0; f < frameCount; ++f) {
                    class_2960 rl;
                    String file = String.format(pattern, f + 1);
                    frames[f] = rl = class_2960.method_60655((String)base.method_12836(), (String)((String)basePath + file));
                }
                class_2960 soundLoc = class_2960.method_12829((String)sound);
                this.catalog.add(new Jumpscare(id, frames, fps, soundLoc, loop, anchor, scale, spawnMobId, spawnName, offX, offY, offZ, armor));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void triggerRandom() {
        if (this.active != null) {
            return;
        }
        long now = this.nowNs();
        if (now - this.lastTriggerNs < 250000000L) {
            return;
        }
        if (this.unusedPool.isEmpty() && !this.catalog.isEmpty()) {
            this.unusedPool.addAll(this.catalog);
            Collections.shuffle(this.unusedPool, this.rng);
        }
        if (this.unusedPool.isEmpty()) {
            return;
        }
        Jumpscare next = this.unusedPool.remove(0);
        this.trigger(next);
        this.lastTriggerNs = now;
    }

    public void trigger(Jumpscare js) {
        if (this.active != null) {
            return;
        }
        this.active = js;
        this.startNanos = this.nowNs();
        class_310 mc = class_310.method_1551();
        class_3414 se = SOUND_CACHE.computeIfAbsent(js.soundKey(), class_3414::method_47908);
        this.playingSound = class_1109.method_4758((class_3414)se, (float)1.0f);
        mc.method_1483().method_4873((class_1113)this.playingSound);
        this.nextCheckAtNanos = this.nowNs() + 60000000000L;
    }

    public void tick() {
        if (this.active != null) {
            return;
        }
        long now = this.nowNs();
        class_310 mc = class_310.method_1551();
        if (this.nextCheckAtNanos > 0L && now >= this.nextCheckAtNanos && !this.catalog.isEmpty()) {
            double p = this.currentTriggerChance(mc);
            if (this.rng.nextDouble() < p) {
                this.triggerRandom();
                this.nextCheckAtNanos = now + 60000000000L;
            } else {
                this.scheduleNextCheckFromNow();
            }
        }
    }

    public void render(class_332 g) {
        boolean finish;
        int idx;
        if (this.active == null) {
            return;
        }
        class_310 mc = class_310.method_1551();
        double elapsed = (double)(this.nowNs() - this.startNanos) / 1.0E9;
        double frameDur = 1.0 / (double)Math.max(1, this.active.fps());
        if (this.active.loop()) {
            idx = (int)Math.floor(elapsed / frameDur) % this.active.frames().length;
        } else {
            double totalAnim = (double)this.active.frames().length * frameDur + 0.0;
            double t = Math.min(elapsed, totalAnim);
            idx = (int)Math.min((double)(this.active.frames().length - 1), Math.floor(t / frameDur));
        }
        class_2960 frame = this.active.frames()[idx];
        class_2960 validated = JumpscareManager.validateAndCorrectTexturePath(frame);
        if (validated != frame) {
            this.active.frames()[idx] = validated;
            frame = validated;
        }
        int sw = mc.method_22683().method_4486();
        int sh = mc.method_22683().method_4502();
        try {
            if ("fnafmod:xor".equalsIgnoreCase(this.active.id())) {
                dims = JumpscareManager.getTextureSize(frame);
                texW = dims[0];
                texH = dims[1];
                int drawH = (int)Math.max(16.0, (double)sh * this.active.scale());
                int drawW = Math.max(16, (int)Math.round((double)drawH * ((double)texW / (double)texH)));
                double freqHz = 8.0;
                double t = elapsed;
                double factor = (Math.sin(t * Math.PI * 2.0 * freqHz) + 1.0) * 0.5;
                int x = (int)Math.round(factor * (double)Math.max(0, sw - drawW));
                int pad = 6;
                int y = sh - drawH - pad;
                this.blitTexture(g, frame, x, y, drawW, drawH, texW, texH);
            } else if ("bottom_left".equalsIgnoreCase(this.active.anchor())) {
                int pad;
                dims = JumpscareManager.getTextureSize(frame);
                texW = dims[0];
                texH = dims[1];
                int drawH = (int)Math.max(16.0, (double)sh * this.active.scale());
                int drawW = Math.max(16, (int)Math.round((double)drawH * ((double)texW / (double)texH)));
                int x = pad = 6;
                int y = sh - drawH - pad;
                this.blitTexture(g, frame, x, y, drawW, drawH, texW, texH);
            } else {
                this.blitTexture(g, frame, 0, 0, sw, sh, JumpscareManager.getTextureSize(frame)[0], JumpscareManager.getTextureSize(frame)[1]);
            }
        }
        catch (Exception dims) {
            // empty catch block
        }
        if (this.active.loop()) {
            boolean soundActive = this.playingSound != null && mc.method_1483().method_4877((class_1113)this.playingSound);
            boolean overFallback = elapsed > 12.0;
            finish = !soundActive || overFallback;
        } else {
            double endAt = (double)this.active.frames().length * frameDur + 0.0;
            boolean bl = finish = elapsed > endAt;
        }
        if (finish) {
            Jumpscare finished = this.active;
            this.active = null;
            this.playingSound = null;
            long soonest = this.nowNs() + 60000000000L;
            if (this.nextCheckAtNanos < soonest) {
                this.nextCheckAtNanos = soonest;
            }
            if (finished != null && finished.spawnMobId() != null && mc.field_1724 != null && mc.field_1687 != null && mc.field_1755 == null) {
                NetworkHandler.getInstance().sendSpawnMobPacket(finished.spawnMobId(), finished.spawnName(), finished.spawnOffX(), finished.spawnOffY(), finished.spawnOffZ(), finished.armor());
            }
        }
    }

    private void blitTexture(class_332 graphics, class_2960 texture, int x, int y, int width, int height, int texWidth, int texHeight) {
        Matrix3x2fStack pose = graphics.method_51448();
        pose.pushMatrix();
        pose.translate((float)x, (float)y);
        float scaleX = (float)width / (float)texWidth;
        float scaleY = (float)height / (float)texHeight;
        pose.scale(scaleX, scaleY);
        graphics.method_70845(texture, 0, 0, texWidth, texHeight, 0.0f, 1.0f, 0.0f, 1.0f);
        pose.popMatrix();
    }
}

