/*
 * Decompiled with CFR 0.152.
 */
package net.lee.fnafmod.network;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public final class SpawnMobAfterScareC2S {
    private static final int MAX_UTF_LENGTH = Short.MAX_VALUE;
    private final String mobId;
    private final int offX;
    private final int offY;
    private final int offZ;

    public SpawnMobAfterScareC2S(String mobId, int offX, int offY, int offZ) {
        this.mobId = mobId;
        this.offX = offX;
        this.offY = offY;
        this.offZ = offZ;
    }

    public static void encode(SpawnMobAfterScareC2S msg, FriendlyByteBuf buf) {
        buf.m_130072_(msg.mobId, Short.MAX_VALUE);
        buf.m_130130_(msg.offX);
        buf.m_130130_(msg.offY);
        buf.m_130130_(msg.offZ);
    }

    public static SpawnMobAfterScareC2S decode(FriendlyByteBuf buf) {
        String id = buf.m_130136_(Short.MAX_VALUE);
        int x = buf.m_130242_();
        int y = buf.m_130242_();
        int z = buf.m_130242_();
        return new SpawnMobAfterScareC2S(id, x, y, z);
    }

    public static void handle(SpawnMobAfterScareC2S msg, Supplier<NetworkEvent.Context> ctxSup) {
        NetworkEvent.Context ctx = ctxSup.get();
        ServerPlayer sender = ctx.getSender();
        if (sender == null || !sender.m_6084_() || sender.m_5833_()) {
            ctx.setPacketHandled(true);
            return;
        }
        String mobId = msg.mobId;
        int offX = msg.offX;
        int offY = msg.offY;
        int offZ = msg.offZ;
        ctx.enqueueWork(() -> {
            ServerLevel level = sender.m_284548_();
            if (level == null || sender.m_5803_() || sender.f_8906_ == null) {
                return;
            }
            EntityType.m_20632_((String)mobId).ifPresent(type -> {
                Entity entity = type.m_20615_((Level)level);
                if (!(entity instanceof Mob)) {
                    return;
                }
                Mob mob = (Mob)entity;
                BlockPos pos = sender.m_20183_().m_7918_(offX, offY, offZ);
                mob.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, level.f_46441_.m_188501_() * 360.0f, 0.0f);
                level.m_7967_((Entity)mob);
            });
        });
        ctx.setPacketHandled(true);
    }
}

