/*
 * Decompiled with CFR 0.152.
 */
package lee.fnafmod.client;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import lee.fnafmod.client.Jumpscare;
import lee.fnafmod.network.NetworkHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.sounds.SoundEvent;
import org.joml.Matrix3x2fStack;

public class JumpscareManager {
    private static final long MIN_RETRIGGER_NS = 250000000L;
    private static final double CHECK_MIN_SECONDS = 60.0;
    private static final double CHECK_MAX_SECONDS = 120.0;
    private static final double BASE_TRIGGER_CHANCE = 0.5;
    private static final double IDLE_MULTIPLIER = 0.8;
    private static final double MAX_CHANCE_CLAMP = 0.85;
    private static final double MIN_COOLDOWN_SECONDS = 30.0;
    private static final int HOLD_LAST_SECS = 0;
    private static final double MAX_FALLBACK_AUDIO_SECS = 12.0;
    private static final Gson GSON = new Gson();
    private static final Map<ResourceLocation, int[]> TEX_SIZE_CACHE = new ConcurrentHashMap<ResourceLocation, int[]>();
    private static final Map<ResourceLocation, SoundEvent> SOUND_CACHE = new ConcurrentHashMap<ResourceLocation, SoundEvent>();
    private static final JumpscareManager INSTANCE = new JumpscareManager();
    private final Random rng = new Random();
    private final List<Jumpscare> catalog = new ArrayList<Jumpscare>();
    private final List<Jumpscare> unusedPool = new ArrayList<Jumpscare>();
    private long lastTriggerNs = 0L;
    private long nextCheckAtNanos = -1L;
    private Jumpscare active = null;
    private long startNanos = 0L;
    private SimpleSoundInstance playingSound = null;

    private JumpscareManager() {
        this.loadCatalog();
        this.scheduleNextCheckFromNow();
    }

    private static boolean resourceExists(ResourceLocation rl) {
        return Minecraft.getInstance().getResourceManager().getResource(rl).isPresent();
    }

    private static ResourceLocation toggleTexturesPrefix(ResourceLocation rl) {
        String p = rl.getPath();
        if (p.startsWith("textures/")) {
            return ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)p.substring("textures/".length()));
        }
        return ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)("textures/" + p));
    }

    private static ResourceLocation validateAndCorrectTexturePath(ResourceLocation rl) {
        if (JumpscareManager.resourceExists(rl)) {
            return rl;
        }
        ResourceLocation alt = JumpscareManager.toggleTexturesPrefix(rl);
        if (JumpscareManager.resourceExists(alt)) {
            return alt;
        }
        return rl;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static int[] getTextureSize(ResourceLocation id) {
        block15: {
            int[] cached = TEX_SIZE_CACHE.get(id);
            if (cached != null) {
                return cached;
            }
            try {
                ResourceManager rm = Minecraft.getInstance().getResourceManager();
                Optional opt = rm.getResource(id);
                if (!opt.isPresent()) break block15;
                try (InputStream in = ((Resource)opt.get()).open();){
                    int[] nArray;
                    block16: {
                        NativeImage img = NativeImage.read((InputStream)in);
                        try {
                            int[] dims = new int[]{img.getWidth(), img.getHeight()};
                            TEX_SIZE_CACHE.put(id, dims);
                            nArray = dims;
                            if (img == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (img != null) {
                                try {
                                    img.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        img.close();
                    }
                    return nArray;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new int[]{256, 256};
    }

    public static JumpscareManager get() {
        return INSTANCE;
    }

    public boolean isActive() {
        return this.active != null;
    }

    private long nowNs() {
        return System.nanoTime();
    }

    private long randomDelayNs(double minSec, double maxSec) {
        double span = Math.max(0.0, maxSec - minSec);
        double sec = minSec + this.rng.nextDouble() * span;
        return (long)(sec * 1.0E9);
    }

    private void scheduleNextCheckFromNow() {
        this.nextCheckAtNanos = this.nowNs() + this.randomDelayNs(60.0, 120.0);
    }

    private boolean isIdleContext(Minecraft mc) {
        return mc.screen != null;
    }

    private double currentTriggerChance(Minecraft mc) {
        double chance = 0.5;
        if (this.isIdleContext(mc)) {
            chance *= 0.8;
        }
        return Math.min(chance, 0.85);
    }

    private void loadCatalog() {
        try {
            ResourceLocation manifest = ResourceLocation.tryParse((String)"fnafmod:jumpscares/jumpscares.json");
            if (manifest == null) {
                return;
            }
            Optional res = Minecraft.getInstance().getResourceManager().getResource(manifest);
            if (res.isEmpty()) {
                return;
            }
            JsonObject root = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(((Resource)res.get()).open(), StandardCharsets.UTF_8), JsonObject.class);
            JsonArray arr = root.getAsJsonArray("entries");
            for (int i = 0; i < arr.size(); ++i) {
                ResourceLocation base;
                Object basePath;
                JsonArray off;
                JsonObject e = arr.get(i).getAsJsonObject();
                String id = e.get("id").getAsString();
                String folder = e.get("folder").getAsString();
                String pattern = e.get("pattern").getAsString();
                int frameCount = e.get("frameCount").getAsInt();
                int fps = e.get("fps").getAsInt();
                String sound = e.get("sound").getAsString();
                String anchor = e.has("anchor") ? e.get("anchor").getAsString() : "fullscreen";
                double scale = e.has("scale") ? e.get("scale").getAsDouble() : 1.0;
                boolean loop = e.has("loop") && e.get("loop").getAsBoolean();
                boolean wantsSpawn = e.has("spawn_mob") || e.has("spawn") && e.get("spawn").getAsBoolean();
                ResourceLocation spawnMobId = null;
                String spawnName = null;
                int offX = 0;
                int offY = 0;
                int offZ = 0;
                String[] armor = null;
                if (wantsSpawn && e.has("spawn_mob")) {
                    spawnMobId = ResourceLocation.tryParse((String)e.get("spawn_mob").getAsString());
                }
                if (wantsSpawn && e.has("spawn_name") && (spawnName = e.get("spawn_name").getAsString()) != null && spawnName.isBlank()) {
                    spawnName = null;
                }
                if (wantsSpawn && e.has("spawn_offset") && (off = e.getAsJsonArray("spawn_offset")).size() >= 3) {
                    offX = off.get(0).getAsInt();
                    offY = off.get(1).getAsInt();
                    offZ = off.get(2).getAsInt();
                }
                if (wantsSpawn && e.has("armor")) {
                    JsonArray armorArray = e.getAsJsonArray("armor");
                    armor = new String[armorArray.size()];
                    for (int j = 0; j < armorArray.size(); ++j) {
                        armor[j] = armorArray.get(j).getAsString();
                    }
                }
                if (!((String)(basePath = (base = ResourceLocation.parse((String)folder)).getPath())).endsWith("/")) {
                    basePath = (String)basePath + "/";
                }
                ResourceLocation[] frames = new ResourceLocation[frameCount];
                for (int f = 0; f < frameCount; ++f) {
                    ResourceLocation rl;
                    String file = String.format(pattern, f + 1);
                    frames[f] = rl = ResourceLocation.fromNamespaceAndPath((String)base.getNamespace(), (String)((String)basePath + file));
                }
                ResourceLocation soundLoc = ResourceLocation.tryParse((String)sound);
                this.catalog.add(new Jumpscare(id, frames, fps, soundLoc, loop, anchor, scale, spawnMobId, spawnName, offX, offY, offZ, armor));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void triggerRandom() {
        if (this.active != null) {
            return;
        }
        long now = this.nowNs();
        if (now - this.lastTriggerNs < 250000000L) {
            return;
        }
        if (this.unusedPool.isEmpty() && !this.catalog.isEmpty()) {
            this.unusedPool.addAll(this.catalog);
            Collections.shuffle(this.unusedPool, this.rng);
        }
        if (this.unusedPool.isEmpty()) {
            return;
        }
        Jumpscare next = this.unusedPool.remove(0);
        this.trigger(next);
        this.lastTriggerNs = now;
    }

    public void triggerFirst() {
        if (this.active != null) {
            return;
        }
        long now = this.nowNs();
        if (now - this.lastTriggerNs < 250000000L) {
            return;
        }
        if (this.catalog.isEmpty()) {
            return;
        }
        Jumpscare first = this.catalog.get(10);
        this.trigger(first);
        this.lastTriggerNs = now;
    }

    public void trigger(Jumpscare js) {
        if (this.active != null) {
            return;
        }
        this.active = js;
        this.startNanos = this.nowNs();
        Minecraft mc = Minecraft.getInstance();
        SoundEvent se = SOUND_CACHE.computeIfAbsent(js.soundKey(), SoundEvent::createVariableRangeEvent);
        this.playingSound = SimpleSoundInstance.forUI((SoundEvent)se, (float)1.0f);
        mc.getSoundManager().play((SoundInstance)this.playingSound);
    }

    public void tick() {
        if (this.active != null) {
            return;
        }
        long now = this.nowNs();
        Minecraft mc = Minecraft.getInstance();
        if (this.nextCheckAtNanos > 0L && now >= this.nextCheckAtNanos && !this.catalog.isEmpty()) {
            double p = this.currentTriggerChance(mc);
            if (this.rng.nextDouble() < p) {
                this.triggerRandom();
                this.nextCheckAtNanos = now + 30000000000L;
            } else {
                this.scheduleNextCheckFromNow();
            }
        }
    }

    public void render(GuiGraphics g) {
        boolean finish;
        int idx;
        if (this.active == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        double elapsed = (double)(this.nowNs() - this.startNanos) / 1.0E9;
        double frameDur = 1.0 / (double)Math.max(1, this.active.fps());
        if (this.active.loop()) {
            idx = (int)Math.floor(elapsed / frameDur) % this.active.frames().length;
        } else {
            double totalAnim = (double)this.active.frames().length * frameDur + 0.0;
            double t = Math.min(elapsed, totalAnim);
            idx = (int)Math.min((double)(this.active.frames().length - 1), Math.floor(t / frameDur));
        }
        ResourceLocation frame = this.active.frames()[idx];
        ResourceLocation validated = JumpscareManager.validateAndCorrectTexturePath(frame);
        if (validated != frame) {
            this.active.frames()[idx] = validated;
            frame = validated;
        }
        int sw = mc.getWindow().getGuiScaledWidth();
        int sh = mc.getWindow().getGuiScaledHeight();
        try {
            if ("fnafmod:xor".equalsIgnoreCase(this.active.id())) {
                dims = JumpscareManager.getTextureSize(frame);
                texW = dims[0];
                texH = dims[1];
                int drawH = (int)Math.max(16.0, (double)sh * this.active.scale());
                int drawW = Math.max(16, (int)Math.round((double)drawH * ((double)texW / (double)texH)));
                double freqHz = 8.0;
                double t = elapsed;
                double factor = (Math.sin(t * Math.PI * 2.0 * freqHz) + 1.0) * 0.5;
                int x = (int)Math.round(factor * (double)Math.max(0, sw - drawW));
                int pad = 6;
                int y = sh - drawH - pad;
                this.blitTexture(g, frame, x, y, drawW, drawH, texW, texH);
            } else if ("bottom_left".equalsIgnoreCase(this.active.anchor())) {
                int pad;
                dims = JumpscareManager.getTextureSize(frame);
                texW = dims[0];
                texH = dims[1];
                int drawH = (int)Math.max(16.0, (double)sh * this.active.scale());
                int drawW = Math.max(16, (int)Math.round((double)drawH * ((double)texW / (double)texH)));
                int x = pad = 6;
                int y = sh - drawH - pad;
                this.blitTexture(g, frame, x, y, drawW, drawH, texW, texH);
            } else {
                this.blitTexture(g, frame, 0, 0, sw, sh, JumpscareManager.getTextureSize(frame)[0], JumpscareManager.getTextureSize(frame)[1]);
            }
        }
        catch (Exception dims) {
            // empty catch block
        }
        if (this.active.loop()) {
            boolean soundActive = this.playingSound != null && mc.getSoundManager().isActive((SoundInstance)this.playingSound);
            boolean overFallback = elapsed > 12.0;
            finish = !soundActive || overFallback;
        } else {
            double endAt = (double)this.active.frames().length * frameDur + 0.0;
            boolean bl = finish = elapsed > endAt;
        }
        if (finish) {
            Jumpscare finished = this.active;
            this.active = null;
            this.playingSound = null;
            long soonest = this.nowNs() + 30000000000L;
            if (this.nextCheckAtNanos < soonest) {
                this.nextCheckAtNanos = soonest;
            }
            if (finished != null && finished.spawnMobId() != null && mc.player != null && mc.level != null && mc.screen == null) {
                NetworkHandler.getInstance().sendSpawnMobPacket(finished.spawnMobId(), finished.spawnName(), finished.spawnOffX(), finished.spawnOffY(), finished.spawnOffZ(), finished.armor());
            }
        }
    }

    private void blitTexture(GuiGraphics graphics, ResourceLocation texture, int x, int y, int width, int height, int texWidth, int texHeight) {
        Matrix3x2fStack pose = graphics.pose();
        pose.pushMatrix();
        pose.translate((float)x, (float)y);
        float scaleX = (float)width / (float)texWidth;
        float scaleY = (float)height / (float)texHeight;
        pose.scale(scaleX, scaleY);
        graphics.blit(texture, 0, 0, texWidth, texHeight, 0.0f, 1.0f, 0.0f, 1.0f);
        pose.popMatrix();
    }
}

