/*
 * Decompiled with CFR 0.152.
 */
package lee.fnafmod.neoforge.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Optional;
import lee.fnafmod.network.NetworkHandler;
import lee.fnafmod.network.SpawnMobPacket;
import lee.fnafmod.util.ArmorRandomizer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class NeoForgeNetworkHandler
implements NetworkHandler {
    public static final CustomPacketPayload.Type<SpawnMobPayload> SPAWN_MOB_TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"fnafmod", (String)"spawn_mob"));

    public static void register(PayloadRegistrar registrar) {
        registrar.playToServer(SPAWN_MOB_TYPE, SpawnMobPayload.STREAM_CODEC, SpawnMobPayload::handle);
    }

    @Override
    public void sendSpawnMobPacket(ResourceLocation mobId, String spawnName, int offX, int offY, int offZ, String[] armor) {
        SpawnMobPayload payload = new SpawnMobPayload(new SpawnMobPacket(mobId, spawnName, offX, offY, offZ, armor));
        ClientPacketDistributor.sendToServer((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public record SpawnMobPayload(SpawnMobPacket packet) implements CustomPacketPayload
    {
        public static final StreamCodec<ByteBuf, SpawnMobPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, p -> p.packet.mobId(), (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), p -> Optional.ofNullable(p.packet.spawnName()), (StreamCodec)ByteBufCodecs.INT, p -> p.packet.offX(), (StreamCodec)ByteBufCodecs.INT, p -> p.packet.offY(), (StreamCodec)ByteBufCodecs.INT, p -> p.packet.offZ(), (StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), (int)4), p -> {
            ArrayList list = new ArrayList();
            if (p.packet.armor() != null) {
                for (String s : p.packet.armor()) {
                    list.add(Optional.ofNullable(s));
                }
            }
            while (list.size() < 4) {
                list.add(Optional.empty());
            }
            return list;
        }, (mobId, spawnName, offX, offY, offZ, armor) -> {
            String[] armorArray = new String[4];
            for (int i = 0; i < 4 && i < armor.size(); ++i) {
                armorArray[i] = ((Optional)armor.get(i)).orElse(null);
            }
            return new SpawnMobPayload(new SpawnMobPacket((ResourceLocation)mobId, spawnName.orElse(null), (int)offX, (int)offY, (int)offZ, armorArray));
        });

        public static void handle(SpawnMobPayload payload, IPayloadContext context) {
            context.enqueueWork(() -> {
                Vec3 base;
                BlockPos spawnPos;
                ServerPlayer sender = (ServerPlayer)context.player();
                if (sender == null) {
                    return;
                }
                SpawnMobPacket msg = payload.packet;
                ServerLevel level = sender.level();
                Optional typeRefOpt = BuiltInRegistries.ENTITY_TYPE.get(msg.mobId());
                if (typeRefOpt.isEmpty()) {
                    return;
                }
                EntityType type = (EntityType)((Holder.Reference)typeRefOpt.get()).value();
                Entity spawned = type.spawn(level, spawnPos = BlockPos.containing((Position)(base = sender.position())).offset(msg.offX(), msg.offY(), msg.offZ()), EntitySpawnReason.TRIGGERED);
                if (spawned == null) {
                    return;
                }
                if (spawned instanceof Mob) {
                    Mob mob = (Mob)spawned;
                    mob.setYRot(sender.getYRot());
                    mob.setXRot(sender.getXRot());
                    if (msg.spawnName() != null) {
                        mob.setCustomName((Component)Component.literal((String)msg.spawnName()));
                        mob.setCustomNameVisible(true);
                    }
                    EquipmentSlot[] slots = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
                    RandomSource rnd = mob.getRandom();
                    if (msg.armor() == null) {
                        ArmorRandomizer.equipRandomArmor(mob, rnd, false);
                    } else {
                        for (int i = 0; i < 4; ++i) {
                            Optional itemRefOpt;
                            Item item;
                            String id;
                            String string = id = msg.armor().length > i ? msg.armor()[i] : null;
                            if (id == null) continue;
                            if ("random".equalsIgnoreCase(id)) {
                                Item randomItem = ArmorRandomizer.pickArmorForSlot(rnd, slots[i]);
                                if (randomItem == Items.AIR) continue;
                                mob.setItemSlot(slots[i], new ItemStack((ItemLike)randomItem));
                                continue;
                            }
                            ResourceLocation itemId = ResourceLocation.tryParse((String)id);
                            if (itemId == null || (item = (itemRefOpt = BuiltInRegistries.ITEM.get(itemId)).map(Holder::value).orElse(Items.AIR)) == Items.AIR) continue;
                            mob.setItemSlot(slots[i], new ItemStack((ItemLike)item));
                        }
                    }
                }
            });
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return SPAWN_MOB_TYPE;
        }
    }
}

