/*
 * Decompiled with CFR 0.152.
 */
package net.lee.fnafmod.client;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.lee.fnafmod.client.Jumpscare;
import net.lee.fnafmod.network.FnafNet;
import net.lee.fnafmod.network.SpawnMobAfterScareC2S;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.sounds.SoundEvent;

public class JumpscareManager {
    private static final long MIN_RETRIGGER_NS = 250000000L;
    private static final double CHECK_MIN_SECONDS = 300.0;
    private static final double CHECK_MAX_SECONDS = 600.0;
    private static final double BASE_TRIGGER_CHANCE = 0.35;
    private static final double IDLE_MULTIPLIER = 0.8;
    private static final double MAX_CHANCE_CLAMP = 0.85;
    private static final double MIN_COOLDOWN_SECONDS = 10.0;
    private static final int HOLD_LAST_SECS = 0;
    private static final double MAX_FALLBACK_AUDIO_SECS = 12.0;
    private static final Gson GSON = new Gson();
    private static final Map<ResourceLocation, int[]> TEX_SIZE_CACHE = new ConcurrentHashMap<ResourceLocation, int[]>();
    private static final Map<ResourceLocation, SoundEvent> SOUND_CACHE = new ConcurrentHashMap<ResourceLocation, SoundEvent>();
    private static final JumpscareManager INSTANCE = new JumpscareManager();
    private final Random rng = new Random();
    private final List<Jumpscare> catalog = new ArrayList<Jumpscare>();
    private final List<Jumpscare> unusedPool = new ArrayList<Jumpscare>();
    private long lastTriggerNs = 0L;
    private long nextCheckAtNanos = -1L;
    private Jumpscare active = null;
    private long startNanos = 0L;
    private SimpleSoundInstance playingSound = null;

    private JumpscareManager() {
        this.loadCatalog();
        this.scheduleNextCheckFromNow();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static int[] getTextureSize(ResourceLocation id) {
        block15: {
            int[] cached = TEX_SIZE_CACHE.get(id);
            if (cached != null) {
                return cached;
            }
            try {
                ResourceManager rm = Minecraft.m_91087_().m_91098_();
                Optional opt = rm.m_213713_(id);
                if (!opt.isPresent()) break block15;
                try (InputStream in = ((Resource)opt.get()).m_215507_();){
                    int[] nArray;
                    block16: {
                        NativeImage img = NativeImage.m_85058_((InputStream)in);
                        try {
                            int[] dims = new int[]{img.m_84982_(), img.m_85084_()};
                            TEX_SIZE_CACHE.put(id, dims);
                            nArray = dims;
                            if (img == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (img != null) {
                                try {
                                    img.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        img.close();
                    }
                    return nArray;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new int[]{256, 256};
    }

    public static JumpscareManager get() {
        return INSTANCE;
    }

    public boolean isActive() {
        return this.active != null;
    }

    private long nowNs() {
        return System.nanoTime();
    }

    private long randomDelayNs(double minSec, double maxSec) {
        double span = Math.max(0.0, maxSec - minSec);
        double sec = minSec + this.rng.nextDouble() * span;
        return (long)(sec * 1.0E9);
    }

    private void scheduleNextCheckFromNow() {
        this.nextCheckAtNanos = this.nowNs() + this.randomDelayNs(300.0, 600.0);
    }

    private boolean isIdleContext(Minecraft mc) {
        return mc.f_91080_ != null;
    }

    private double currentTriggerChance(Minecraft mc) {
        double chance = 0.35;
        if (this.isIdleContext(mc)) {
            chance *= 0.8;
        }
        return Math.min(chance, 0.85);
    }

    private void loadCatalog() {
        try {
            ResourceLocation manifest = ResourceLocation.m_135820_((String)"fnafmod:jumpscares/jumpscares.json");
            if (manifest == null) {
                return;
            }
            Optional res = Minecraft.m_91087_().m_91098_().m_213713_(manifest);
            if (res.isEmpty()) {
                return;
            }
            JsonObject root = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(((Resource)res.get()).m_215507_(), StandardCharsets.UTF_8), JsonObject.class);
            JsonArray arr = root.getAsJsonArray("entries");
            for (int i = 0; i < arr.size(); ++i) {
                JsonArray off;
                JsonObject e = arr.get(i).getAsJsonObject();
                String id = e.get("id").getAsString();
                String folder = e.get("folder").getAsString();
                String pattern = e.get("pattern").getAsString();
                int frameCount = e.get("frameCount").getAsInt();
                int fps = e.get("fps").getAsInt();
                String sound = e.get("sound").getAsString();
                String anchor = e.has("anchor") ? e.get("anchor").getAsString() : "fullscreen";
                double scale = e.has("scale") ? e.get("scale").getAsDouble() : 1.0;
                boolean loop = e.has("loop") && e.get("loop").getAsBoolean();
                boolean wantsSpawn = e.has("spawn_mob") || e.has("spawn") && e.get("spawn").getAsBoolean();
                ResourceLocation spawnMobId = null;
                String spawnName = null;
                int offX = 0;
                int offY = 0;
                int offZ = 0;
                String[] armor = null;
                if (wantsSpawn && e.has("spawn_mob")) {
                    spawnMobId = ResourceLocation.m_135820_((String)e.get("spawn_mob").getAsString());
                }
                if (wantsSpawn && e.has("spawn_name") && (spawnName = e.get("spawn_name").getAsString()) != null && spawnName.isBlank()) {
                    spawnName = null;
                }
                if (wantsSpawn && e.has("spawn_offset") && (off = e.getAsJsonArray("spawn_offset")).size() >= 3) {
                    offX = off.get(0).getAsInt();
                    offY = off.get(1).getAsInt();
                    offZ = off.get(2).getAsInt();
                }
                if (wantsSpawn && e.has("armor")) {
                    JsonArray armorArray = e.getAsJsonArray("armor");
                    armor = new String[armorArray.size()];
                    for (int j = 0; j < armorArray.size(); ++j) {
                        armor[j] = armorArray.get(j).getAsString();
                    }
                }
                Object folderPrefix = folder.endsWith("/") ? folder : folder + "/";
                ResourceLocation[] frames = new ResourceLocation[frameCount];
                for (int f = 0; f < frameCount; ++f) {
                    String file = String.format(pattern, f + 1);
                    frames[f] = ResourceLocation.m_135820_((String)((String)folderPrefix + file));
                }
                ResourceLocation soundLoc = ResourceLocation.m_135820_((String)sound);
                this.catalog.add(new Jumpscare(id, frames, fps, soundLoc, loop, anchor, scale, spawnMobId, spawnName, offX, offY, offZ, armor));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void triggerRandom() {
        if (this.active != null) {
            return;
        }
        long now = this.nowNs();
        if (now - this.lastTriggerNs < 250000000L) {
            return;
        }
        if (this.unusedPool.isEmpty() && !this.catalog.isEmpty()) {
            this.unusedPool.addAll(this.catalog);
            Collections.shuffle(this.unusedPool, this.rng);
        }
        if (this.unusedPool.isEmpty()) {
            return;
        }
        Jumpscare next = this.unusedPool.remove(0);
        this.trigger(next);
        this.lastTriggerNs = now;
    }

    public void trigger(Jumpscare js) {
        if (this.active != null) {
            return;
        }
        this.active = js;
        this.startNanos = this.nowNs();
        float volume = 1.0f;
        float pitch = 1.0f;
        Minecraft mc = Minecraft.m_91087_();
        SoundEvent se = SOUND_CACHE.computeIfAbsent(js.soundKey(), SoundEvent::m_262824_);
        this.playingSound = SimpleSoundInstance.m_119755_((SoundEvent)se, (float)volume, (float)pitch);
        mc.m_91106_().m_120367_((SoundInstance)this.playingSound);
    }

    public void tick() {
        if (this.active != null) {
            return;
        }
        long now = this.nowNs();
        Minecraft mc = Minecraft.m_91087_();
        if (this.nextCheckAtNanos > 0L && now >= this.nextCheckAtNanos && !this.catalog.isEmpty()) {
            double p = this.currentTriggerChance(mc);
            if (this.rng.nextDouble() < p) {
                this.triggerRandom();
                this.nextCheckAtNanos = now + 10000000000L;
            } else {
                this.scheduleNextCheckFromNow();
            }
        }
    }

    public void render(GuiGraphics g) {
        boolean finish;
        int idx;
        if (this.active == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        double elapsed = (double)(this.nowNs() - this.startNanos) / 1.0E9;
        double frameDur = 1.0 / (double)Math.max(1, this.active.fps());
        if (this.active.loop()) {
            idx = (int)Math.floor(elapsed / frameDur) % this.active.frames().length;
        } else {
            double totalAnim = (double)this.active.frames().length * frameDur + 0.0;
            double t = Math.min(elapsed, totalAnim);
            idx = (int)Math.min((double)(this.active.frames().length - 1), Math.floor(t / frameDur));
        }
        ResourceLocation frame = this.active.frames()[idx];
        int sw = mc.m_91268_().m_85445_();
        int sh = mc.m_91268_().m_85446_();
        g.m_280168_().m_85836_();
        g.m_280168_().m_252880_(0.0f, 0.0f, 1000.0f);
        RenderSystem.disableDepthTest();
        if ("fnafmod:xor".equalsIgnoreCase(this.active.id())) {
            dims = JumpscareManager.getTextureSize(frame);
            texW = dims[0];
            texH = dims[1];
            int drawH = (int)Math.max(16.0, (double)sh * this.active.scale());
            int drawW = Math.max(16, (int)Math.round((double)drawH * ((double)texW / (double)texH)));
            double freqHz = 8.0;
            double t = elapsed;
            double factor = (Math.sin(t * Math.PI * 2.0 * freqHz) + 1.0) * 0.5;
            int x = (int)Math.round(factor * (double)Math.max(0, sw - drawW));
            int pad = 6;
            int y = sh - drawH - pad;
            g.m_280411_(frame, x, y, drawW, drawH, 0.0f, 0.0f, texW, texH, texW, texH);
        } else if ("bottom_left".equalsIgnoreCase(this.active.anchor())) {
            int pad;
            dims = JumpscareManager.getTextureSize(frame);
            texW = dims[0];
            texH = dims[1];
            int drawH = (int)Math.max(16.0, (double)sh * this.active.scale());
            int drawW = Math.max(16, (int)Math.round((double)drawH * ((double)texW / (double)texH)));
            int x = pad = 6;
            int y = sh - drawH - pad;
            g.m_280411_(frame, x, y, drawW, drawH, 0.0f, 0.0f, texW, texH, texW, texH);
        } else {
            g.m_280163_(frame, 0, 0, 0.0f, 0.0f, sw, sh, sw, sh);
        }
        if (this.active.loop()) {
            boolean soundActive = this.playingSound != null && mc.m_91106_().m_120403_((SoundInstance)this.playingSound);
            boolean overFallback = elapsed > 12.0;
            finish = !soundActive || overFallback;
        } else {
            double endAt = (double)this.active.frames().length * frameDur + 0.0;
            boolean bl = finish = elapsed > endAt;
        }
        if (finish) {
            Jumpscare finished = this.active;
            this.active = null;
            this.playingSound = null;
            long soonest = this.nowNs() + 10000000000L;
            if (this.nextCheckAtNanos < soonest) {
                this.nextCheckAtNanos = soonest;
            }
            if (finished != null && finished.spawnMobId() != null && mc.f_91074_ != null && mc.f_91073_ != null && mc.f_91080_ == null) {
                FnafNet.CHANNEL.sendToServer((Object)new SpawnMobAfterScareC2S(finished.spawnMobId(), finished.spawnName(), finished.spawnOffX(), finished.spawnOffY(), finished.spawnOffZ(), finished.armor()));
            }
        }
        RenderSystem.enableDepthTest();
        g.m_280168_().m_85849_();
    }
}

