/*
 * Decompiled with CFR 0.152.
 */
package net.lee.fnafmod.network;

import java.util.function.Supplier;
import net.lee.fnafmod.util.ArmorRandomizer;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public record SpawnMobAfterScareC2S(ResourceLocation mobId, String spawnName, int offX, int offY, int offZ, String[] armor) {
    public static void encode(SpawnMobAfterScareC2S msg, FriendlyByteBuf buf) {
        buf.m_130085_(msg.mobId);
        buf.writeBoolean(msg.spawnName() != null);
        if (msg.spawnName() != null) {
            buf.m_130070_(msg.spawnName());
        }
        buf.writeInt(msg.offX);
        buf.writeInt(msg.offY);
        buf.writeInt(msg.offZ);
        for (int i = 0; i < 4; ++i) {
            String s = msg.armor != null && i < msg.armor.length ? msg.armor[i] : null;
            buf.writeBoolean(s != null);
            if (s == null) continue;
            buf.m_130070_(s);
        }
    }

    public static SpawnMobAfterScareC2S decode(FriendlyByteBuf buf) {
        ResourceLocation id = buf.m_130281_();
        String spawnName = buf.readBoolean() ? buf.m_130136_(Short.MAX_VALUE) : null;
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        String[] armor = new String[4];
        for (int i = 0; i < 4; ++i) {
            boolean present = buf.readBoolean();
            armor[i] = present ? buf.m_130136_(Short.MAX_VALUE) : null;
        }
        return new SpawnMobAfterScareC2S(id, spawnName, x, y, z, armor);
    }

    public static void handle(SpawnMobAfterScareC2S msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender == null) {
                return;
            }
            Level level = sender.m_9236_();
            Registry reg = level.m_9598_().m_175515_(Registries.f_256939_);
            reg.m_6612_(msg.mobId).ifPresent(type -> {
                Entity e = type.m_20615_(level);
                if (e instanceof Mob) {
                    Mob mob = (Mob)e;
                    mob.m_7678_(sender.m_20185_() + (double)msg.offX, sender.m_20186_() + (double)msg.offY, sender.m_20189_() + (double)msg.offZ, sender.m_146908_(), sender.m_146909_());
                    if (msg.spawnName() != null) {
                        mob.m_6593_((Component)Component.m_237113_((String)msg.spawnName()));
                        mob.m_20340_(true);
                    }
                    EquipmentSlot[] slots = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
                    RandomSource rnd = mob.m_217043_();
                    if (msg.armor == null) {
                        ArmorRandomizer.equipRandomArmor(mob, rnd, false);
                    } else {
                        for (int i = 0; i < 4; ++i) {
                            String id;
                            String string = id = msg.armor.length > i ? msg.armor[i] : null;
                            if (id == null) continue;
                            if ("random".equalsIgnoreCase(id)) {
                                Item item = ArmorRandomizer.pickArmorForSlot(rnd, slots[i]);
                                if (item == Items.f_41852_) continue;
                                mob.m_8061_(slots[i], new ItemStack((ItemLike)item));
                                continue;
                            }
                            Registry itemRegistry = level.m_9598_().m_175515_(Registries.f_256913_);
                            Item item = itemRegistry.m_6612_(ResourceLocation.m_135820_((String)id)).orElse(Items.f_41852_);
                            if (item == Items.f_41852_) continue;
                            mob.m_8061_(slots[i], new ItemStack((ItemLike)item));
                        }
                    }
                    level.m_7967_((Entity)mob);
                }
            });
        });
        ctx.get().setPacketHandled(true);
    }
}

