/*
 * Decompiled with CFR 0.152.
 */
package lee.fnafmod.neoforge.client;

import com.mojang.blaze3d.platform.InputConstants;
import lee.fnafmod.client.JumpscareManager;
import lee.fnafmod.client.Keybinds;
import lee.fnafmod.neoforge.client.overlay.JumpscareOverlay;
import lee.fnafmod.platform.ClientEventHandler;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.gui.GuiLayer;
import net.neoforged.neoforge.common.NeoForge;

public class NeoForgeClientEventHandler
implements ClientEventHandler {
    private final IEventBus modBus;

    public NeoForgeClientEventHandler(IEventBus modBus) {
        this.modBus = modBus;
    }

    @Override
    public void registerClientEvents() {
        NeoForge.EVENT_BUS.addListener(this::onClientTickEnd);
        NeoForge.EVENT_BUS.addListener(this::onKeyInput);
        NeoForge.EVENT_BUS.addListener(this::onScreenRenderPost);
    }

    @Override
    public void registerKeyBindings() {
        this.modBus.addListener(this::onRegisterKeyMappings);
    }

    @Override
    public void registerRenderOverlay() {
        this.modBus.addListener(this::onRegisterGuiOverlays);
    }

    private void onRegisterKeyMappings(RegisterKeyMappingsEvent e) {
        if (Keybinds.TEST_SCARE != null) {
            e.register(Keybinds.TEST_SCARE);
        }
        if (Keybinds.TEST_FIRST_SCARE != null) {
            e.register(Keybinds.TEST_FIRST_SCARE);
        }
    }

    private void onRegisterGuiOverlays(RegisterGuiLayersEvent e) {
        e.registerAboveAll(ResourceLocation.parse((String)"fnafmod"), (GuiLayer)new JumpscareOverlay());
    }

    private void onClientTickEnd(ClientTickEvent.Post e) {
        if (Keybinds.TEST_SCARE != null && Keybinds.TEST_SCARE.consumeClick()) {
            JumpscareManager.get().triggerRandom();
        }
        if (Keybinds.TEST_FIRST_SCARE != null && Keybinds.TEST_FIRST_SCARE.consumeClick()) {
            JumpscareManager.get().triggerFirst();
        }
        JumpscareManager.get().tick();
    }

    private void onKeyInput(InputEvent.Key e) {
        if (e.getAction() == 1 && !JumpscareManager.get().isActive()) {
            InputConstants.Key pressedKey;
            InputConstants.Key key = pressedKey = e.getKey() == 0 && e.getScanCode() > 0 ? InputConstants.Type.SCANCODE.getOrCreate(e.getScanCode()) : InputConstants.Type.KEYSYM.getOrCreate(e.getKey());
            if (Keybinds.TEST_SCARE != null && Keybinds.TEST_SCARE.matches(e.getKeyEvent())) {
                JumpscareManager.get().triggerRandom();
            }
            if (Keybinds.TEST_FIRST_SCARE != null && Keybinds.TEST_FIRST_SCARE.matches(e.getKeyEvent())) {
                JumpscareManager.get().triggerFirst();
            }
        }
    }

    private void onScreenRenderPost(ScreenEvent.Render.Post e) {
        JumpscareManager.get().render(e.getGuiGraphics());
    }
}

