/*
 * Decompiled with CFR 0.152.
 */
package dev.f2fox.bmusic.client;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import dev.f2fox.bmusic.client.BMusicClient;
import dev.f2fox.bmusic.client.FadeableSoundInstance;
import dev.f2fox.bmusic.client.IBMusicTracker;
import dev.f2fox.bmusic.client.MusicConfig;
import dev.f2fox.bmusic.client.MusicManager;
import dev.f2fox.bmusic.client.modmenu.ModConfig;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1113;
import net.minecraft.class_1142;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class BiomeMusicHandler {
    private final MusicManager musicManager;
    private Map<String, Object> biomeMusicMap = new HashMap<String, Object>();
    private String currentBiomeId = "";
    private String currentSoundKey = "";
    private final class_310 mc = class_310.method_1551();
    private FadeableSoundInstance currentInstance;

    public BiomeMusicHandler(MusicManager musicManager) {
        this.musicManager = musicManager;
    }

    public void loadConfig(class_3300 rm) {
        try {
            class_2960 resId = class_2960.method_43902((String)"bmusic", (String)"soundconfig.json");
            Optional resOpt = rm.method_14486(resId);
            if (resOpt.isEmpty()) {
                System.err.println("[bmusic] Missing soundconfig.json");
                this.biomeMusicMap = new HashMap<String, Object>();
                return;
            }
            try (InputStream stream = ((class_3298)resOpt.get()).method_14482();
                 InputStreamReader reader = new InputStreamReader(stream);){
                Type fullType = new TypeToken<Map<String, Map<String, Object>>>(this){}.getType();
                Map fullMap = (Map)new Gson().fromJson((Reader)reader, fullType);
                if (fullMap != null && fullMap.containsKey("biomeMusic")) {
                    this.biomeMusicMap = (Map)fullMap.get("biomeMusic");
                    System.out.println("[bmusic] Loaded biomeMusic from soundconfig.json with " + this.biomeMusicMap.size() + " entries");
                } else {
                    this.biomeMusicMap = new HashMap<String, Object>();
                    System.out.println("[bmusic] No biomeMusic section found in soundconfig.json");
                }
            }
        }
        catch (Exception e) {
            System.err.println("[bmusic] Failed to load soundconfig.json: " + String.valueOf(e));
            this.biomeMusicMap = new HashMap<String, Object>();
        }
    }

    private String getSoundKeyForBiome(String biomeId, class_310 mc) {
        Map configMap;
        Gson gson;
        MusicConfig config;
        Object musicConfig = this.biomeMusicMap.get(biomeId);
        if (musicConfig == null) {
            return null;
        }
        if (musicConfig instanceof String) {
            return (String)musicConfig;
        }
        if (musicConfig instanceof Map && (config = (MusicConfig)(gson = new Gson()).fromJson(gson.toJson((Object)(configMap = (Map)musicConfig)), MusicConfig.class)) != null && config.matchesConditions(mc)) {
            return config.getSound();
        }
        return null;
    }

    public void tick(class_310 mc) {
        IBMusicTracker tracker;
        if (mc.field_1724 == null || mc.field_1687 == null) {
            this.musicManager.stopMusic();
            this.currentBiomeId = "";
            return;
        }
        if (!ModConfig.get().biomeMusicEnabled) {
            this.musicManager.stopMusic();
            return;
        }
        class_1142 class_11422 = mc.method_1538();
        if (class_11422 instanceof IBMusicTracker && !(tracker = (IBMusicTracker)class_11422).isMusicEnabled()) {
            this.musicManager.stopMusic();
            return;
        }
        if (!ModConfig.get().prioritizeBiomeMusic && BMusicClient.getRandomHandler().isPlaying()) {
            return;
        }
        class_6880 biomeEntry = mc.field_1687.method_23753(mc.field_1724.method_24515());
        class_2960 biomeId = mc.field_1687.method_30349().method_30530(class_7924.field_41236).method_10221((Object)((class_1959)biomeEntry.comp_349()));
        if (biomeId == null) {
            this.musicManager.stopMusic();
            this.currentBiomeId = "";
            return;
        }
        String newBiomeId = biomeId.toString();
        String newSoundKey = this.getSoundKeyForBiome(newBiomeId, mc);
        if (!Objects.equals(newSoundKey, this.currentSoundKey)) {
            this.musicManager.stopMusic();
            if (newSoundKey != null) {
                this.currentInstance = this.musicManager.playMusic(newSoundKey, true);
            }
            this.currentSoundKey = newSoundKey;
        }
        this.currentBiomeId = newBiomeId;
    }

    public boolean isPlaying() {
        return this.currentInstance != null && this.mc.method_1483().method_4877((class_1113)this.currentInstance);
    }
}

