/*
 * Decompiled with CFR 0.152.
 */
package com.ungenius.backpacks;

import com.ungenius.backpacks.BackpackCommand;
import com.ungenius.backpacks.InventoryListener;
import com.ungenius.backpacks.ReloadCommand;
import com.ungenius.backpacks.Utils;
import java.io.File;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class BackpacksPlugin
extends JavaPlugin {
    private static BackpacksPlugin instance;
    private FileConfiguration messages;

    @Override
    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.saveResource("messages.yml", false);
        this.loadMessages();
        this.getCommand("backpack").setExecutor(new BackpackCommand());
        this.getCommand("backpack").setTabCompleter(new BackpackCommand());
        this.getCommand("backpacks").setExecutor(new ReloadCommand());
        this.getServer().getPluginManager().registerEvents(new InventoryListener(), this);
        int count = this.getConfig().getConfigurationSection("backpacks").getKeys(false).size();
        Utils.logCentered("&8===============================");
        Utils.logCentered("");
        Utils.logCentered("&6Smart&fBackpacks &8[" + this.getDescription().getVersion() + "]");
        Utils.logCentered("&fCustomizable backpacks with permission-based access.");
        Utils.logCentered("&7Loaded: " + count + " backpacks");
        Utils.logCentered("");
        Utils.logCentered("&8===============================");
    }

    public void loadMessages() {
        File messagesFile = new File(this.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.saveResource("messages.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration(messagesFile);
    }

    public FileConfiguration getMessages() {
        return this.messages;
    }

    public static BackpacksPlugin getInstance() {
        return instance;
    }
}

