/*
 * Decompiled with CFR 0.152.
 */
package com.ungenius.backpacks;

import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;

public class ColorUtil {
    private static final Pattern HEX_PATTERN = Pattern.compile("#[a-fA-F0-9]{6}");
    private static final Pattern GRADIENT_PATTERN = Pattern.compile("<gradient:(#[a-fA-F0-9]{6}):(#[a-fA-F0-9]{6})>(.*?)</gradient>");
    private static final Pattern FORMAT_PATTERN = Pattern.compile("<(bold|italic|underline|strikethrough|obfuscated)>(.*?)</\\1>");

    public static String colorize(String message) {
        if (message == null) {
            return "";
        }
        Matcher gradientMatcher = GRADIENT_PATTERN.matcher(message);
        while (gradientMatcher.find()) {
            String startHex = gradientMatcher.group(1);
            String endHex = gradientMatcher.group(2);
            String text = gradientMatcher.group(3);
            String gradientText = ColorUtil.applyGradient(startHex, endHex, text);
            message = message.replace(gradientMatcher.group(0), gradientText);
            gradientMatcher = GRADIENT_PATTERN.matcher(message);
        }
        Matcher formatMatcher = FORMAT_PATTERN.matcher(message);
        while (formatMatcher.find()) {
            String formatTag = formatMatcher.group(1);
            String content = formatMatcher.group(2);
            ChatColor formatCode = switch (formatTag.toLowerCase()) {
                case "bold" -> ChatColor.BOLD;
                case "italic" -> ChatColor.ITALIC;
                case "underline" -> ChatColor.UNDERLINE;
                case "strikethrough" -> ChatColor.STRIKETHROUGH;
                case "obfuscated" -> ChatColor.MAGIC;
                default -> ChatColor.RESET;
            };
            message = message.replace(formatMatcher.group(0), String.valueOf(formatCode) + content + String.valueOf(ChatColor.RESET));
            formatMatcher = FORMAT_PATTERN.matcher(message);
        }
        Matcher hexMatcher = HEX_PATTERN.matcher(message);
        while (hexMatcher.find()) {
            String hex = hexMatcher.group();
            ChatColor color = ChatColor.of(hex);
            message = message.replace(hex, color.toString());
        }
        return ChatColor.translateAlternateColorCodes('&', message);
    }

    private static String applyGradient(String startHex, String endHex, String text) {
        Color start = Color.decode(startHex);
        Color end = Color.decode(endHex);
        StringBuilder builder = new StringBuilder();
        String formatting = ColorUtil.extractFormatting(text);
        text = ColorUtil.removeFormattingTags(text);
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            float ratio = (float)i / (float)Math.max(len - 1, 1);
            int r = (int)((float)start.getRed() + ratio * (float)(end.getRed() - start.getRed()));
            int g2 = (int)((float)start.getGreen() + ratio * (float)(end.getGreen() - start.getGreen()));
            int b = (int)((float)start.getBlue() + ratio * (float)(end.getBlue() - start.getBlue()));
            ChatColor color = ChatColor.of(new Color(r, g2, b));
            builder.append(color).append(formatting).append(text.charAt(i));
        }
        return builder.toString();
    }

    private static String extractFormatting(String input) {
        StringBuilder formatting = new StringBuilder();
        if (input.contains("<bold>")) {
            formatting.append(ChatColor.BOLD);
        }
        if (input.contains("<italic>")) {
            formatting.append(ChatColor.ITALIC);
        }
        if (input.contains("<underline>")) {
            formatting.append(ChatColor.UNDERLINE);
        }
        if (input.contains("<strikethrough>")) {
            formatting.append(ChatColor.STRIKETHROUGH);
        }
        if (input.contains("<obfuscated>")) {
            formatting.append(ChatColor.MAGIC);
        }
        return formatting.toString();
    }

    private static String removeFormattingTags(String input) {
        return input.replace("<bold>", "").replace("</bold>", "").replace("<italic>", "").replace("</italic>", "").replace("<underline>", "").replace("</underline>", "").replace("<strikethrough>", "").replace("</strikethrough>", "").replace("<obfuscated>", "").replace("</obfuscated>", "");
    }
}

