/*
 * Decompiled with CFR 0.152.
 */
package com.ungenius.backpacks;

import com.ungenius.backpacks.BackpacksPlugin;
import com.ungenius.backpacks.ColorUtil;
import java.util.Map;
import org.bukkit.ChatColor;

public class Utils {
    public static String msg(String path, Map<String, String> placeholders) {
        String raw = BackpacksPlugin.getInstance().getMessages().getString(path, "&cUnknown message: " + path);
        String prefix = BackpacksPlugin.getInstance().getConfig().getString("prefix", "&6SmartBackpacks &8\u00bb");
        raw = raw.replace("%prefix%", prefix);
        if (placeholders != null) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                raw = raw.replace("<" + entry.getKey() + ">", entry.getValue());
            }
        }
        return ColorUtil.colorize(raw);
    }

    public static String msg(String path) {
        return Utils.msg(path, null);
    }

    public static void logCentered(String message) {
        int CONSOLE_WIDTH = 55;
        String colored = ChatColor.translateAlternateColorCodes('&', message);
        String stripped = ChatColor.stripColor(colored);
        int padding = Math.max((55 - stripped.length()) / 2, 0);
        String spaces = " ".repeat(padding);
        BackpacksPlugin.getInstance().getServer().getConsoleSender().sendMessage(spaces + colored);
    }

    public static String msgRaw(String raw) {
        String prefix = BackpacksPlugin.getInstance().getConfig().getString("prefix", "&6SmartBackpacks &8\u00bb");
        return ColorUtil.colorize(prefix + " " + raw);
    }
}

