/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.enchantments;

import com.google.common.collect.Lists;
import java.util.Locale;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Translatable;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.inventory.ItemStack;
import org.bukkit.registry.RegistryAware;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Enchantment
implements Keyed,
Translatable,
RegistryAware {
    public static final Enchantment PROTECTION = Enchantment.getEnchantment("protection");
    public static final Enchantment FIRE_PROTECTION = Enchantment.getEnchantment("fire_protection");
    public static final Enchantment FEATHER_FALLING = Enchantment.getEnchantment("feather_falling");
    public static final Enchantment BLAST_PROTECTION = Enchantment.getEnchantment("blast_protection");
    public static final Enchantment PROJECTILE_PROTECTION = Enchantment.getEnchantment("projectile_protection");
    public static final Enchantment RESPIRATION = Enchantment.getEnchantment("respiration");
    public static final Enchantment AQUA_AFFINITY = Enchantment.getEnchantment("aqua_affinity");
    public static final Enchantment THORNS = Enchantment.getEnchantment("thorns");
    public static final Enchantment DEPTH_STRIDER = Enchantment.getEnchantment("depth_strider");
    public static final Enchantment FROST_WALKER = Enchantment.getEnchantment("frost_walker");
    public static final Enchantment BINDING_CURSE = Enchantment.getEnchantment("binding_curse");
    public static final Enchantment SHARPNESS = Enchantment.getEnchantment("sharpness");
    public static final Enchantment SMITE = Enchantment.getEnchantment("smite");
    public static final Enchantment BANE_OF_ARTHROPODS = Enchantment.getEnchantment("bane_of_arthropods");
    public static final Enchantment KNOCKBACK = Enchantment.getEnchantment("knockback");
    public static final Enchantment FIRE_ASPECT = Enchantment.getEnchantment("fire_aspect");
    public static final Enchantment LOOTING = Enchantment.getEnchantment("looting");
    public static final Enchantment SWEEPING_EDGE = Enchantment.getEnchantment("sweeping_edge");
    public static final Enchantment EFFICIENCY = Enchantment.getEnchantment("efficiency");
    public static final Enchantment SILK_TOUCH = Enchantment.getEnchantment("silk_touch");
    public static final Enchantment UNBREAKING = Enchantment.getEnchantment("unbreaking");
    public static final Enchantment FORTUNE = Enchantment.getEnchantment("fortune");
    public static final Enchantment POWER = Enchantment.getEnchantment("power");
    public static final Enchantment PUNCH = Enchantment.getEnchantment("punch");
    public static final Enchantment FLAME = Enchantment.getEnchantment("flame");
    public static final Enchantment INFINITY = Enchantment.getEnchantment("infinity");
    public static final Enchantment LUCK_OF_THE_SEA = Enchantment.getEnchantment("luck_of_the_sea");
    public static final Enchantment LURE = Enchantment.getEnchantment("lure");
    public static final Enchantment LOYALTY = Enchantment.getEnchantment("loyalty");
    public static final Enchantment IMPALING = Enchantment.getEnchantment("impaling");
    public static final Enchantment RIPTIDE = Enchantment.getEnchantment("riptide");
    public static final Enchantment CHANNELING = Enchantment.getEnchantment("channeling");
    public static final Enchantment MULTISHOT = Enchantment.getEnchantment("multishot");
    public static final Enchantment QUICK_CHARGE = Enchantment.getEnchantment("quick_charge");
    public static final Enchantment PIERCING = Enchantment.getEnchantment("piercing");
    public static final Enchantment DENSITY = Enchantment.getEnchantment("density");
    public static final Enchantment BREACH = Enchantment.getEnchantment("breach");
    public static final Enchantment WIND_BURST = Enchantment.getEnchantment("wind_burst");
    public static final Enchantment MENDING = Enchantment.getEnchantment("mending");
    public static final Enchantment VANISHING_CURSE = Enchantment.getEnchantment("vanishing_curse");
    public static final Enchantment SOUL_SPEED = Enchantment.getEnchantment("soul_speed");
    public static final Enchantment SWIFT_SNEAK = Enchantment.getEnchantment("swift_sneak");

    @NotNull
    private static Enchantment getEnchantment(@NotNull String key) {
        return Registry.ENCHANTMENT.getOrThrow(NamespacedKey.minecraft(key));
    }

    @Deprecated(since="1.13")
    @NotNull
    public abstract String getName();

    public abstract int getMaxLevel();

    public abstract int getStartLevel();

    @Deprecated(since="1.20.5")
    @NotNull
    public abstract EnchantmentTarget getItemTarget();

    @Deprecated(since="1.21")
    public abstract boolean isTreasure();

    @Deprecated(since="1.13")
    public abstract boolean isCursed();

    public abstract boolean conflictsWith(@NotNull Enchantment var1);

    public abstract boolean canEnchantItem(@NotNull ItemStack var1);

    @Override
    @Deprecated(since="1.21.4")
    @NotNull
    public abstract NamespacedKey getKey();

    @Deprecated(since="1.20.3")
    @Contract(value="null -> null")
    @Nullable
    public static Enchantment getByKey(@Nullable NamespacedKey key) {
        if (key == null) {
            return null;
        }
        return Registry.ENCHANTMENT.get(key);
    }

    @Deprecated(since="1.13")
    @Contract(value="null -> null")
    @Nullable
    public static Enchantment getByName(@Nullable String name) {
        if (name == null) {
            return null;
        }
        return Enchantment.getByKey(NamespacedKey.fromString(name.toLowerCase(Locale.ROOT)));
    }

    @Deprecated(since="1.20.3")
    @NotNull
    public static Enchantment[] values() {
        return Lists.newArrayList(Registry.ENCHANTMENT).toArray(new Enchantment[0]);
    }
}

