/*
 * Decompiled with CFR 0.152.
 */
package com.ungenius.backpacks;

import com.ungenius.backpacks.BackpacksPlugin;
import com.ungenius.backpacks.ColorUtil;
import com.ungenius.backpacks.DataHandler;
import com.ungenius.backpacks.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class BackpackCommand
implements CommandExecutor,
TabCompleter {
    private final BackpacksPlugin plugin = BackpacksPlugin.getInstance();

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String sub;
        if (args.length == 0) {
            this.sendUsage(sender);
            return true;
        }
        switch (sub = args[0].toLowerCase()) {
            case "open": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(Utils.msg("player-only"));
                    return true;
                }
                Player p = (Player)sender;
                this.handleOpen(p, args);
                break;
            }
            case "list": {
                if (!sender.hasPermission("smartbackpacks.admin")) {
                    sender.sendMessage(Utils.msg("no-permission"));
                    return true;
                }
                this.handleList(sender);
                break;
            }
            case "add": {
                if (!sender.hasPermission("smartbackpacks.admin")) {
                    sender.sendMessage(Utils.msg("no-permission"));
                    return true;
                }
                this.handleAdd(sender, args);
                break;
            }
            case "remove": {
                if (!sender.hasPermission("smartbackpacks.admin")) {
                    sender.sendMessage(Utils.msg("no-permission"));
                    return true;
                }
                this.handleRemove(sender, args);
                break;
            }
            case "reload": {
                if (!sender.hasPermission("smartbackpacks.admin")) {
                    sender.sendMessage(Utils.msg("no-permission"));
                    return true;
                }
                this.plugin.reloadConfig();
                this.plugin.loadMessages();
                sender.sendMessage(Utils.msg("reload-success"));
                break;
            }
            default: {
                this.sendUsage(sender);
            }
        }
        return true;
    }

    private void sendUsage(CommandSender sender) {
        String version = BackpacksPlugin.getInstance().getDescription().getVersion();
        sender.sendMessage("");
        sender.sendMessage(ColorUtil.colorize("<gradient:#ce934d:#fffba4><bold>Smart</bold></gradient><gradient:#a2afb8:#fdfefe><bold>Backpacks</bold></gradient> &7Plugin"));
        sender.sendMessage(String.valueOf((Object)ChatColor.DARK_GRAY) + "\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        sender.sendMessage(String.valueOf((Object)ChatColor.GRAY) + " Version: " + String.valueOf((Object)ChatColor.WHITE) + version);
        sender.sendMessage(String.valueOf((Object)ChatColor.GRAY) + " Author: " + String.valueOf((Object)ChatColor.AQUA) + "https://modrinth.com/organization/ungenius-labs");
        sender.sendMessage(String.valueOf((Object)ChatColor.GRAY) + " Commands:");
        sender.sendMessage(String.valueOf((Object)ChatColor.GOLD) + " \u27a4 /backpack open <name>");
        sender.sendMessage(String.valueOf((Object)ChatColor.GOLD) + " \u27a4 /backpack list");
        sender.sendMessage(String.valueOf((Object)ChatColor.GOLD) + " \u27a4 /backpack add <name> <size> <title>");
        sender.sendMessage(String.valueOf((Object)ChatColor.GOLD) + " \u27a4 /backpack remove <name>");
        sender.sendMessage(String.valueOf((Object)ChatColor.GOLD) + " \u27a4 /backpack reload");
        sender.sendMessage(String.valueOf((Object)ChatColor.DARK_GRAY) + "\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        sender.sendMessage("");
    }

    private void handleOpen(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage(Utils.msg("not-enough-args"));
            return;
        }
        String backpackId = args[1].toLowerCase();
        if (!this.plugin.getConfig().contains("backpacks." + backpackId)) {
            Map<String, String> vars = Map.of("name", backpackId);
            player.sendMessage(Utils.msg("backpack-not-found", vars));
            return;
        }
        if (!player.hasPermission("smartbackpacks.open." + backpackId) && !player.hasPermission("smartbackpacks.open")) {
            player.sendMessage(Utils.msg("no-permission"));
            return;
        }
        int size = this.plugin.getConfig().getInt("backpacks." + backpackId + ".size", 27);
        String title = this.plugin.getConfig().getString("backpacks." + backpackId + ".title", "Backpack");
        Inventory inv = DataHandler.cargarMochila(player.getUniqueId(), backpackId, size, ColorUtil.colorize(title));
        player.openInventory(inv);
        Map<String, String> vars = Map.of("name", backpackId);
        player.sendMessage(Utils.msg("backpack-opened", vars));
    }

    private void handleList(CommandSender sender) {
        sender.sendMessage(Utils.msgRaw("&fAvailable backpacks:"));
        for (String key : this.plugin.getConfig().getConfigurationSection("backpacks").getKeys(false)) {
            int size = this.plugin.getConfig().getInt("backpacks." + key + ".size");
            String perm = "smartbackpacks.open." + key;
            sender.sendMessage(Utils.msgRaw("&e- &f" + key + " | size: " + size + " | perm: " + perm));
        }
    }

    private void handleAdd(CommandSender sender, String[] args) {
        int size;
        if (args.length < 4) {
            sender.sendMessage(Utils.msg("not-enough-args"));
            return;
        }
        String name = args[1].toLowerCase();
        if (this.plugin.getConfig().contains("backpacks." + name)) {
            Map<String, String> vars = Map.of("name", name);
            sender.sendMessage(Utils.msg("add-exists", vars));
            return;
        }
        try {
            size = Integer.parseInt(args[2]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(Utils.msg("invalid-number"));
            return;
        }
        if (size < 9 || size > 54 || size % 9 != 0) {
            sender.sendMessage(Utils.msg("add-invalid-size"));
            return;
        }
        StringBuilder titleBuilder = new StringBuilder();
        for (int i = 3; i < args.length; ++i) {
            if (i > 3) {
                titleBuilder.append(" ");
            }
            titleBuilder.append(args[i]);
        }
        String title = titleBuilder.toString();
        this.plugin.getConfig().set("backpacks." + name + ".size", size);
        this.plugin.getConfig().set("backpacks." + name + ".title", title);
        this.plugin.saveConfig();
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("name", name);
        vars.put("size", String.valueOf(size));
        vars.put("title", title);
        sender.sendMessage(Utils.msg("add-success", vars));
    }

    private void handleRemove(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage(Utils.msg("not-enough-args"));
            return;
        }
        String name = args[1].toLowerCase();
        if (!this.plugin.getConfig().contains("backpacks." + name)) {
            Map<String, String> vars = Map.of("name", name);
            sender.sendMessage(Utils.msg("remove-not-found", vars));
            return;
        }
        this.plugin.getConfig().set("backpacks." + name, null);
        this.plugin.saveConfig();
        Map<String, String> vars = Map.of("name", name);
        sender.sendMessage(Utils.msg("remove-success", vars));
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            String[] subs;
            for (String sub : subs = new String[]{"open", "list", "add", "remove", "reload"}) {
                if (!sub.startsWith(args[0].toLowerCase())) continue;
                completions.add(sub);
            }
            return completions;
        }
        if (args.length == 2 && (args[0].equalsIgnoreCase("open") || args[0].equalsIgnoreCase("remove"))) {
            for (String key : this.plugin.getConfig().getConfigurationSection("backpacks").getKeys(false)) {
                if (!key.startsWith(args[1].toLowerCase())) continue;
                completions.add(key);
            }
            return completions;
        }
        return completions;
    }
}

