/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.roomopolis.item;

import com.benbenlaw.roomopolis.item.KeyItemPaletteCache;
import com.benbenlaw.roomopolis.item.KeyItemSizeCache;
import com.benbenlaw.roomopolis.util.DirectionUtil;
import com.benbenlaw.roomopolis.util.RoomopolisTags;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class KeyItem
extends Item {
    public ResourceLocation templateId;
    public int heightAdjustment;
    public int frontAdjustment;
    public Optional<Block> keyBlock;
    public Optional<TagKey<Block>> keyBlockTag;
    public boolean isPlaced;
    public boolean consumeKey;
    public Vec3i templateSize;
    boolean removeDoorArea;
    boolean sideOnlyPlacement;
    boolean topOnlyPlacement;
    boolean blocksRequired;
    public boolean overrideExistingBlocks;
    public int doorLeft;
    public int doorRight;
    public int doorUp;
    public int doorDown;
    public int maxHeight;

    public KeyItem(Item.Properties properties, String templateId, int heightAdjustment, int frontAdjustment, String keyBlock, boolean consumeKey, boolean removeDoorArea, boolean sideOnlyPlacement, boolean topOnlyPlacement, boolean blocksRequired, boolean overrideExistingBlocks, int doorLeft, int doorRight, int doorUp, int doorDown, int requiresHeight) {
        super(properties);
        this.templateId = ResourceLocation.parse((String)templateId);
        this.heightAdjustment = heightAdjustment;
        this.consumeKey = consumeKey;
        this.frontAdjustment = frontAdjustment;
        this.removeDoorArea = removeDoorArea;
        this.sideOnlyPlacement = sideOnlyPlacement;
        this.topOnlyPlacement = topOnlyPlacement;
        this.blocksRequired = blocksRequired;
        this.overrideExistingBlocks = overrideExistingBlocks;
        this.doorLeft = doorLeft;
        this.doorRight = doorRight;
        this.doorUp = doorUp;
        this.doorDown = doorDown;
        this.maxHeight = requiresHeight;
        if (keyBlock == null || keyBlock.isEmpty()) {
            this.keyBlock = Optional.empty();
            this.keyBlockTag = Optional.empty();
        } else if (keyBlock.startsWith("#")) {
            this.keyBlock = Optional.empty();
            this.keyBlockTag = Optional.of(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)keyBlock.substring(1))));
        } else {
            this.keyBlock = Optional.of((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)keyBlock)));
            this.keyBlockTag = Optional.empty();
        }
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        Rotation rotation = DirectionUtil.getRotationFromDirection(context.getClickedFace());
        Direction facing = context.getClickedFace().getOpposite();
        InteractionHand hand = context.getHand();
        assert (player != null);
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide()) {
            if (!this.hasEnoughBlocks(player, level)) {
                return InteractionResult.FAIL;
            }
            this.templateSize = KeyItemSizeCache.getTemplateSize(this.templateId);
            if (player.getItemInHand(hand).is((Item)this)) {
                if (this.keyBlock.isPresent() || this.keyBlockTag.isPresent()) {
                    if (this.keyBlock.isPresent() && state.is(this.keyBlock.get()) || this.keyBlockTag.isPresent() && state.is(this.keyBlockTag.get())) {
                        int clickedOnY = pos.getY();
                        if (this.maxHeight <= clickedOnY) {
                            player.sendSystemMessage((Component)Component.translatable((String)"item.key.too_high", (Object[])new Object[]{this.maxHeight}).withStyle(ChatFormatting.RED));
                            return InteractionResult.FAIL;
                        }
                        if (this.topOnlyPlacement && context.getClickedFace() != Direction.UP) {
                            player.sendSystemMessage((Component)Component.translatable((String)"item.key.top_only").withStyle(ChatFormatting.RED));
                            return InteractionResult.FAIL;
                        }
                        if (this.sideOnlyPlacement && (context.getClickedFace() == Direction.UP || context.getClickedFace() == Direction.DOWN)) {
                            player.sendSystemMessage((Component)Component.translatable((String)"item.key.side_only").withStyle(ChatFormatting.RED));
                            return InteractionResult.FAIL;
                        }
                        BlockPos placePosition = pos;
                        if (context.getClickedFace() == Direction.UP) {
                            placePosition = new BlockPos(pos.getX(), pos.getY() + 3, pos.getZ());
                            rotation = DirectionUtil.getRotationFromDirection(context.getHorizontalDirection().getOpposite());
                            this.removeDoorArea = false;
                        }
                        if (this.isStructureTooLarge()) {
                            player.sendSystemMessage((Component)Component.translatable((String)"item.key.too_large").withStyle(ChatFormatting.RED));
                            return InteractionResult.FAIL;
                        }
                        this.createTemplate(level, rotation, facing, placePosition);
                        if (this.isPlaced) {
                            player.sendSystemMessage((Component)Component.translatable((String)"item.key.placed").withStyle(ChatFormatting.GREEN));
                            if (this.removeDoorArea) {
                                Direction placementFacing = context.getClickedFace().getAxis().isVertical() ? context.getHorizontalDirection().getOpposite() : context.getClickedFace().getOpposite();
                                this.removeDoor(level, pos, placementFacing);
                            }
                            this.consumeBlocks(player, level);
                            if (this.consumeKey) {
                                player.getItemInHand(hand).shrink(1);
                            }
                        } else {
                            player.sendSystemMessage((Component)Component.translatable((String)"item.key.area_not_empty").withStyle(ChatFormatting.RED));
                        }
                    } else {
                        player.sendSystemMessage((Component)Component.translatable((String)"item.key.requires_key_block", (Object[])new Object[]{this.keyBlock.map(Block::getName).orElse(Component.literal((String)"Unknown Block"))}).withStyle(ChatFormatting.RED));
                    }
                } else {
                    if (context.getClickedFace() == Direction.DOWN) {
                        player.sendSystemMessage((Component)Component.translatable((String)"item.key.invalid_placement").withStyle(ChatFormatting.RED));
                        return InteractionResult.FAIL;
                    }
                    BlockPos placePosition = pos;
                    if (context.getClickedFace() == Direction.UP) {
                        placePosition = new BlockPos(pos.getX(), pos.getY() + 3, pos.getZ());
                        rotation = DirectionUtil.getRotationFromDirection(context.getHorizontalDirection().getOpposite());
                    }
                    if (this.isStructureTooLarge()) {
                        player.sendSystemMessage((Component)Component.translatable((String)"item.key.too_large").withStyle(ChatFormatting.RED));
                        return InteractionResult.FAIL;
                    }
                    this.createTemplate(level, rotation, facing, placePosition);
                    if (this.isPlaced) {
                        player.sendSystemMessage((Component)Component.translatable((String)"item.key.placed").withStyle(ChatFormatting.GREEN));
                        if (this.consumeKey) {
                            player.getItemInHand(hand).shrink(1);
                        }
                        this.consumeBlocks(player, level);
                    } else {
                        player.sendSystemMessage((Component)Component.translatable((String)"item.key.area_not_empty").withStyle(ChatFormatting.RED));
                    }
                }
            }
        }
        this.isPlaced = false;
        return super.useOn(context);
    }

    public Map<Block, Integer> getRequiredBlocks(Level level) {
        HashMap<Block, Integer> blockCounts = new HashMap<Block, Integer>();
        HashMap<Block, Integer> halfCountMap = new HashMap<Block, Integer>();
        StructureTemplateManager structureManager = Objects.requireNonNull(level.getServer()).getStructureManager();
        Optional optionalTemplate = structureManager.get(this.templateId);
        if (optionalTemplate.isPresent()) {
            StructureTemplate.Palette palette = (StructureTemplate.Palette)((StructureTemplate)optionalTemplate.get()).palettes.getFirst();
            for (StructureTemplate.StructureBlockInfo structureBlockInfo : palette.blocks()) {
                Block block = structureBlockInfo.state().getBlock();
                if (block == Blocks.AIR) continue;
                if (block.builtInRegistryHolder().is(RoomopolisTags.Blocks.DOUBLE_BLOCKS)) {
                    halfCountMap.put(block, halfCountMap.getOrDefault(block, 0) + 1);
                    continue;
                }
                blockCounts.put(block, blockCounts.getOrDefault(block, 0) + 1);
            }
            for (Map.Entry entry : halfCountMap.entrySet()) {
                int adjusted = ((Integer)entry.getValue() + 1) / 2;
                blockCounts.put((Block)entry.getKey(), adjusted);
            }
        }
        return blockCounts;
    }

    public void consumeBlocks(Player player, Level level) {
        if (player.isCreative()) {
            return;
        }
        if (this.blocksRequired) {
            Map<Block, Integer> requiredBlocks = this.getRequiredBlocks(level);
            block0: for (Map.Entry<Block, Integer> entry : requiredBlocks.entrySet()) {
                Block requiredBlock = entry.getKey();
                int requiredAmount = entry.getValue();
                for (int i = 0; i < player.getInventory().items.size(); ++i) {
                    BlockItem blockItem;
                    ItemStack stack = (ItemStack)player.getInventory().items.get(i);
                    Item item = stack.getItem();
                    if (!(item instanceof BlockItem) || (blockItem = (BlockItem)item).getBlock() != requiredBlock) continue;
                    int availableAmount = stack.getCount();
                    if (requiredAmount >= availableAmount) {
                        player.getInventory().items.set(i, (Object)ItemStack.EMPTY);
                        requiredAmount -= availableAmount;
                    } else {
                        stack.shrink(requiredAmount);
                        requiredAmount = 0;
                    }
                    if (requiredAmount <= 0) continue block0;
                }
            }
        }
    }

    public boolean hasEnoughBlocks(Player player, Level level) {
        Block block;
        if (!this.blocksRequired) {
            return true;
        }
        if (player.isCreative()) {
            return true;
        }
        Map<Block, Integer> requiredBlocks = this.getRequiredBlocks(level);
        HashMap<Block, Integer> playerBlocks = new HashMap<Block, Integer>();
        HashMap<Block, Integer> missingBlocks = new HashMap<Block, Integer>();
        for (ItemStack itemStack : player.getInventory().items) {
            Item item = itemStack.getItem();
            if (!(item instanceof BlockItem)) continue;
            BlockItem blockItem = (BlockItem)item;
            Block block2 = blockItem.getBlock();
            playerBlocks.put(block2, playerBlocks.getOrDefault(block2, 0) + itemStack.getCount());
        }
        for (Map.Entry<Block, Integer> entry : requiredBlocks.entrySet()) {
            block = entry.getKey();
            int requiredAmount = entry.getValue();
            int availableAmount = playerBlocks.getOrDefault(block, 0);
            if (availableAmount >= requiredAmount) continue;
            int missingAmount = requiredAmount - availableAmount;
            missingBlocks.put(block, missingAmount);
        }
        if (!missingBlocks.isEmpty()) {
            player.sendSystemMessage((Component)Component.translatable((String)"item.key.missing_blocks").withStyle(ChatFormatting.RED));
            for (Map.Entry<Object, Integer> entry : missingBlocks.entrySet()) {
                block = (Block)entry.getKey();
                int missingAmount = entry.getValue();
                int stacks = missingAmount / block.asItem().getDefaultInstance().getMaxStackSize();
                int remaining = missingAmount % block.asItem().getDefaultInstance().getMaxStackSize();
                MutableComponent message = Component.literal((String)"- ").append((Component)block.getName()).append(": ").append((Component)Component.literal((String)String.valueOf(missingAmount)));
                if (stacks > 0) {
                    message = message.append((Component)Component.literal((String)" (")).append((Component)Component.literal((String)String.valueOf(stacks))).append((Component)Component.literal((String)" stack")).append((Component)(stacks > 1 ? Component.literal((String)"s") : Component.empty())).append((Component)(remaining > 0 ? Component.literal((String)(" + " + remaining)) : Component.empty())).append((Component)Component.literal((String)")"));
                }
                message = message.withStyle(ChatFormatting.YELLOW);
                player.sendSystemMessage((Component)message);
            }
            return false;
        }
        return true;
    }

    private boolean isStructureTooLarge() {
        int sizeX = this.templateSize.getX();
        int sizeY = this.templateSize.getY();
        int sizeZ = this.templateSize.getZ();
        return sizeX > 48 || sizeY > 48 || sizeZ > 48;
    }

    public void createTemplate(Level level, Rotation rotation, Direction facing, BlockPos pos) {
        StructureTemplateManager structureManager = Objects.requireNonNull(level.getServer()).getStructureManager();
        Optional optionalTemplate = structureManager.get(this.templateId);
        StructurePlaceSettings placementSettings = new StructurePlaceSettings().setRotation(rotation).setMirror(Mirror.NONE).setIgnoreEntities(false);
        if (optionalTemplate.isPresent()) {
            BlockPos worldPos;
            BlockPos rotatedPos;
            BlockPos relPos;
            int z;
            int y;
            int x;
            StructureTemplate template = (StructureTemplate)optionalTemplate.get();
            BlockPos centerOffset = new BlockPos(-this.templateSize.getX() / 2, -this.templateSize.getY() / 2, -this.templateSize.getZ() / 2);
            BlockPos adjustedOffset = StructureTemplate.calculateRelativePosition((StructurePlaceSettings)placementSettings, (BlockPos)centerOffset);
            int forwardShift = Math.max(this.templateSize.getX() / 2, 1) + 1 + this.frontAdjustment;
            BlockPos forwardOffset = pos.relative(facing, forwardShift);
            BlockPos placementPos = forwardOffset.offset((Vec3i)adjustedOffset);
            placementPos = placementPos.above(this.heightAdjustment);
            boolean isEmpty = true;
            if (!this.overrideExistingBlocks) {
                for (x = 0; x < this.templateSize.getX(); ++x) {
                    for (y = 0; y < this.templateSize.getY(); ++y) {
                        for (z = 0; z < this.templateSize.getZ(); ++z) {
                            relPos = new BlockPos(x, y, z);
                            rotatedPos = StructureTemplate.calculateRelativePosition((StructurePlaceSettings)placementSettings, (BlockPos)relPos);
                            worldPos = placementPos.offset((Vec3i)rotatedPos);
                            if (level.getBlockState(worldPos).isAir() || worldPos.equals((Object)pos)) continue;
                            isEmpty = false;
                            break;
                        }
                        if (!isEmpty) break;
                    }
                    if (!isEmpty) break;
                }
            }
            if (isEmpty || this.overrideExistingBlocks) {
                template.placeInWorld((ServerLevelAccessor)level, placementPos, placementPos, placementSettings, level.getRandom(), 3);
                this.isPlaced = true;
                for (x = 0; x < this.templateSize.getX(); ++x) {
                    for (y = 0; y < this.templateSize.getY(); ++y) {
                        for (z = 0; z < this.templateSize.getZ(); ++z) {
                            relPos = new BlockPos(x, y, z);
                            rotatedPos = StructureTemplate.calculateRelativePosition((StructurePlaceSettings)placementSettings, (BlockPos)relPos);
                            worldPos = placementPos.offset((Vec3i)rotatedPos);
                            level.sendBlockUpdated(worldPos, level.getBlockState(worldPos), level.getBlockState(worldPos), 3);
                        }
                    }
                }
            } else {
                System.out.println("Target location is not empty. Structure placement aborted.");
            }
        } else {
            System.out.println("Structure not found: " + String.valueOf(this.templateId));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        Map<Block, Integer> blockMap = KeyItemPaletteCache.getTemplatePalette(this.templateId);
        LocalPlayer player = Minecraft.getInstance().player;
        if (Screen.hasShiftDown()) {
            if (this.templateSize == null && Minecraft.getInstance().player != null) {
                this.templateSize = KeyItemSizeCache.getTemplateSize(this.templateId);
            }
            if (this.consumeKey) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltips.key.consume_key").withStyle(ChatFormatting.GRAY));
            } else {
                tooltipComponents.add((Component)Component.translatable((String)"tooltips.key.retain_key").withStyle(ChatFormatting.GRAY));
            }
            if (this.overrideExistingBlocks) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltips.key.override_existing_blocks").withStyle(ChatFormatting.GRAY));
            } else {
                tooltipComponents.add((Component)Component.translatable((String)"tooltips.key.normal_checks").withStyle(ChatFormatting.GRAY));
            }
            if (this.removeDoorArea) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltips.key.remove_door_area", (Object[])new Object[]{this.doorLeft, this.doorRight, this.doorUp, this.doorDown}).withStyle(ChatFormatting.GRAY));
            }
            if (this.sideOnlyPlacement) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltips.key.side_only").withStyle(ChatFormatting.GRAY));
            }
            if (this.topOnlyPlacement) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltips.key.top_only").withStyle(ChatFormatting.GRAY));
            }
            if (this.templateSize != null) {
                MutableComponent templateSizeText = Component.translatable((String)"tooltips.key.template_size", (Object[])new Object[]{this.templateSize.getX(), this.templateSize.getY(), this.templateSize.getZ()}).withStyle(ChatFormatting.GRAY);
                tooltipComponents.add((Component)templateSizeText);
            }
            this.keyBlock.ifPresent(block -> tooltipComponents.add((Component)Component.translatable((String)"tooltips.key.requires_key_block", (Object[])new Object[]{block.getName()}).withStyle(ChatFormatting.RED)));
            if (this.keyBlockTag.isPresent()) {
                String tag = this.keyBlockTag.get().location().toString();
                tooltipComponents.add((Component)Component.translatable((String)"tooltips.key.requires_key_block", (Object[])new Object[]{tag}).withStyle(ChatFormatting.RED));
            }
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltips.roomopolis.shift").withStyle(ChatFormatting.YELLOW));
        }
        if (this.blocksRequired) {
            if (Screen.hasAltDown()) {
                if (blockMap != null && player != null) {
                    HashMap<Block, Integer> playerBlocks = new HashMap<Block, Integer>();
                    for (ItemStack itemStack : player.getInventory().items) {
                        Item item = itemStack.getItem();
                        if (!(item instanceof BlockItem)) continue;
                        BlockItem blockItem = (BlockItem)item;
                        Block block2 = blockItem.getBlock();
                        playerBlocks.put(block2, playerBlocks.getOrDefault(block2, 0) + itemStack.getCount());
                    }
                    tooltipComponents.add((Component)Component.translatable((String)"tooltips.key.required_blocks").withStyle(ChatFormatting.GRAY));
                    for (Map.Entry<Block, Integer> entry : blockMap.entrySet()) {
                        Block block3 = entry.getKey();
                        int requiredCount = entry.getValue();
                        int playerCount = playerBlocks.getOrDefault(block3, 0);
                        ChatFormatting color = playerCount >= requiredCount ? ChatFormatting.GREEN : ChatFormatting.RED;
                        String tooltipText = requiredCount + "x " + block3.getName().getString();
                        tooltipText = playerCount >= requiredCount ? "(\u2714) " + tooltipText : "(\u274c) " + tooltipText;
                        tooltipComponents.add((Component)Component.literal((String)tooltipText).withStyle(color));
                    }
                }
            } else {
                tooltipComponents.add((Component)Component.translatable((String)"tooltips.roomopolis.alt").withStyle(ChatFormatting.YELLOW));
            }
        }
    }

    private void removeDoor(Level level, BlockPos centerPos, Direction horizontalFacing) {
        if (!horizontalFacing.getAxis().isHorizontal()) {
            horizontalFacing = Direction.NORTH;
        }
        Direction leftDir = horizontalFacing.getCounterClockWise().getOpposite();
        for (int x = -this.doorLeft; x <= this.doorRight; ++x) {
            for (int y = -this.doorDown; y <= this.doorUp; ++y) {
                BlockPos offset = centerPos.relative(leftDir, x).above(y);
                BlockState current = level.getBlockState(offset);
                if (current.isAir()) continue;
                level.setBlockAndUpdate(offset, Blocks.AIR.defaultBlockState());
                level.sendBlockUpdated(offset, current, Blocks.AIR.defaultBlockState(), 3);
            }
        }
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int p_41407_, boolean p_41408_) {
        Player player = (Player)entity;
        Item item = player.getMainHandItem().getItem();
        if (item instanceof KeyItem) {
            KeyItem keyItem = (KeyItem)item;
            if (keyItem.overrideExistingBlocks) {
                player.displayClientMessage((Component)Component.translatable((String)"message.key.overrides_blocks").withStyle(ChatFormatting.RED), true);
            }
        }
    }
}

