/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.roomopolis.item;

import com.benbenlaw.roomopolis.block.custom.RoomBlock;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class WallRemoverKeyItem
extends Item {
    public WallRemoverKeyItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        Direction direction = context.getClickedFace();
        if (!level.isClientSide() && state.getBlock() instanceof RoomBlock) {
            BlockPos behindPos = pos.relative(direction.getOpposite());
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            level.sendBlockUpdated(pos, level.getBlockState(pos), level.getBlockState(pos), 3);
        }
        return super.useOn(context);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltips.key.wall_remover").withStyle(ChatFormatting.GOLD));
    }
}

