/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.afc;

import com.mojang.logging.LogUtils;
import com.therighthon.afc.common.AFCCreativeModeTabs;
import com.therighthon.afc.common.blockentities.AFCBlockEntities;
import com.therighthon.afc.common.blocks.AFCBlocks;
import com.therighthon.afc.common.blocks.AFCWood;
import com.therighthon.afc.common.entities.AFCEntities;
import com.therighthon.afc.common.fluids.AFCFluids;
import com.therighthon.afc.common.items.AFCItems;
import com.therighthon.afc.common.recipe.AFCRecipeSerializers;
import com.therighthon.afc.common.recipe.AFCRecipeTypes;
import com.therighthon.afc.event.ModEventClientBusEvents;
import com.therighthon.afc.event.ModEvents;
import com.therighthon.afc.mixin.BlockEntityTypeAccessor;
import java.util.HashSet;
import java.util.stream.Stream;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.util.Metal;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import org.slf4j.Logger;

@Mod(value="afc")
public final class AFC {
    public static final String MOD_ID = "afc";
    public static final String MOD_NAME = "ArborFirmaCraft";
    public static final Logger LOGGER = LogUtils.getLogger();

    public AFC(ModContainer modContainer, IEventBus eventBus) {
        eventBus.addListener(this::setup);
        eventBus.addListener(ModEvents::onPackFinder);
        AFCBlocks.BLOCKS.register(eventBus);
        AFCBlocks.FLUID_BLOCKS.register(eventBus);
        AFCItems.ITEMS.register(eventBus);
        AFCFluids.FLUID_TYPES.register(eventBus);
        AFCFluids.FLUIDS.register(eventBus);
        AFCEntities.ENTITIES.register(eventBus);
        AFCBlockEntities.BLOCK_ENTITIES.register(eventBus);
        AFCRecipeTypes.RECIPE_TYPES.register(eventBus);
        AFCRecipeSerializers.RECIPE_SERIALIZERS.register(eventBus);
        AFCCreativeModeTabs.CREATIVE_TABS.register(eventBus);
        if (ModList.get().isLoaded("firmalife")) {
            ModEvents.initFLCompat();
        }
        if (FMLEnvironment.dist == Dist.CLIENT) {
            eventBus.addListener(ModEventClientBusEvents::clientSetup);
            eventBus.addListener(ModEventClientBusEvents::registerClientReloadListeners);
            eventBus.addListener(ModEventClientBusEvents::registerEntityLayers);
            eventBus.addListener(ModEventClientBusEvents::registerColorHandlerBlocks);
            eventBus.addListener(ModEventClientBusEvents::registerColorHandlerItems);
            eventBus.addListener(ModEventClientBusEvents::onLayers);
            eventBus.addListener(ModEventClientBusEvents::registerExtensions);
            if (ModList.get().isLoaded("firmalife")) {
                // empty if block
            }
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("AFC COMMON SETUP");
        event.enqueueWork(AFCWood::registerBlockSetTypes);
        event.enqueueWork(() -> {
            AFCBlocks.registerFlowerPotFlowers();
            AFC.modifyBlockEntityTypes();
        });
    }

    private static void modifyBlockEntityTypes() {
        AFC.modifyWood((BlockEntityType)TFCBlockEntities.CHEST.get(), Wood.BlockType.CHEST);
        AFC.modifyWood((BlockEntityType)TFCBlockEntities.TRAPPED_CHEST.get(), Wood.BlockType.TRAPPED_CHEST);
        AFC.modifyWood((BlockEntityType)TFCBlockEntities.LOOM.get(), Wood.BlockType.LOOM);
        AFC.modifyWood((BlockEntityType)TFCBlockEntities.BARREL.get(), Wood.BlockType.BARREL);
        AFC.modifyWood((BlockEntityType)TFCBlockEntities.SLUICE.get(), Wood.BlockType.SLUICE);
        AFC.modifyWood((BlockEntityType)TFCBlockEntities.BOOKSHELF.get(), Wood.BlockType.BOOKSHELF);
        AFC.modifyWood((BlockEntityType)TFCBlockEntities.TOOL_RACK.get(), Wood.BlockType.TOOL_RACK);
        AFC.modifyWood((BlockEntityType)TFCBlockEntities.LECTERN.get(), Wood.BlockType.LECTERN);
        AFC.modifyWood((BlockEntityType)TFCBlockEntities.AXLE.get(), Wood.BlockType.AXLE);
        AFC.modifyWood((BlockEntityType)TFCBlockEntities.BLADED_AXLE.get(), Wood.BlockType.BLADED_AXLE);
        AFC.modifyWood((BlockEntityType)TFCBlockEntities.WATER_WHEEL.get(), Wood.BlockType.WATER_WHEEL);
        AFC.modifyWood((BlockEntityType)TFCBlockEntities.WINDMILL.get(), Wood.BlockType.WINDMILL);
        AFC.modifyWood((BlockEntityType)TFCBlockEntities.TICK_COUNTER.get(), Wood.BlockType.SAPLING);
        AFC.modifyWood((BlockEntityType)TFCBlockEntities.SIGN.get(), Wood.BlockType.SIGN);
        AFC.modifyWood((BlockEntityType)TFCBlockEntities.SIGN.get(), Wood.BlockType.WALL_SIGN);
        for (Metal metal : Metal.values()) {
            if (!metal.allParts()) continue;
            for (AFCWood wood : AFCWood.values()) {
                AFC.modifyBlockEntityType((BlockEntityType)TFCBlockEntities.HANGING_SIGN.get(), Stream.of((Block)AFCBlocks.CEILING_HANGING_SIGNS.get((Object)wood).get(metal).get()));
                AFC.modifyBlockEntityType((BlockEntityType)TFCBlockEntities.HANGING_SIGN.get(), Stream.of((Block)AFCBlocks.WALL_HANGING_SIGNS.get((Object)wood).get(metal).get()));
            }
        }
    }

    private static void modifyWood(BlockEntityType<?> type, Wood.BlockType blockType) {
        AFC.modifyBlockEntityType(type, AFCBlocks.WOODS.values().stream().map(map -> (Block)((AFCBlocks.Id)map.get(blockType)).get()));
    }

    private static void modifyBlockEntityType(BlockEntityType<?> type, Stream<Block> extraBlocks) {
        HashSet<Block> blocks = type.getValidBlocks();
        blocks = new HashSet<Block>(blocks);
        blocks.addAll(extraBlocks.toList());
        ((BlockEntityTypeAccessor)type).accessor$setValidBlocks(blocks);
    }
}

