/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.afc.common;

import com.therighthon.afc.AFC;
import com.therighthon.afc.common.blocks.AFCBlocks;
import com.therighthon.afc.common.blocks.AFCWood;
import com.therighthon.afc.common.blocks.TreeSpecies;
import com.therighthon.afc.common.blocks.UniqueLogs;
import com.therighthon.afc.common.fluids.AFCFluids;
import com.therighthon.afc.common.items.AFCItems;
import java.util.Map;
import java.util.function.Supplier;
import net.dries007.tfc.util.Metal;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class AFCCreativeModeTabs {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"afc");
    public static final Id AFC_TAB = AFCCreativeModeTabs.register("arborfirmacraft", () -> new ItemStack((ItemLike)AFCBlocks.TREE_SPECIES.get(TreeSpecies.TAMARACK).get((Object)TreeSpecies.BlockType.SAPLING).get()), AFCCreativeModeTabs::fillTab);

    private static void fillTab(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output out) {
        out.accept((ItemLike)AFCItems.RUBBER_BAR.get());
        out.accept((ItemLike)AFCItems.MAPLE_SUGAR.get());
        out.accept((ItemLike)AFCItems.BIRCH_SUGAR.get());
        out.accept((ItemLike)AFCBlocks.TREE_TAP.get());
        AFCFluids.FLUIDS.getEntries().forEach(fluid -> out.accept((ItemLike)((Fluid)fluid.value()).getBucket()));
        for (AFCWood aFCWood : AFCWood.VALUES) {
            AFCBlocks.WOODS.get((Object)aFCWood).forEach((type, reg) -> {
                if (type.needsItem()) {
                    AFCCreativeModeTabs.accept(out, reg);
                }
            });
            AFCCreativeModeTabs.accept(out, AFCItems.LUMBER, aFCWood);
            AFCCreativeModeTabs.accept(out, AFCItems.BOATS, aFCWood);
            AFCCreativeModeTabs.accept(out, AFCItems.SUPPORTS, aFCWood);
            AFCCreativeModeTabs.accept(out, AFCItems.CHEST_MINECARTS, aFCWood);
            AFCCreativeModeTabs.accept(out, AFCItems.SIGNS, aFCWood);
            for (Metal metal : Metal.values()) {
                AFCCreativeModeTabs.accept(out, AFCItems.HANGING_SIGNS.get((Object)aFCWood), metal);
            }
        }
        for (Enum enum_ : TreeSpecies.VALUES) {
            AFCBlocks.TREE_SPECIES.get(enum_).forEach((type, reg) -> {
                if (type.needsItem()) {
                    AFCCreativeModeTabs.accept(out, reg);
                }
            });
        }
        for (Enum enum_ : UniqueLogs.VALUES) {
            AFCBlocks.UNIQUE_LOGS.get(enum_).forEach((type, reg) -> AFCCreativeModeTabs.accept(out, reg));
        }
    }

    private static Id register(String name, Supplier<ItemStack> icon, CreativeModeTab.DisplayItemsGenerator displayItems) {
        DeferredHolder holder = CREATIVE_TABS.register(name, () -> CreativeModeTab.builder().icon(icon).title((Component)Component.translatable((String)("afc.creative_tab." + name))).displayItems(displayItems).build());
        return new Id((DeferredHolder<CreativeModeTab, CreativeModeTab>)holder, displayItems);
    }

    private static <T extends ItemLike, R extends Supplier<T>, K1, K2> void accept(CreativeModeTab.Output out, Map<K1, Map<K2, R>> map, K1 key1, K2 key2) {
        if (map.containsKey(key1) && map.get(key1).containsKey(key2)) {
            out.accept((ItemLike)((Supplier)map.get(key1).get(key2)).get());
        }
    }

    private static <T extends ItemLike, R extends Supplier<T>, K> void accept(CreativeModeTab.Output out, Map<K, R> map, K key) {
        if (map.containsKey(key)) {
            out.accept((ItemLike)((Supplier)map.get(key)).get());
        }
    }

    private static <T extends ItemLike, R extends Supplier<T>> void accept(CreativeModeTab.Output out, R reg) {
        if (((ItemLike)reg.get()).asItem() == Items.AIR) {
            AFC.LOGGER.error("BlockItem with no Item added to creative tab: " + String.valueOf(reg));
            return;
        }
        out.accept((ItemLike)reg.get());
    }

    public record Id(DeferredHolder<CreativeModeTab, CreativeModeTab> tab, CreativeModeTab.DisplayItemsGenerator generator) {
    }
}

