/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.afc.common.blockentities;

import com.therighthon.afc.common.AFCTags;
import com.therighthon.afc.common.blockentities.AFCBlockEntities;
import com.therighthon.afc.common.blocks.TapBlock;
import com.therighthon.afc.common.recipe.TreeTapRecipe;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.client.overworld.SolarCalculator;
import net.dries007.tfc.client.particle.FluidParticleOption;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.blocks.wood.BranchDirection;
import net.dries007.tfc.common.blocks.wood.LogBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.Month;
import net.dries007.tfc.util.climate.Climate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class TapBlockEntity
extends BlockEntity {
    public TapBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)AFCBlockEntities.TAP_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, TapBlockEntity tap) {
        Direction facing = (Direction)state.getValue((Property)TapBlock.FACING);
        tap.tickPouring(level, pos, facing);
    }

    public static boolean isSpring(Level level, BlockPos pos) {
        Month currentMonth = Calendars.SERVER.getHemispheralCalendarMonthOfYear(SolarCalculator.getInNorthernHemisphere((BlockPos)pos, (Level)level));
        return currentMonth == Month.FEBRUARY || currentMonth == Month.MARCH || currentMonth == Month.APRIL || currentMonth == Month.MAY || currentMonth == Month.JUNE;
    }

    public static boolean isTempOkay(Level level, BlockPos pos, float minTemp, float maxTemp) {
        float currentTemp = Climate.getTemperature((Level)level, (BlockPos)pos);
        return currentTemp >= minTemp && currentTemp <= maxTemp;
    }

    public static boolean hasValidTrunk(Level level, BlockPos pos, BlockState state) {
        BlockState aboveState = level.getBlockState(pos.above());
        BlockState belowState = level.getBlockState(pos.below());
        return aboveState == state && belowState == state;
    }

    public static int getTapCount(Level level, BlockPos pos) {
        int tapCount = 0;
        if (Helpers.isBlock((BlockState)level.getBlockState(pos.north()), AFCTags.Blocks.TREE_TAPS)) {
            ++tapCount;
        }
        if (Helpers.isBlock((BlockState)level.getBlockState(pos.east()), AFCTags.Blocks.TREE_TAPS)) {
            ++tapCount;
        }
        if (Helpers.isBlock((BlockState)level.getBlockState(pos.south()), AFCTags.Blocks.TREE_TAPS)) {
            ++tapCount;
        }
        if (Helpers.isBlock((BlockState)level.getBlockState(pos.west()), AFCTags.Blocks.TREE_TAPS)) {
            ++tapCount;
        }
        if (tapCount == 0) {
            return 1;
        }
        return tapCount;
    }

    public void tickPouring(Level level, BlockPos pos, Direction facing) {
        if (level.getGameTime() % 20L == 0L) {
            BlockPos logPos = switch (facing) {
                case Direction.NORTH -> pos.south();
                case Direction.SOUTH -> pos.north();
                case Direction.EAST -> pos.west();
                case Direction.WEST -> pos.east();
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(facing));
            };
            BlockState logState = level.getBlockState(logPos);
            TreeTapRecipe recipe = TreeTapRecipe.getRecipe(logState);
            if (recipe != null) {
                IFluidHandler fluidHandler;
                BlockPos pourPos;
                BlockEntity blockEntity;
                int dripPeriod = 20 * TapBlockEntity.getTapCount(level, logPos);
                if (!(level.getGameTime() % (long)dripPeriod != 0L || (blockEntity = level.getBlockEntity(pourPos = pos.below())) == null || (fluidHandler = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, pourPos, (Object)Direction.UP)) == null || recipe.requiresNaturalLog().booleanValue() && logState.getValue((Property)LogBlock.BRANCH_DIRECTION) == BranchDirection.NONE || !TapBlockEntity.isTempOkay(level, pos, recipe.getMinTemp(), recipe.getMaxTemp()) || recipe.springOnly().booleanValue() && !TapBlockEntity.isSpring(level, pos) || !TapBlockEntity.hasValidTrunk(level, logPos, logState))) {
                    FluidStack fluidStack = recipe.getOutput();
                    if (level instanceof ServerLevel) {
                        double dx;
                        ServerLevel server = (ServerLevel)level;
                        fluidHandler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                        double offset = -0.2;
                        double d = facing.getStepX() > 0 ? -0.2 : (dx = facing.getStepX() < 0 ? 0.2 : 0.0);
                        double dz = facing.getStepZ() > 0 ? -0.2 : (facing.getStepZ() < 0 ? 0.2 : 0.0);
                        double x = (double)((float)pos.getX() + 0.5f) + dx;
                        double y = (float)pos.getY() + 0.125f;
                        double z = (double)((float)pos.getZ() + 0.5f) + dz;
                        Helpers.playSound((Level)level, (BlockPos)pos, (SoundEvent)((SoundEvent)TFCSounds.BARREL_DRIP.get()));
                        server.sendParticles((ParticleOptions)new FluidParticleOption((ParticleType)TFCParticles.BARREL_DRIP.get(), fluidStack.getFluid()), x, y, z, 1, 0.0, 0.0, 0.0, 1.0);
                    }
                }
            }
        }
    }
}

