/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.afc.common.blocks;

import com.therighthon.afc.common.blocks.AFCBlocks;
import com.therighthon.afc.common.blocks.AFCWood;
import com.therighthon.afc.common.blocks.RegistryAncientLogs;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.wood.LogBlock;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.Nullable;

public enum AncientLogs implements RegistryAncientLogs
{
    ANCIENT_EUCALYPTUS(MapColor.WOOD, MapColor.WOOD, AFCWood.EUCALYPTUS, 0.7f),
    ANCIENT_BAOBAB(MapColor.WOOD, MapColor.WOOD, AFCWood.BAOBAB, 0.75f),
    ANCIENT_MAHOGANY(MapColor.WOOD, MapColor.WOOD, AFCWood.MAHOGANY, 0.7f),
    ANCIENT_HEVEA(MapColor.WOOD, MapColor.WOOD, AFCWood.HEVEA, 0.9f),
    ANCIENT_TEAK(MapColor.WOOD, MapColor.WOOD, AFCWood.TEAK, 0.75f),
    ANCIENT_TUALANG(MapColor.WOOD, MapColor.WOOD, AFCWood.TUALANG, 0.9f),
    ANCIENT_CYPRESS(MapColor.WOOD, MapColor.WOOD, AFCWood.CYPRESS, 0.9f),
    ANCIENT_FIG(MapColor.WOOD, MapColor.WOOD, AFCWood.FIG, 0.9f),
    ANCIENT_IRONWOOD(MapColor.WOOD, MapColor.WOOD, AFCWood.IRONWOOD, 0.8f),
    ANCIENT_IPE(MapColor.WOOD, MapColor.WOOD, AFCWood.IPE, 0.9f),
    ANCIENT_ARAUCARIA(MapColor.WOOD, MapColor.WOOD, AFCWood.ARAUCARIA, 0.9f),
    ANCIENT_BEECH(MapColor.WOOD, MapColor.WOOD, AFCWood.BEECH, 0.9f),
    ANCIENT_GINKGO(MapColor.WOOD, MapColor.WOOD, AFCWood.GINKGO, 0.9f),
    ANCIENT_MAHOE(MapColor.WOOD, MapColor.WOOD, AFCWood.MAHOE, 0.9f),
    ANCIENT_ACACIA(MapColor.WOOD, MapColor.WOOD, Wood.ACACIA, 0.7f),
    ANCIENT_ASH(MapColor.WOOD, MapColor.WOOD, Wood.ASH, 0.7f),
    ANCIENT_ASPEN(MapColor.WOOD, MapColor.WOOD, Wood.ASPEN, 0.9f),
    ANCIENT_BIRCH(MapColor.WOOD, MapColor.WOOD, Wood.BIRCH, 0.9f),
    ANCIENT_BLACKWOOD(MapColor.WOOD, MapColor.WOOD, Wood.BLACKWOOD, 0.9f),
    ANCIENT_CHESTNUT(MapColor.WOOD, MapColor.WOOD, Wood.CHESTNUT, 0.7f),
    ANCIENT_DOUGLAS_FIR(MapColor.WOOD, MapColor.WOOD, Wood.DOUGLAS_FIR, 0.7f),
    ANCIENT_HICKORY(MapColor.WOOD, MapColor.WOOD, Wood.HICKORY, 0.7f),
    ANCIENT_KAPOK(MapColor.WOOD, MapColor.WOOD, Wood.KAPOK, 0.6f),
    ANCIENT_MANGROVE(MapColor.WOOD, MapColor.WOOD, Wood.MANGROVE, 0.9f),
    ANCIENT_MAPLE(MapColor.WOOD, MapColor.WOOD, Wood.MAPLE, 0.7f),
    ANCIENT_OAK(MapColor.WOOD, MapColor.WOOD, Wood.OAK, 0.7f),
    ANCIENT_PALM(MapColor.WOOD, MapColor.WOOD, Wood.PALM, 0.9f),
    ANCIENT_PINE(MapColor.WOOD, MapColor.WOOD, Wood.PINE, 0.9f),
    ANCIENT_ROSEWOOD(MapColor.WOOD, MapColor.WOOD, Wood.ROSEWOOD, 0.7f),
    ANCIENT_SEQUOIA(MapColor.WOOD, MapColor.WOOD, Wood.SEQUOIA, 0.5f),
    ANCIENT_SPRUCE(MapColor.WOOD, MapColor.WOOD, Wood.SPRUCE, 0.7f),
    ANCIENT_SYCAMORE(MapColor.WOOD, MapColor.WOOD, Wood.SYCAMORE, 0.7f),
    ANCIENT_WHITE_CEDAR(MapColor.WOOD, MapColor.WOOD, Wood.WHITE_CEDAR, 0.9f),
    ANCIENT_WILLOW(MapColor.WOOD, MapColor.WOOD, Wood.WILLOW, 0.75f),
    ANCIENT_RAINBOW_EUCALYPTUS(MapColor.WOOD, MapColor.WOOD, AFCWood.EUCALYPTUS, 0.75f),
    ANCIENT_BLACK_OAK(MapColor.WOOD, MapColor.WOOD, Wood.OAK, 0.9f),
    ANCIENT_GUM_ARABIC(MapColor.WOOD, MapColor.WOOD, Wood.ACACIA, 0.9f),
    ANCIENT_REDCEDAR(MapColor.WOOD, MapColor.WOOD, AFCWood.CYPRESS, 0.7f),
    ANCIENT_RUBBER_FIG(MapColor.WOOD, MapColor.WOOD, AFCWood.FIG, 0.9f),
    ANCIENT_POPLAR(MapColor.WOOD, MapColor.WOOD, Wood.ASPEN, 0.9f),
    ANCIENT_KAURI(MapColor.WOOD, MapColor.WOOD, AFCWood.ARAUCARIA, 0.7f);

    public static final AncientLogs[] VALUES;
    private final String serializedName = this.name().toLowerCase(Locale.ROOT);
    private final MapColor woodColor;
    private final MapColor barkColor;
    @Nullable
    private final AFCWood AFCWoodType;
    @Nullable
    private final Wood TFCWoodType;
    private final boolean hasAFCWoodType;
    private final float dropChance;

    private AncientLogs(MapColor woodColor, MapColor barkColor, Wood WoodType2, float dropChance) {
        this.woodColor = woodColor;
        this.barkColor = barkColor;
        this.hasAFCWoodType = false;
        this.TFCWoodType = WoodType2;
        this.AFCWoodType = null;
        this.dropChance = dropChance;
    }

    private AncientLogs(MapColor woodColor, MapColor barkColor, AFCWood AFCWoodType, float dropChance) {
        this.woodColor = woodColor;
        this.barkColor = barkColor;
        this.hasAFCWoodType = true;
        this.TFCWoodType = null;
        this.AFCWoodType = AFCWoodType;
        this.dropChance = dropChance;
    }

    public String getSerializedName() {
        return this.serializedName;
    }

    @Override
    public MapColor woodColor() {
        return this.woodColor;
    }

    @Override
    public MapColor barkColor() {
        return this.barkColor;
    }

    @Override
    @Nullable
    public AFCWood AFCWoodType() {
        return this.AFCWoodType;
    }

    @Override
    @Nullable
    public Wood TFCWoodType() {
        return this.TFCWoodType;
    }

    @Override
    public boolean isAFCWoodType() {
        return this.hasAFCWoodType;
    }

    public float getDropChance() {
        return this.dropChance;
    }

    @Override
    public Supplier<Block> getBlock(BlockType type) {
        return (Supplier)((Object)AFCBlocks.ANCIENT_LOGS.get(this).get((Object)type));
    }

    static {
        VALUES = AncientLogs.values();
    }

    public static enum BlockType {
        LOG((self, ancient_log) -> new LogBlock(ExtendedProperties.of(state -> state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y ? ancient_log.woodColor() : ancient_log.barkColor()).strength(8.0f).sound(SoundType.WOOD).requiresCorrectToolForDrops().flammableLikeLogs(), ancient_log.isAFCWoodType() ? ancient_log.AFCWoodType().getBlock(Wood.BlockType.STRIPPED_LOG) : ancient_log.TFCWoodType().getBlock(Wood.BlockType.STRIPPED_LOG))),
        WOOD((self, ancient_log) -> new LogBlock(BlockType.properties(ancient_log).strength(8.0f).requiresCorrectToolForDrops().flammableLikeLogs(), ancient_log.isAFCWoodType() ? ancient_log.AFCWoodType().getBlock(Wood.BlockType.STRIPPED_WOOD) : ancient_log.TFCWoodType().getBlock(Wood.BlockType.STRIPPED_WOOD)));

        private final BiFunction<Block, Item.Properties, ? extends BlockItem> blockItemFactory;
        private final BiFunction<BlockType, RegistryAncientLogs, Block> blockFactory;

        private static ExtendedProperties properties(RegistryAncientLogs ancient_log) {
            return ExtendedProperties.of((MapColor)ancient_log.woodColor()).sound(SoundType.WOOD);
        }

        private BlockType(Function<RegistryAncientLogs, Block> blockFactory) {
            this((BlockType self, RegistryAncientLogs ancient_log) -> (Block)blockFactory.apply((RegistryAncientLogs)ancient_log));
        }

        private BlockType(BiFunction<BlockType, RegistryAncientLogs, Block> blockFactory) {
            this(blockFactory, BlockItem::new);
        }

        private BlockType(BiFunction<BlockType, RegistryAncientLogs, Block> blockFactory, BiFunction<Block, Item.Properties, ? extends BlockItem> blockItemFactory) {
            this.blockFactory = blockFactory;
            this.blockItemFactory = blockItemFactory;
        }

        public Supplier<Block> create(RegistryAncientLogs ancient_log) {
            return () -> this.blockFactory.apply(this, ancient_log);
        }

        public Function<Block, BlockItem> createBlockItem(Item.Properties properties) {
            return block -> this.blockItemFactory.apply((Block)block, properties);
        }

        public String nameFor(AncientLogs wood) {
            return ("wood/" + this.name() + "/" + wood.getSerializedName()).toLowerCase(Locale.ROOT);
        }
    }
}

