/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.afc.common.blocks;

import com.google.common.collect.ImmutableMap;
import com.therighthon.afc.common.AFCTags;
import java.util.Map;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class TapBlock
extends DeviceBlock {
    public static DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    protected static final VoxelShape NORTH_SHAPE = TapBlock.box((double)6.0, (double)0.0, (double)11.0, (double)10.0, (double)6.0, (double)16.0);
    protected static final VoxelShape SOUTH_SHAPE = TapBlock.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)6.0, (double)5.0);
    protected static final VoxelShape WEST_SHAPE = TapBlock.box((double)11.0, (double)0.0, (double)6.0, (double)16.0, (double)6.0, (double)10.0);
    protected static final VoxelShape EAST_SHAPE = TapBlock.box((double)0.0, (double)0.0, (double)6.0, (double)5.0, (double)6.0, (double)10.0);
    protected static final Map<Direction, VoxelShape> SHAPES = ImmutableMap.of((Object)Direction.NORTH, (Object)NORTH_SHAPE, (Object)Direction.SOUTH, (Object)SOUTH_SHAPE, (Object)Direction.WEST, (Object)WEST_SHAPE, (Object)Direction.EAST, (Object)EAST_SHAPE);

    public TapBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.NOOP);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue((Property)FACING));
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState attachedState = level.getBlockState(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite()));
        return Helpers.isBlock((BlockState)attachedState, AFCTags.Blocks.TAPPABLE_LOGS);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getClickedFace();
        if (direction.getAxis() != Direction.Axis.Y) {
            return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction);
        }
        return null;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING});
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }
}

