/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.afc.common.blocks;

import com.therighthon.afc.common.blocks.AFCBlocks;
import com.therighthon.afc.common.blocks.AFCWood;
import com.therighthon.afc.common.blocks.RegistryTreeSpecies;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.wood.FallenLeavesBlock;
import net.dries007.tfc.common.blocks.wood.TFCLeavesBlock;
import net.dries007.tfc.common.blocks.wood.TFCSaplingBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.Nullable;

public enum TreeSpecies implements RegistryTreeSpecies
{
    GUM_ARABIC(false, 8, 196, 0.0292f),
    ACACIA_KOA(false, 16, 180, 0.0193f),
    POPLAR(false, 8, 250, 0.014f),
    MPINGO_BLACKWOOD(false, 11, 200, 0.0292f),
    HARDY_CHESTNUT(false, 8, 180, 0.0179f),
    MOUNTAIN_FIR(true, 11, 0, 0.0543f),
    BALSAM_FIR(true, 13, 0, 0.0511f),
    SCRUB_HICKORY(false, 7, 220, 0.078f),
    RED_SILK_COTTON(false, 18, 150, 0.0089f),
    BIGLEAF_MAPLE(false, 9, 215, 0.0175f),
    WEEPING_MAPLE(true, 9, 0, 0.0545f),
    BLACK_OAK(false, 14, 180, 0.0174f),
    LIVE_OAK(false, 10, 155, 0.0175f),
    JAGGERY_PALM(false, 6, 249, 0.0447f),
    STONE_PINE(true, 11, 0, 0.0283f),
    RED_PINE(true, 8, 0, 0.0248f),
    TAMARACK(false, 8, 254, 0.0511f),
    HUANGSHAN_PINE(true, 9, 0, 0.0541f),
    GIANT_ROSEWOOD(false, 16, 190, 0.0127f),
    COAST_REDWOOD(true, 10, 0, 0.0132f),
    DAWN_REDWOOD(true, 9, 0, 0.0248f),
    COAST_SPRUCE(true, 8, 0, 0.0238f),
    SITKA_SPRUCE(true, 10, 0, 0.0543f),
    BLACK_SPRUCE(true, 12, 0, 0.0318f),
    ATLAS_CEDAR(true, 10, 0, 0.021f),
    WEEPING_WILLOW(false, 16, 240, 0.0107f),
    RAINBOW_EUCALYPTUS(false, 16, 30, 0.0145f),
    MOUNTAIN_ASH(false, 13, 150, 0.014f),
    RUBBER_FIG(false, 13, 80, 0.0127f),
    REDCEDAR(true, 10, 0, 0.0132f),
    WEEPING_CYPRESS(true, 7, 0, 0.0591f),
    BALD_CYPRESS(false, 7, 130, 0.0543f),
    JUNIPER(true, 8, 0, 0.0474f),
    SAPELE_MAHOGANY(false, 14, 170, 0.0089f),
    SMALL_LEAF_MAHOGANY(false, 11, 240, 0.0175f),
    IROKO_TEAK(false, 13, 140, 0.0089f),
    FLAME_OF_THE_FOREST(false, 11, 0, 0.0428f),
    LEBOMBO_IRONWOOD(false, 8, 230, 0.0472f),
    HORSETAIL_IRONWOOD(false, 10, 220, 0.0447f),
    KAURI(true, 22, 0, 0.024f),
    COLUMNAR_ARAUCARIA(true, 9, 0, 0.0305f),
    PARANA(true, 11, 0, 0.0554f),
    RAULI_BEECH(false, 10, 40, 0.0209f),
    BLACK_BEECH(false, 10, 200, 0.0201f),
    CHINQUAPIN(false, 7, 130, 0.035f);

    public static final TreeSpecies[] VALUES;
    private final String serializedName = this.name().toLowerCase(Locale.ROOT);
    private final int autumnIndex;
    private final TreeGrower tree;
    private final int daysToGrow;
    private final boolean conifer;
    private final float saplingDropRate;

    private TreeSpecies(boolean conifer, int daysToGrow, int autumnIndex, float saplingDropChance) {
        this.autumnIndex = autumnIndex;
        this.tree = new TreeGrower(Helpers.identifier((String)this.serializedName).toString(), Optional.empty(), Optional.of(ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)Helpers.identifier((String)("tree/" + this.serializedName)))), Optional.empty());
        this.conifer = conifer;
        this.daysToGrow = daysToGrow;
        this.saplingDropRate = saplingDropChance;
    }

    @Override
    public int autumnIndex() {
        return this.autumnIndex;
    }

    public float getSaplingDropRate() {
        return this.saplingDropRate;
    }

    public String getSerializedName() {
        return this.serializedName;
    }

    public boolean isConifer() {
        return this.conifer;
    }

    @Override
    public TreeGrower tree() {
        return this.tree;
    }

    @Override
    public int daysToGrow() {
        return this.defaultDaysToGrow();
    }

    public int defaultDaysToGrow() {
        return this.daysToGrow;
    }

    @Override
    public Supplier<Block> getBlock(BlockType type) {
        return (Supplier)((Object)AFCBlocks.TREE_SPECIES.get(this).get((Object)type));
    }

    public boolean hasBlossomingSeason() {
        return this.serializedName.equals("flame_of_the_forest") || this.serializedName.equals("giant_rosewood") || this.serializedName.equals("red_silk_cotton");
    }

    static {
        VALUES = TreeSpecies.values();
    }

    public static enum BlockType {
        LEAVES((self, wood) -> new TFCLeavesBlock(ExtendedProperties.of().mapColor(MapColor.PLANT).strength(0.5f).sound(SoundType.GRASS).defaultInstrument().randomTicks().noOcclusion().isViewBlocking(TFCBlocks::never).flammableLikeLeaves(), wood.autumnIndex(), wood.getBlock(self.fallenLeaves()), null){}, false),
        SAPLING((self, wood) -> new TFCSaplingBlock(wood.tree(), ExtendedProperties.of((MapColor)MapColor.PLANT).noCollission().randomTicks().strength(0.0f).sound(SoundType.GRASS).flammableLikeLeaves().blockEntity((Supplier)TFCBlockEntities.TICK_COUNTER), wood::daysToGrow, wood == JAGGERY_PALM), false),
        POTTED_SAPLING((self, wood) -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, wood.getBlock(SAPLING), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POTTED_ACACIA_SAPLING)), false),
        FALLEN_LEAVES((self, wood) -> new FallenLeavesBlock(ExtendedProperties.of().strength(0.05f, 0.0f).noOcclusion().noCollission().isViewBlocking(TFCBlocks::never).sound(SoundType.CROP).flammableLikeWool(), wood.getBlock(self.leaves())), false);

        private final BiFunction<Block, Item.Properties, ? extends BlockItem> blockItemFactory;
        private final boolean isPlanksVariant;
        private final BiFunction<BlockType, RegistryTreeSpecies, Block> blockFactory;

        private static ExtendedProperties properties(RegistryTreeSpecies wood) {
            return ExtendedProperties.of((MapColor)MapColor.WOOD).sound(SoundType.WOOD);
        }

        private static ExtendedProperties properties(AFCWood wood) {
            return ExtendedProperties.of((MapColor)MapColor.WOOD).sound(SoundType.WOOD);
        }

        private BlockType fallenLeaves() {
            return FALLEN_LEAVES;
        }

        private BlockType leaves() {
            return LEAVES;
        }

        private BlockType(BiFunction<BlockType, RegistryTreeSpecies, Block> blockFactory, boolean isPlanksVariant) {
            this(blockFactory, isPlanksVariant, BlockItem::new);
        }

        private BlockType(BiFunction<BlockType, RegistryTreeSpecies, Block> blockFactory, boolean isPlanksVariant, BiFunction<Block, Item.Properties, ? extends BlockItem> blockItemFactory) {
            this.blockFactory = blockFactory;
            this.isPlanksVariant = isPlanksVariant;
            this.blockItemFactory = blockItemFactory;
        }

        @Nullable
        public Function<Block, BlockItem> createBlockItem(Item.Properties properties) {
            return this.needsItem() ? block -> this.blockItemFactory.apply((Block)block, properties) : null;
        }

        public boolean needsItem() {
            return this != POTTED_SAPLING;
        }

        public Object nameFor(TreeSpecies wood) {
            return (this.isPlanksVariant ? "wood/planks/" + wood.getSerializedName() + "_" + this.name() : "wood/" + this.name() + "/" + wood.getSerializedName()).toLowerCase(Locale.ROOT);
        }

        public Supplier<Block> create(RegistryTreeSpecies wood) {
            return () -> this.blockFactory.apply(this, wood);
        }

        public String nameFor(RegistryTreeSpecies wood) {
            return ("wood/" + this.name() + "/" + wood.getSerializedName()).toLowerCase(Locale.ROOT);
        }
    }
}

