/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.afc.common.items;

import com.therighthon.afc.common.blocks.AFCBlocks;
import com.therighthon.afc.common.blocks.AFCWood;
import com.therighthon.afc.common.entities.AFCEntities;
import com.therighthon.afc.common.fluids.AFCFluidId;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.common.entities.TFCEntities;
import net.dries007.tfc.common.items.TFCBoatItem;
import net.dries007.tfc.common.items.TFCMinecartItem;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.registry.RegistryHolder;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class AFCItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"afc");
    public static final Map<AFCWood, ItemId> LUMBER = Helpers.mapOf(AFCWood.class, wood -> AFCItems.register("wood/lumber/" + wood.name()));
    public static final Map<AFCWood, ItemId> SUPPORTS = Helpers.mapOf(AFCWood.class, wood -> AFCItems.register("wood/support/" + wood.name(), () -> new StandingAndWallBlockItem((Block)AFCBlocks.WOODS.get(wood).get(Wood.BlockType.VERTICAL_SUPPORT).get(), (Block)AFCBlocks.WOODS.get(wood).get(Wood.BlockType.HORIZONTAL_SUPPORT).get(), new Item.Properties(), Direction.DOWN)));
    public static final Map<AFCWood, ItemId> BOATS = Helpers.mapOf(AFCWood.class, wood -> AFCItems.register("wood/boat/" + wood.name(), () -> new TFCBoatItem((Supplier)((Object)AFCEntities.BOATS.get(wood)), new Item.Properties())));
    public static final Map<AFCWood, ItemId> CHEST_MINECARTS = Helpers.mapOf(AFCWood.class, wood -> AFCItems.register("wood/chest_minecart/" + wood.name(), () -> new TFCMinecartItem(new Item.Properties(), (Supplier)TFCEntities.CHEST_MINECART, () -> ((Block)AFCBlocks.WOODS.get(wood).get(Wood.BlockType.CHEST).get()).asItem())));
    public static final Map<AFCWood, ItemId> SIGNS = Helpers.mapOf(AFCWood.class, wood -> AFCItems.register("wood/sign/" + wood.name(), () -> new SignItem(new Item.Properties(), (Block)AFCBlocks.WOODS.get(wood).get(Wood.BlockType.SIGN).get(), (Block)AFCBlocks.WOODS.get(wood).get(Wood.BlockType.WALL_SIGN).get())));
    public static final Map<AFCWood, Map<Metal, ItemId>> HANGING_SIGNS = Helpers.mapOf(AFCWood.class, wood -> Helpers.mapOf(Metal.class, Metal::allParts, metal -> AFCItems.register("wood/hanging_sign/" + metal.name() + "/" + wood.name(), () -> new HangingSignItem((Block)AFCBlocks.CEILING_HANGING_SIGNS.get(wood).get(metal).get(), (Block)AFCBlocks.WALL_HANGING_SIGNS.get(wood).get(metal).get(), new Item.Properties()))));
    public static final Map<AFCFluidId, ItemId> FLUID_BUCKETS = AFCFluidId.mapOf(fluid -> AFCItems.register("bucket/" + fluid.name(), () -> new BucketItem(fluid.fluid().get(), new Item.Properties().craftRemainder(Items.BUCKET).stacksTo(1))));
    public static final ItemId RUBBER_BAR = AFCItems.register("rubber_bar");
    public static final ItemId MAPLE_SUGAR = AFCItems.register("maple_sugar");
    public static final ItemId BIRCH_SUGAR = AFCItems.register("birch_sugar");

    private static ItemId register(String name) {
        return AFCItems.register(name, () -> new Item(new Item.Properties()));
    }

    private static <T extends Item> ItemId register(String name, Supplier<T> item) {
        return new ItemId((DeferredHolder<Item, Item>)ITEMS.register(name.toLowerCase(Locale.ROOT), item));
    }

    public record ItemId(DeferredHolder<Item, Item> holder) implements RegistryHolder<Item, Item>,
    ItemLike
    {
        public Item asItem() {
            return (Item)this.get();
        }
    }
}

