/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.afc.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.therighthon.afc.common.recipe.AFCRecipeSerializers;
import com.therighthon.afc.common.recipe.AFCRecipeTypes;
import com.therighthon.afc.common.recipe.TapInventory;
import javax.annotation.Nullable;
import net.dries007.tfc.common.recipes.ISimpleRecipe;
import net.dries007.tfc.common.recipes.ingredients.BlockIngredient;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;

public class TreeTapRecipe
implements ISimpleRecipe<TapInventory> {
    private final Boolean requireNaturalLog;
    private final FluidStack output;
    private final BlockIngredient ingredient;
    private final Boolean springOnly;
    private final float minTemp;
    private final float maxTemp;
    public static final IndirectHashCollection<Block, TreeTapRecipe> CACHE = IndirectHashCollection.createForRecipe(recipe -> recipe.getIngredient().blocks(), AFCRecipeTypes.TREE_TAPPING_RECIPE);

    public TreeTapRecipe(FluidStack output, BlockIngredient ingredient, Boolean requireNaturalLog, Boolean springOnly, float minTemp, float maxTemp) {
        this.output = output;
        this.ingredient = ingredient;
        this.requireNaturalLog = requireNaturalLog;
        this.springOnly = springOnly;
        this.minTemp = minTemp;
        this.maxTemp = maxTemp;
    }

    @Nullable
    public static TreeTapRecipe getRecipe(BlockState state) {
        for (TreeTapRecipe recipe : CACHE.getAll((Object)state.getBlock())) {
            if (!recipe.matches(state)) continue;
            return recipe;
        }
        return null;
    }

    public boolean matches(TapInventory inv, Level level) {
        return this.matches(inv.getState());
    }

    public ItemStack assemble(TapInventory tapInventory, HolderLookup.Provider provider) {
        return null;
    }

    public boolean matches(BlockState state) {
        return this.ingredient.test(state);
    }

    public float getMinTemp() {
        return this.minTemp;
    }

    public float getMaxTemp() {
        return this.maxTemp;
    }

    public Boolean springOnly() {
        return this.springOnly;
    }

    public BlockIngredient getIngredient() {
        return this.ingredient;
    }

    public FluidStack getOutput() {
        return this.output;
    }

    public Boolean requiresNaturalLog() {
        return this.requireNaturalLog;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)AFCRecipeSerializers.TREE_TAPPING.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)AFCRecipeTypes.TREE_TAPPING_RECIPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<TreeTapRecipe> {
        public static final MapCodec<TreeTapRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)FluidStack.CODEC.fieldOf("result_fluid").forGetter(c -> c.output), (App)BlockIngredient.CODEC.fieldOf("input_block").forGetter(c -> c.ingredient), (App)Codec.BOOL.optionalFieldOf("requires_natural_log", (Object)Boolean.TRUE).forGetter(c -> c.requireNaturalLog), (App)Codec.BOOL.optionalFieldOf("spring_only", (Object)Boolean.FALSE).forGetter(c -> c.springOnly), (App)Codec.FLOAT.optionalFieldOf("minimum_temperature", (Object)Float.valueOf(Float.MIN_VALUE)).forGetter(c -> Float.valueOf(c.minTemp)), (App)Codec.FLOAT.optionalFieldOf("maximum_temperature", (Object)Float.valueOf(Float.MAX_VALUE)).forGetter(c -> Float.valueOf(c.maxTemp))).apply((Applicative)i, TreeTapRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, TreeTapRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)FluidStack.STREAM_CODEC, c -> c.output, (StreamCodec)BlockIngredient.STREAM_CODEC, c -> c.ingredient, (StreamCodec)ByteBufCodecs.BOOL, c -> c.requireNaturalLog, (StreamCodec)ByteBufCodecs.BOOL, c -> c.springOnly, (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.minTemp), (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.maxTemp), TreeTapRecipe::new);

        public MapCodec<TreeTapRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, TreeTapRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

